/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.DiscoveryAgent;
import org.apache.openejb.server.DiscoveryListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoveryRegistry
implements DiscoveryListener,
DiscoveryAgent {
    private final List<DiscoveryAgent> agents = new ArrayList<DiscoveryAgent>();
    private final List<DiscoveryListener> listeners = new ArrayList<DiscoveryListener>();
    private final Map<String, URI> services = new ConcurrentHashMap<String, URI>();
    private final Map<String, URI> registered = new ConcurrentHashMap<String, URI>();
    private final Executor executor = new ThreadPoolExecutor(1, 10, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

        public Thread newThread(Runnable runable) {
            Thread t = new Thread(runable, DiscoveryRegistry.class.getSimpleName());
            t.setDaemon(true);
            return t;
        }
    });

    public DiscoveryRegistry() {
        SystemInstance.get().setComponent(DiscoveryRegistry.class, (Object)this);
        SystemInstance.get().setComponent(DiscoveryAgent.class, (Object)this);
    }

    public DiscoveryRegistry(DiscoveryAgent agent) {
        SystemInstance.get().setComponent(DiscoveryRegistry.class, (Object)this);
        SystemInstance.get().setComponent(DiscoveryAgent.class, (Object)this);
        this.addDiscoveryAgent(agent);
    }

    public void addDiscoveryAgent(DiscoveryAgent agent) {
        this.agents.add(agent);
        agent.setDiscoveryListener(this);
        for (URI uri : this.registered.values()) {
            try {
                agent.registerService(uri);
            }
            catch (IOException e) {}
        }
    }

    public Set<URI> getServices() {
        return new HashSet<URI>(this.services.values());
    }

    @Override
    public void registerService(URI serviceUri) throws IOException {
        this.registered.put(serviceUri.toString(), serviceUri);
        for (DiscoveryAgent agent : this.agents) {
            agent.registerService(serviceUri);
        }
    }

    @Override
    public void reportFailed(URI serviceUri) throws IOException {
        this.registered.remove(serviceUri.toString());
        for (DiscoveryAgent agent : this.agents) {
            agent.reportFailed(serviceUri);
        }
    }

    @Override
    public void unregisterService(URI serviceUri) throws IOException {
        this.registered.remove(serviceUri.toString());
        for (DiscoveryAgent agent : this.agents) {
            agent.unregisterService(serviceUri);
        }
    }

    @Override
    public void setDiscoveryListener(DiscoveryListener listener) {
        this.addDiscoveryListener(listener);
    }

    public void addDiscoveryListener(DiscoveryListener listener) {
        for (URI service : this.services.values()) {
            this.executor.execute(new ServiceAddedTask(listener, service));
        }
        this.listeners.add(listener);
    }

    public void removeDiscoveryListener(DiscoveryListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void serviceAdded(URI service) {
        this.services.put(service.toString(), service);
        for (DiscoveryListener discoveryListener : this.getListeners()) {
            this.executor.execute(new ServiceAddedTask(discoveryListener, service));
        }
    }

    @Override
    public void serviceRemoved(URI service) {
        for (DiscoveryListener discoveryListener : this.getListeners()) {
            this.executor.execute(new ServiceRemovedTask(discoveryListener, service));
        }
    }

    List<DiscoveryListener> getListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    private static class ServiceAddedTask
    extends Task {
        public ServiceAddedTask(DiscoveryListener discoveryListener, URI service) {
            super(discoveryListener, service);
        }

        public void run() {
            if (this.discoveryListener != null) {
                this.discoveryListener.serviceAdded(this.service);
            }
        }
    }

    private static class ServiceRemovedTask
    extends Task {
        public ServiceRemovedTask(DiscoveryListener discoveryListener, URI service) {
            super(discoveryListener, service);
        }

        public void run() {
            if (this.discoveryListener != null) {
                this.discoveryListener.serviceRemoved(this.service);
            }
        }
    }

    private static abstract class Task
    implements Runnable {
        protected final DiscoveryListener discoveryListener;
        protected final URI service;

        protected Task(DiscoveryListener discoveryListener, URI service) {
            this.discoveryListener = discoveryListener;
            this.service = service;
        }
    }
}

