/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.tutorial.modell.internal.base;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.faktorips.runtime.AssociationChangedEvent;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.IValidationContext;
import org.faktorips.runtime.IpsPropertyChangeSupport;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.AbstractConfigurableModelObject;
import org.faktorips.runtime.internal.AbstractModelObject;
import org.faktorips.tutorial.modell.base.IDeckung;
import org.faktorips.tutorial.modell.base.IProdukt;
import org.faktorips.tutorial.modell.base.IProduktGen;
import org.faktorips.tutorial.modell.base.IVertrag;
import org.faktorips.values.DateUtil;
import org.faktorips.values.Decimal;
import org.faktorips.values.Money;
import org.faktorips.valueset.OrderedValueSet;
import org.w3c.dom.Element;

@XmlRootElement(name="Vertrag")
public abstract class Vertrag
extends AbstractConfigurableModelObject
implements IVertrag {
    protected final IpsPropertyChangeSupport propertyChangeSupport = new IpsPropertyChangeSupport((Object)this);
    @XmlElement(name="zahlweise", nillable=true)
    private Integer zahlweise = new Integer(1);
    @XmlElement(name="jahresbasisbeitrag", nillable=true)
    private Money jahresbasisbeitrag = Money.NULL;
    @XmlElement(name="nettobeitragZw", nillable=true)
    private Money nettobeitragZw = Money.NULL;
    @XmlElement(name="bruttobeitragZw", nillable=true)
    private Money bruttobeitragZw = Money.NULL;
    @XmlElement(name="wirksamAb", nillable=true)
    private GregorianCalendar wirksamAb = null;

    public Vertrag() {
    }

    public Vertrag(IProdukt productCmpt) {
        super((IProductComponent)productCmpt);
    }

    public String getProduktname() {
        return this.getProduktGen().getProduktname();
    }

    @Override
    public OrderedValueSet<Integer> getAllowedValuesForZahlweise(IValidationContext context) {
        return this.getProduktGen().getAllowedValuesForZahlweise(context);
    }

    @Override
    public Integer getZahlweise() {
        return this.zahlweise;
    }

    @Override
    public void setZahlweise(Integer newValue) {
        Integer oldZahlweise = this.zahlweise;
        this.zahlweise = newValue;
        this.notifyChangeListeners(new PropertyChangeEvent(this, "zahlweise", oldZahlweise, this.zahlweise));
    }

    @Override
    public Money getJahresbasisbeitrag() {
        return this.jahresbasisbeitrag;
    }

    @Override
    public Money getNettobeitragZw() {
        return this.nettobeitragZw;
    }

    @Override
    public Money getBruttobeitragZw() {
        return this.bruttobeitragZw;
    }

    @Override
    public GregorianCalendar getWirksamAb() {
        return this.wirksamAb == null ? null : (GregorianCalendar)this.wirksamAb.clone();
    }

    @Override
    public void setWirksamAb(GregorianCalendar newValue) {
        GregorianCalendar oldWirksamAb = this.wirksamAb;
        this.wirksamAb = newValue == null ? null : (GregorianCalendar)newValue.clone();
        this.notifyChangeListeners(new PropertyChangeEvent(this, "wirksamAb", oldWirksamAb, this.wirksamAb));
    }

    @Override
    public boolean containsDeckung(IDeckung objectToTest) {
        return this.getDeckungen().contains(objectToTest);
    }

    public void initialize() {
        if (this.getProduktGen() == null) {
            return;
        }
        this.zahlweise = this.getProduktGen().getDefaultValueZahlweise();
    }

    @Override
    public IProdukt getProdukt() {
        return (IProdukt)this.getProductComponent();
    }

    @Override
    public IProduktGen getProduktGen() {
        return (IProduktGen)this.getProductCmptGeneration();
    }

    @Override
    public void setProdukt(IProdukt produkt, boolean initPropertiesWithConfiguratedDefaults) {
        this.setProductComponent(produkt);
        if (initPropertiesWithConfiguratedDefaults) {
            this.initialize();
        }
    }

    public void effectiveFromHasChanged() {
        super.effectiveFromHasChanged();
    }

    public Calendar getEffectiveFromAsCalendar() {
        return this.wirksamAb;
    }

    public void notifyChangeListeners(PropertyChangeEvent event) {
        if (event instanceof AssociationChangedEvent) {
            this.propertyChangeSupport.fireAssociationChange((AssociationChangedEvent)event);
        } else {
            this.propertyChangeSupport.firePropertyChange(event);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener, boolean propagateEventsFromChildren) {
        this.propertyChangeSupport.addPropertyChangeListener(listener, propagateEventsFromChildren);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public boolean hasListeners(String propertyName) {
        return this.propertyChangeSupport.hasListeners(propertyName);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    protected void initPropertiesFromXml(Map<String, String> propMap, IRuntimeRepository productRepository) {
        super.initPropertiesFromXml(propMap, productRepository);
        if (propMap.containsKey("zahlweise")) {
            Integer n = this.zahlweise = propMap.get("zahlweise") == null || propMap.get("zahlweise").equals("") ? null : new Integer(propMap.get("zahlweise"));
        }
        if (propMap.containsKey("jahresbasisbeitrag")) {
            this.jahresbasisbeitrag = Money.valueOf((String)propMap.get("jahresbasisbeitrag"));
        }
        if (propMap.containsKey("nettobeitragZw")) {
            this.nettobeitragZw = Money.valueOf((String)propMap.get("nettobeitragZw"));
        }
        if (propMap.containsKey("bruttobeitragZw")) {
            this.bruttobeitragZw = Money.valueOf((String)propMap.get("bruttobeitragZw"));
        }
        if (propMap.containsKey("wirksamAb")) {
            this.wirksamAb = propMap.get("wirksamAb") == null || propMap.get("wirksamAb").equals("") ? null : DateUtil.parseIsoDateStringToGregorianCalendar((String)propMap.get("wirksamAb"));
        }
    }

    protected AbstractModelObject createChildFromXml(Element childEl) {
        AbstractModelObject newChild = super.createChildFromXml(childEl);
        if (newChild != null) {
            return newChild;
        }
        return null;
    }

    public boolean validateSelf(MessageList ml, IValidationContext context) {
        return super.validateSelf(ml, context);
    }

    public void validateDependants(MessageList ml, IValidationContext context) {
        super.validateDependants(ml, context);
        if (this.getNumOfDeckungen() > 0) {
            for (IDeckung rel : this.getDeckungen()) {
                ml.add(rel.validate(context));
            }
        }
    }

    @Override
    public void berechneBeitrag() {
        Money oldValue = this.bruttobeitragZw;
        this.berechneJahresbasisbeitrag();
        this.berechneNettobeitragZw();
        Decimal versSteuerFaktor = Decimal.valueOf((long)119L, (int)2);
        this.bruttobeitragZw = this.nettobeitragZw.multiply(versSteuerFaktor, 4);
        this.notifyChangeListeners(new PropertyChangeEvent(this, "bruttobeitragZw", oldValue, this.bruttobeitragZw));
    }

    private void berechneJahresbasisbeitrag() {
        Money oldValue = this.jahresbasisbeitrag;
        this.jahresbasisbeitrag = Money.euro((long)0L, (int)0);
        List deckungen = this.getDeckungen();
        int i = 0;
        while (i < deckungen.size()) {
            IDeckung deckung = (IDeckung)deckungen.get(i);
            deckung.berechneJahresbasisbeitrag();
            this.jahresbasisbeitrag = this.jahresbasisbeitrag.add(deckung.getJahresbasisbeitrag());
            ++i;
        }
        this.notifyChangeListeners(new PropertyChangeEvent(this, "jahresbasisbeitrag", oldValue, this.jahresbasisbeitrag));
    }

    private void berechneNettobeitragZw() {
        Money oldValue = this.nettobeitragZw;
        if (this.zahlweise == null) {
            this.nettobeitragZw = Money.NULL;
            return;
        }
        if (this.zahlweise == 1) {
            this.nettobeitragZw = this.jahresbasisbeitrag;
        } else {
            Decimal rzFaktor = Decimal.valueOf((long)103L, (int)2);
            this.nettobeitragZw = this.jahresbasisbeitrag.multiply(rzFaktor, 4);
        }
        this.nettobeitragZw = this.nettobeitragZw.divide(this.zahlweise.intValue(), 4);
        this.notifyChangeListeners(new PropertyChangeEvent(this, "nettobeitragZw", oldValue, this.nettobeitragZw));
    }
}

