/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.apache.log4j.PropertyConfigurator;
import org.apache.openejb.loader.FileUtils;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.JuliLogStream;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.LogStream;
import org.apache.openejb.util.LogStreamFactory;

public class JuliLogStreamFactory
implements LogStreamFactory {
    private static final String LOGGING_PROPERTIES_FILE = "logging.properties";
    private static final String DEFAULT_LOGGING_PROPERTIES_FILE = "juli.properties";
    private static final String EMBEDDED_PROPERTIES_FILE = "embedded.juli.properties";

    public LogStream createLogStream(LogCategory logCategory) {
        return new JuliLogStream(logCategory);
    }

    public JuliLogStreamFactory() {
        try {
            String prop = System.getProperty("openejb.logger.external", "false");
            boolean externalLogging = Boolean.parseBoolean(prop);
            if (!externalLogging) {
                this.configureInternal();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void configureInternal() throws IOException {
        File confDir = SystemInstance.get().getBase().getDirectory("conf");
        File loggingPropertiesFile = new File(confDir, LOGGING_PROPERTIES_FILE);
        if (confDir.exists()) {
            if (loggingPropertiesFile.exists()) {
                FileInputStream in = null;
                try {
                    in = new FileInputStream(loggingPropertiesFile);
                    LogManager.getLogManager().readConfiguration(in);
                    Object var5_4 = null;
                    if (in == null) return;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (in == null) throw throwable;
                    try {
                        in.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    in.close();
                    return;
                }
                catch (IOException e) {}
                return;
            }
            this.installLoggingPropertiesFile(loggingPropertiesFile);
            return;
        }
        this.configureEmbedded();
    }

    private void preprocessProperties(Properties properties) {
        FileUtils base = SystemInstance.get().getBase();
        File confDir = new File(base.getDirectory(), "conf");
        File baseDir = base.getDirectory();
        File userDir = new File("foo").getParentFile();
        File[] paths = new File[]{confDir, baseDir, userDir};
        ArrayList<File> missing = new ArrayList<File>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!key.endsWith(".File")) continue;
            boolean found = false;
            for (int i = 0; i < paths.length && !found; ++i) {
                File path = paths[i];
                File logfile = new File(path, value);
                if (!logfile.getParentFile().exists()) continue;
                properties.setProperty(key, logfile.getAbsolutePath());
                found = true;
            }
            if (found) continue;
            File logfile = new File(paths[0], value);
            missing.add(logfile);
        }
        if (missing.size() > 0) {
            Logger logger = this.getFallabckLogger();
            logger.severe("Logging may not operate as expected.  The directories for the following files do not exist so no file can be created.  See the list below.");
            for (int i = 0; i < missing.size(); ++i) {
                File file = (File)missing.get(i);
                logger.severe("[" + i + "] " + file.getAbsolutePath());
            }
        }
    }

    private Logger getFallabckLogger() {
        Logger logger = Logger.getLogger("OpenEJB.logging");
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setFormatter(new SimpleFormatter());
        logger.addHandler(consoleHandler);
        return logger;
    }

    private void configureEmbedded() {
        URL resource = Thread.currentThread().getContextClassLoader().getResource(EMBEDDED_PROPERTIES_FILE);
        if (resource != null) {
            PropertyConfigurator.configure((URL)resource);
        } else {
            System.out.println("FATAL ERROR WHILE CONFIGURING LOGGING!!!. MISSING embedded.logging.properties FILE ");
        }
    }

    private void installLoggingPropertiesFile(File loggingPropertiesFile) throws IOException {
        URL resource = Thread.currentThread().getContextClassLoader().getResource(DEFAULT_LOGGING_PROPERTIES_FILE);
        if (resource == null) {
            System.out.println("FATAL ERROR WHILE CONFIGURING LOGGING!!!. MISSING logging.properties FILE ");
            return;
        }
        InputStream in = resource.openStream();
        in = new BufferedInputStream(in);
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        int count = in.read(buf);
        while (count >= 0) {
            bao.write(buf, 0, count);
            count = in.read(buf);
        }
        byte[] byteArray = bao.toByteArray();
        ByteArrayInputStream bis = new ByteArrayInputStream(byteArray);
        Properties props = new Properties();
        props.load(bis);
        this.preprocessProperties(props);
        BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(loggingPropertiesFile));
        bout.write(byteArray);
        PropertyConfigurator.configure((Properties)props);
        try {
            bout.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            in.close();
        }
        catch (IOException e) {
            // empty catch block
        }
    }
}

