/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.timer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.ejb.EJBException;
import javax.transaction.TransactionManager;
import org.apache.openejb.DeploymentInfo;
import org.apache.openejb.core.BaseContext;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.timer.EjbTimerService;
import org.apache.openejb.core.timer.MemoryTimerStore;
import org.apache.openejb.core.timer.TimerData;
import org.apache.openejb.core.timer.TimerStore;
import org.apache.openejb.core.timer.TimerStoreException;
import org.apache.openejb.core.transaction.TransactionType;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbTimerServiceImpl
implements EjbTimerService {
    private static final Logger log = Logger.getInstance(LogCategory.TIMER, "org.apache.openejb.util.resources");
    private final TransactionManager transactionManager;
    private final DeploymentInfo deployment;
    private final boolean transacted;
    private final int retryAttempts;
    private final TimerStore timerStore;
    private final Executor threadPool;
    private Timer timer;

    public EjbTimerServiceImpl(DeploymentInfo deployment) {
        this(deployment, EjbTimerServiceImpl.getDefaultTransactionManager(), EjbTimerServiceImpl.getDefaultExecutor(), new MemoryTimerStore(EjbTimerServiceImpl.getDefaultTransactionManager()), 1);
    }

    public static Executor getDefaultExecutor() {
        Executor executor = SystemInstance.get().getComponent(Executor.class);
        if (executor == null) {
            executor = Executors.newFixedThreadPool(10);
            SystemInstance.get().setComponent(Executor.class, executor);
        }
        return executor;
    }

    public static TransactionManager getDefaultTransactionManager() {
        return SystemInstance.get().getComponent(TransactionManager.class);
    }

    public EjbTimerServiceImpl(DeploymentInfo deployment, TransactionManager transactionManager, Executor threadPool, TimerStore timerStore, int retryAttempts) {
        if (deployment.getEjbTimeout() == null) {
            throw new IllegalArgumentException("Ejb does not have an ejbTimeout method " + deployment.getDeploymentID());
        }
        this.deployment = deployment;
        this.transactionManager = transactionManager;
        this.threadPool = threadPool;
        this.timerStore = timerStore;
        TransactionType transactionType = deployment.getTransactionType(deployment.getEjbTimeout());
        this.transacted = transactionType == TransactionType.Required || transactionType == TransactionType.RequiresNew;
        this.retryAttempts = retryAttempts;
    }

    @Override
    public void start() throws TimerStoreException {
        Collection<TimerData> timerDatas = this.timerStore.loadTimers(this, (String)this.deployment.getDeploymentID());
        this.timer = new Timer(true);
        for (TimerData timerData : timerDatas) {
            this.schedule(timerData);
        }
    }

    @Override
    public void stop() {
        for (TimerData timerData : this.timerStore.getTimers((String)this.deployment.getDeploymentID())) {
            timerData.stop();
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void schedule(TimerData timerData) {
        if (this.timer == null) {
            throw new IllegalStateException("Timer is stopped");
        }
        try {
            EjbTimeoutTimerTask timerTask = new EjbTimeoutTimerTask(timerData);
            timerData.setTimerTask(timerTask);
            if (timerData.isOneTime()) {
                this.timer.schedule((TimerTask)timerTask, timerData.getExpiration());
            } else {
                this.timer.scheduleAtFixedRate((TimerTask)timerTask, timerData.getExpiration(), timerData.getIntervalDuration());
            }
        }
        catch (Exception e) {
            log.warning("Could not schedule timer " + e.getMessage() + " at (now) " + System.currentTimeMillis() + " for " + timerData.getExpiration().getTime());
        }
    }

    public void cancelled(TimerData timerData) {
        this.timerStore.removeTimer(timerData.getId());
    }

    public void addTimerData(TimerData timerData) {
        try {
            this.timerStore.addTimerData(timerData);
        }
        catch (Exception e) {
            log.warning("Could not add timer " + e.getMessage() + " at (now) " + System.currentTimeMillis() + " for " + timerData.getExpiration().getTime());
        }
    }

    @Override
    public javax.ejb.Timer getTimer(long timerId) {
        TimerData timerData = this.timerStore.getTimer((String)this.deployment.getDeploymentID(), timerId);
        if (timerData != null) {
            return timerData.getTimer();
        }
        return null;
    }

    @Override
    public Collection<javax.ejb.Timer> getTimers(Object primaryKey) throws IllegalStateException {
        this.checkState();
        ArrayList<javax.ejb.Timer> timers = new ArrayList<javax.ejb.Timer>();
        for (TimerData timerData : this.timerStore.getTimers((String)this.deployment.getDeploymentID())) {
            javax.ejb.Timer timer = timerData.getTimer();
            timers.add(timer);
        }
        return timers;
    }

    @Override
    public javax.ejb.Timer createTimer(Object primaryKey, long duration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (duration < 0L) {
            throw new IllegalArgumentException("duration is negative: " + duration);
        }
        this.checkState();
        Date time = new Date(System.currentTimeMillis() + duration);
        try {
            TimerData timerData = this.createTimerData(primaryKey, time, 0L, info);
            return timerData.getTimer();
        }
        catch (TimerStoreException e) {
            throw new EJBException((Exception)e);
        }
    }

    @Override
    public javax.ejb.Timer createTimer(Object primaryKey, long initialDuration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (initialDuration < 0L) {
            throw new IllegalArgumentException("initialDuration is negative: " + initialDuration);
        }
        if (intervalDuration < 0L) {
            throw new IllegalArgumentException("intervalDuration is negative: " + intervalDuration);
        }
        this.checkState();
        Date time = new Date(System.currentTimeMillis() + initialDuration);
        try {
            TimerData timerData = this.createTimerData(primaryKey, time, intervalDuration, info);
            return timerData.getTimer();
        }
        catch (TimerStoreException e) {
            throw new EJBException((Exception)e);
        }
    }

    @Override
    public javax.ejb.Timer createTimer(Object primaryKey, Date expiration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (expiration == null) {
            throw new IllegalArgumentException("expiration is null");
        }
        if (expiration.getTime() < 0L) {
            throw new IllegalArgumentException("expiration is negative: " + expiration.getTime());
        }
        this.checkState();
        try {
            TimerData timerData = this.createTimerData(primaryKey, expiration, 0L, info);
            return timerData.getTimer();
        }
        catch (TimerStoreException e) {
            throw new EJBException((Exception)e);
        }
    }

    @Override
    public javax.ejb.Timer createTimer(Object primaryKey, Date initialExpiration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (initialExpiration == null) {
            throw new IllegalArgumentException("initialExpiration is null");
        }
        if (initialExpiration.getTime() < 0L) {
            throw new IllegalArgumentException("initialExpiration is negative: " + initialExpiration.getTime());
        }
        if (intervalDuration < 0L) {
            throw new IllegalArgumentException("intervalDuration is negative: " + intervalDuration);
        }
        this.checkState();
        try {
            TimerData timerData = this.createTimerData(primaryKey, initialExpiration, intervalDuration, info);
            return timerData.getTimer();
        }
        catch (TimerStoreException e) {
            throw new EJBException((Exception)e);
        }
    }

    private TimerData createTimerData(Object primaryKey, Date expiration, long intervalDuration, Object info) throws TimerStoreException {
        TimerData timerData = this.timerStore.createTimer(this, (String)this.deployment.getDeploymentID(), primaryKey, info, expiration, intervalDuration);
        timerData.newTimer();
        return timerData;
    }

    private void checkState() throws IllegalStateException {
        if (!BaseContext.isTimerMethodAllowed()) {
            throw new IllegalStateException("TimerService method not permitted for current operation " + ThreadContext.getThreadContext().getCurrentOperation().name());
        }
    }

    /*
     * Exception decompiling
     */
    private void ejbTimeout(TimerData timerData) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 20[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private class EjbTimeoutTimerTask
    extends TimerTask {
        private final TimerData timerData;

        public EjbTimeoutTimerTask(TimerData timerData) {
            this.timerData = timerData;
        }

        public void run() {
            EjbTimerServiceImpl.this.threadPool.execute(new Runnable(){

                public void run() {
                    EjbTimerServiceImpl.this.ejbTimeout(EjbTimeoutTimerTask.this.timerData);
                }
            });
        }
    }
}

