/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.stateless;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.ejb.EJBAccessException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.interceptor.AroundInvoke;
import javax.xml.rpc.handler.MessageContext;
import org.apache.openejb.ApplicationException;
import org.apache.openejb.ContainerType;
import org.apache.openejb.DeploymentInfo;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.ProxyInfo;
import org.apache.openejb.RpcContainer;
import org.apache.openejb.SystemException;
import org.apache.openejb.core.CoreDeploymentInfo;
import org.apache.openejb.core.ExceptionType;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.interceptor.InterceptorData;
import org.apache.openejb.core.interceptor.InterceptorStack;
import org.apache.openejb.core.stateless.Instance;
import org.apache.openejb.core.stateless.StatelessContext;
import org.apache.openejb.core.stateless.StatelessInstanceManager;
import org.apache.openejb.core.timer.EjbTimerService;
import org.apache.openejb.core.transaction.EjbTransactionUtil;
import org.apache.openejb.core.transaction.TransactionPolicy;
import org.apache.openejb.core.webservices.AddressingSupport;
import org.apache.openejb.core.webservices.NoAddressingSupport;
import org.apache.openejb.spi.SecurityService;
import org.apache.openejb.util.Duration;
import org.apache.xbean.finder.ClassFinder;

public class StatelessContainer
implements RpcContainer {
    private StatelessInstanceManager instanceManager;
    private HashMap<String, DeploymentInfo> deploymentRegistry = new HashMap();
    private Object containerID = null;
    private SecurityService securityService;

    public StatelessContainer(Object id, SecurityService securityService, int timeOut, int poolSize, boolean strictPooling) throws OpenEJBException {
        this.containerID = id;
        this.securityService = securityService;
        this.instanceManager = new StatelessInstanceManager(securityService, new Duration(timeOut, TimeUnit.MILLISECONDS), poolSize, strictPooling);
        for (DeploymentInfo deploymentInfo : this.deploymentRegistry.values()) {
            CoreDeploymentInfo di = (CoreDeploymentInfo)deploymentInfo;
            di.setContainer(this);
        }
    }

    public synchronized DeploymentInfo[] deployments() {
        return this.deploymentRegistry.values().toArray(new DeploymentInfo[this.deploymentRegistry.size()]);
    }

    public synchronized DeploymentInfo getDeploymentInfo(Object deploymentID) {
        String id = (String)deploymentID;
        return this.deploymentRegistry.get(id);
    }

    public ContainerType getContainerType() {
        return ContainerType.STATELESS;
    }

    public Object getContainerID() {
        return this.containerID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(DeploymentInfo info) throws OpenEJBException {
        CoreDeploymentInfo deploymentInfo = (CoreDeploymentInfo)info;
        this.instanceManager.deploy(deploymentInfo);
        String id = (String)deploymentInfo.getDeploymentID();
        StatelessContainer statelessContainer = this;
        synchronized (statelessContainer) {
            this.deploymentRegistry.put(id, deploymentInfo);
            deploymentInfo.setContainer(this);
        }
        EjbTimerService timerService = deploymentInfo.getEjbTimerService();
        if (timerService != null) {
            timerService.start();
        }
    }

    public void undeploy(DeploymentInfo info) {
        this.undeploy((CoreDeploymentInfo)info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undeploy(CoreDeploymentInfo deploymentInfo) {
        this.instanceManager.undeploy(deploymentInfo);
        EjbTimerService timerService = deploymentInfo.getEjbTimerService();
        if (timerService != null) {
            timerService.stop();
        }
        StatelessContainer statelessContainer = this;
        synchronized (statelessContainer) {
            String id = (String)deploymentInfo.getDeploymentID();
            deploymentInfo.setContainer(null);
            deploymentInfo.setContainerData(null);
            this.deploymentRegistry.remove(id);
        }
    }

    public Object invoke(Object deployID, Method callMethod, Object[] args, Object primKey, Object securityIdentity) throws OpenEJBException {
        return this.invoke(deployID, null, callMethod.getDeclaringClass(), callMethod, args, primKey);
    }

    public Object invoke(Object deployID, Class callInterface, Method callMethod, Object[] args, Object primKey) throws OpenEJBException {
        return this.invoke(deployID, null, callInterface, callMethod, args, primKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object deployID, InterfaceType type, Class callInterface, Method callMethod, Object[] args, Object primKey) throws OpenEJBException {
        Object object;
        ThreadContext oldCallContext;
        block20: {
            Object bean;
            ThreadContext callContext;
            block21: {
                Object retValue;
                CoreDeploymentInfo deployInfo;
                block17: {
                    Object var13_15;
                    block18: {
                        block19: {
                            Class<?> declaringClass;
                            block11: {
                                Object var13_14;
                                block15: {
                                    block16: {
                                        block12: {
                                            ProxyInfo proxyInfo;
                                            block13: {
                                                block14: {
                                                    deployInfo = (CoreDeploymentInfo)this.getDeploymentInfo(deployID);
                                                    if (deployInfo == null) {
                                                        throw new OpenEJBException("Deployment does not exist in this container. Deployment(id='" + deployID + "'), Container(id='" + this.containerID + "')");
                                                    }
                                                    if (type == null) {
                                                        type = deployInfo.getInterfaceType(callInterface);
                                                    }
                                                    callContext = new ThreadContext(deployInfo, primKey);
                                                    oldCallContext = ThreadContext.enter(callContext);
                                                    bean = null;
                                                    try {
                                                        boolean authorized = this.getSecurityService().isCallerAuthorized(callMethod, type);
                                                        if (!authorized) {
                                                            throw new ApplicationException((Exception)new EJBAccessException("Unauthorized Access by Principal Denied"));
                                                        }
                                                        declaringClass = callMethod.getDeclaringClass();
                                                        if (!EJBHome.class.isAssignableFrom(declaringClass) && !EJBLocalHome.class.isAssignableFrom(declaringClass)) break block11;
                                                        if (!callMethod.getName().startsWith("create")) break block12;
                                                        proxyInfo = this.createEJBObject(deployInfo, callMethod);
                                                        Object var17_17 = null;
                                                        if (bean == null) break block13;
                                                        if (!callContext.isDiscardInstance()) break block14;
                                                        this.instanceManager.discardInstance(callContext);
                                                        break block13;
                                                    }
                                                    catch (Throwable throwable) {
                                                        Object var17_21 = null;
                                                        if (bean != null) {
                                                            if (callContext.isDiscardInstance()) {
                                                                this.instanceManager.discardInstance(callContext);
                                                            } else {
                                                                this.instanceManager.poolInstance(callContext, bean);
                                                            }
                                                        }
                                                        ThreadContext.exit(oldCallContext);
                                                        throw throwable;
                                                    }
                                                }
                                                this.instanceManager.poolInstance(callContext, bean);
                                            }
                                            ThreadContext.exit(oldCallContext);
                                            return proxyInfo;
                                        }
                                        var13_14 = null;
                                        Object var17_18 = null;
                                        if (bean == null) break block15;
                                        if (!callContext.isDiscardInstance()) break block16;
                                        this.instanceManager.discardInstance(callContext);
                                        break block15;
                                    }
                                    this.instanceManager.poolInstance(callContext, bean);
                                }
                                ThreadContext.exit(oldCallContext);
                                return var13_14;
                            }
                            if (EJBObject.class != declaringClass && EJBLocalObject.class != declaringClass) break block17;
                            var13_15 = null;
                            Object var17_19 = null;
                            if (bean == null) break block18;
                            if (!callContext.isDiscardInstance()) break block19;
                            this.instanceManager.discardInstance(callContext);
                            break block18;
                        }
                        this.instanceManager.poolInstance(callContext, bean);
                    }
                    ThreadContext.exit(oldCallContext);
                    return var13_15;
                }
                bean = this.instanceManager.getInstance(callContext);
                callContext.setCurrentOperation(Operation.BUSINESS);
                callContext.setCurrentAllowedStates(StatelessContext.getStates());
                Method runMethod = deployInfo.getMatchingBeanMethod(callMethod);
                callContext.set(Method.class, runMethod);
                callContext.setInvokedInterface(callInterface);
                object = retValue = this._invoke(callMethod, runMethod, args, (Instance)bean, callContext, type);
                Object var17_20 = null;
                if (bean == null) break block20;
                if (!callContext.isDiscardInstance()) break block21;
                this.instanceManager.discardInstance(callContext);
                break block20;
            }
            this.instanceManager.poolInstance(callContext, bean);
        }
        ThreadContext.exit(oldCallContext);
        return object;
    }

    private SecurityService getSecurityService() {
        return this.securityService;
    }

    public StatelessInstanceManager getInstanceManager() {
        return this.instanceManager;
    }

    protected Object _invoke(Class callInterface, Method callMethod, Method runMethod, Object[] args, Object object, ThreadContext callContext) throws OpenEJBException {
        return this._invoke(callMethod, runMethod, args, (Instance)object, callContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected Object _invoke(Method callMethod, Method runMethod, Object[] args, Instance instance, ThreadContext callContext, InterfaceType type) throws OpenEJBException {
        Object returnValue;
        TransactionPolicy txPolicy;
        CoreDeploymentInfo deploymentInfo;
        block17: {
            deploymentInfo = callContext.getDeploymentInfo();
            txPolicy = EjbTransactionUtil.createTransactionPolicy(deploymentInfo.getTransactionType(callMethod), callContext);
            returnValue = null;
            if (type == InterfaceType.SERVICE_ENDPOINT) {
                callContext.setCurrentOperation(Operation.BUSINESS_WS);
                returnValue = this.invokeWebService(args, deploymentInfo, runMethod, instance, returnValue);
                break block17;
            }
            List<InterceptorData> interceptors = deploymentInfo.getMethodInterceptors(runMethod);
            InterceptorStack interceptorStack = new InterceptorStack(instance.bean, runMethod, Operation.BUSINESS, interceptors, instance.interceptors);
            returnValue = interceptorStack.invoke(args);
        }
        Object var13_14 = null;
        try {
            EjbTransactionUtil.afterInvoke(txPolicy, callContext);
        }
        catch (SystemException e) {
            callContext.setDiscardInstance(true);
            throw e;
        }
        catch (ApplicationException e) {
            throw e;
        }
        catch (RuntimeException e) {
            callContext.setDiscardInstance(true);
            throw e;
        }
        {
            catch (Throwable re) {
                ExceptionType exceptionType = deploymentInfo.getExceptionType(re);
                if (exceptionType == ExceptionType.SYSTEM) {
                    callContext.setDiscardInstance(true);
                    EjbTransactionUtil.handleSystemException(txPolicy, re, callContext);
                } else {
                    EjbTransactionUtil.handleApplicationException(txPolicy, re, exceptionType == ExceptionType.APPLICATION_ROLLBACK);
                }
                Object var13_15 = null;
                try {
                    EjbTransactionUtil.afterInvoke(txPolicy, callContext);
                }
                catch (SystemException e) {
                    callContext.setDiscardInstance(true);
                    throw e;
                }
                catch (ApplicationException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    callContext.setDiscardInstance(true);
                    throw e;
                }
            }
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            try {
                EjbTransactionUtil.afterInvoke(txPolicy, callContext);
            }
            catch (SystemException e) {
                callContext.setDiscardInstance(true);
                throw e;
            }
            catch (ApplicationException e) {
                throw e;
            }
            catch (RuntimeException e) {
                callContext.setDiscardInstance(true);
                throw e;
            }
            throw throwable;
        }
        return returnValue;
    }

    private Object invokeWebService(Object[] args, CoreDeploymentInfo deploymentInfo, Method runMethod, Instance instance, Object returnValue) throws Exception {
        if (args.length < 2) {
            throw new IllegalArgumentException("WebService calls must follow format {messageContext, interceptor, [arg...]}.");
        }
        Object messageContext = args[0];
        Object interceptor = args[1];
        HashMap<String, Object> interceptors = new HashMap<String, Object>(instance.interceptors);
        interceptors.put(interceptor.getClass().getName(), interceptor);
        ArrayList<InterceptorData> interceptorDatas = new ArrayList<InterceptorData>(deploymentInfo.getMethodInterceptors(runMethod));
        InterceptorData providerData = new InterceptorData(interceptor.getClass());
        ClassFinder finder = new ClassFinder(new Class[]{interceptor.getClass()});
        providerData.getAroundInvoke().addAll(finder.findAnnotatedMethods(AroundInvoke.class));
        interceptorDatas.add(0, providerData);
        InterceptorStack interceptorStack = new InterceptorStack(instance.bean, runMethod, Operation.BUSINESS_WS, interceptorDatas, interceptors);
        Object[] params = new Object[runMethod.getParameterTypes().length];
        if (messageContext instanceof MessageContext) {
            ThreadContext.getThreadContext().set(MessageContext.class, (MessageContext)messageContext);
            returnValue = interceptorStack.invoke((MessageContext)messageContext, params);
        } else if (messageContext instanceof javax.xml.ws.handler.MessageContext) {
            AddressingSupport wsaSupport = NoAddressingSupport.INSTANCE;
            for (int i = 2; i < args.length; ++i) {
                if (!(args[i] instanceof AddressingSupport)) continue;
                wsaSupport = (AddressingSupport)args[i];
            }
            ThreadContext.getThreadContext().set(AddressingSupport.class, wsaSupport);
            ThreadContext.getThreadContext().set(javax.xml.ws.handler.MessageContext.class, (javax.xml.ws.handler.MessageContext)messageContext);
            returnValue = interceptorStack.invoke((javax.xml.ws.handler.MessageContext)messageContext, params);
        }
        return returnValue;
    }

    protected ProxyInfo createEJBObject(CoreDeploymentInfo deploymentInfo, Method callMethod) {
        return new ProxyInfo(deploymentInfo, null);
    }
}

