/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.stateful;

import java.util.Map;
import java.util.Properties;
import org.apache.openejb.core.stateful.Cache;
import org.apache.openejb.core.stateful.Instance;
import org.apache.openejb.core.stateful.StatefulContainer;
import org.apache.openejb.spi.SecurityService;
import org.apache.xbean.recipe.ObjectRecipe;
import org.apache.xbean.recipe.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatefulContainerFactory {
    private Object id;
    private SecurityService securityService;
    private Cache<Object, Instance> cache;
    private Properties properties = new Properties();

    public Object getId() {
        return this.id;
    }

    public void setId(Object id) {
        this.id = id;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public Cache<Object, Instance> getCache() {
        return this.cache;
    }

    public void setCache(Cache<Object, Instance> cache) {
        this.cache = cache;
    }

    public void setCache(String s) {
        this.properties.put("Cache", s);
    }

    public void setPassivator(String s) {
        this.properties.put("Passivator", s);
    }

    public void setTimeOut(String s) {
        this.properties.put("TimeOut", s);
    }

    public void setCapacity(String s) {
        this.properties.put("Capacity", s);
    }

    public void setBulkPassivate(String s) {
        this.properties.put("BulkPassivate", s);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
    }

    public StatefulContainer create() throws Exception {
        if (this.cache == null) {
            this.buildCache();
        }
        return new StatefulContainer(this.id, this.securityService, this.cache);
    }

    private void buildCache() throws Exception {
        if (this.properties == null) {
            throw new IllegalArgumentException("No cache defined for StatefulContainer " + this.id);
        }
        Object cache = this.getProperty("Cache");
        if (cache == null) {
            throw new IllegalArgumentException("No cache defined for StatefulContainer " + this.id);
        }
        if (cache instanceof Cache) {
            this.cache = (Cache)cache;
            return;
        }
        ObjectRecipe serviceRecipe = new ObjectRecipe((String)cache);
        serviceRecipe.allow(Option.CASE_INSENSITIVE_PROPERTIES);
        serviceRecipe.allow(Option.IGNORE_MISSING_PROPERTIES);
        serviceRecipe.allow(Option.NAMED_PARAMETERS);
        serviceRecipe.setAllProperties((Map)this.properties);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            this.getClass().getClassLoader();
        }
        cache = serviceRecipe.create(classLoader);
        this.cache = (Cache)cache;
    }

    private Object getProperty(String name) {
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            Object key = entry.getKey();
            if (!(key instanceof String) || !name.equalsIgnoreCase((String)key)) continue;
            return entry.getValue();
        }
        return null;
    }
}

