/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.mdb;

import java.security.Principal;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.MessageDrivenContext;
import javax.ejb.TimerService;
import javax.transaction.UserTransaction;
import org.apache.openejb.core.BaseContext;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.spi.SecurityService;

public class MdbContext
extends BaseContext
implements MessageDrivenContext {
    protected static final BaseContext.State[] states = new BaseContext.State[Operation.values().length];

    public static BaseContext.State[] getStates() {
        return states;
    }

    public MdbContext(SecurityService securityService) {
        super(securityService);
    }

    protected BaseContext.State getState() {
        Operation operation = ThreadContext.getThreadContext().getCurrentOperation();
        BaseContext.State state = states[operation.ordinal()];
        if (state == null) {
            throw new IllegalArgumentException("Invalid operation " + (Object)((Object)operation) + " for this context");
        }
        return state;
    }

    static {
        MdbContext.states[Operation.INJECTION.ordinal()] = new InjectionMdbState();
        MdbContext.states[Operation.CREATE.ordinal()] = new LifecycleMdbState();
        MdbContext.states[Operation.POST_CONSTRUCT.ordinal()] = new LifecycleMdbState();
        MdbContext.states[Operation.PRE_DESTROY.ordinal()] = new LifecycleMdbState();
        MdbContext.states[Operation.BUSINESS.ordinal()] = new BusinessTimeoutMdbState();
        MdbContext.states[Operation.TIMEOUT.ordinal()] = new BusinessTimeoutMdbState();
    }

    protected static class BusinessTimeoutMdbState
    extends BaseContext.State {
        protected BusinessTimeoutMdbState() {
        }

        public EJBHome getEJBHome() {
            throw new IllegalStateException();
        }

        public EJBLocalHome getEJBLocalHome() {
            throw new IllegalStateException();
        }

        public boolean isCallerInRole(SecurityService securityService, String roleName) {
            throw new IllegalStateException();
        }
    }

    protected static class LifecycleMdbState
    extends BaseContext.State {
        protected LifecycleMdbState() {
        }

        public EJBHome getEJBHome() {
            throw new IllegalStateException();
        }

        public EJBLocalHome getEJBLocalHome() {
            throw new IllegalStateException();
        }

        public Principal getCallerPrincipal(SecurityService securityService) {
            throw new IllegalStateException();
        }

        public boolean isCallerInRole(SecurityService securityService, String roleName) {
            throw new IllegalStateException();
        }

        public boolean getRollbackOnly() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public void setRollbackOnly() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public boolean isMessageContextAccessAllowed() {
            return false;
        }

        public boolean isEntityManagerAccessAllowed() {
            return false;
        }

        public boolean isTimerAccessAllowed() {
            return super.isTimerAccessAllowed();
        }

        public boolean isTimerMethodAllowed() {
            return false;
        }
    }

    protected static class InjectionMdbState
    extends BaseContext.State {
        protected InjectionMdbState() {
        }

        public EJBHome getEJBHome() {
            throw new IllegalStateException();
        }

        public EJBLocalHome getEJBLocalHome() {
            throw new IllegalStateException();
        }

        public Principal getCallerPrincipal(SecurityService securityService) {
            throw new IllegalStateException();
        }

        public boolean isCallerInRole(SecurityService securityService, String roleName) {
            throw new IllegalStateException();
        }

        public UserTransaction getUserTransaction(UserTransaction userTransaction) throws IllegalStateException {
            throw new IllegalStateException();
        }

        public boolean getRollbackOnly() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public void setRollbackOnly() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public TimerService getTimerService() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public boolean isUserTransactionAccessAllowed() {
            return false;
        }

        public boolean isMessageContextAccessAllowed() {
            return false;
        }

        public boolean isEntityManagerFactoryAccessAllowed() {
            return false;
        }

        public boolean isEntityManagerAccessAllowed() {
            return false;
        }

        public boolean isTimerAccessAllowed() {
            return false;
        }

        public boolean isTimerMethodAllowed() {
            return false;
        }
    }
}

