/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.ivm.naming;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.openejb.core.ivm.naming.Reference;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;

public class JndiReference
extends Reference {
    private Context context;
    private Hashtable envProperties;
    private String jndiName;
    private String contextJndiName;

    public JndiReference(Context linkedContext, String jndiName) {
        this.context = linkedContext;
        this.jndiName = jndiName;
    }

    public JndiReference(String contextJndiName, String jndiName) {
        this.contextJndiName = contextJndiName;
        this.jndiName = jndiName;
    }

    public JndiReference(Hashtable envProperties, String jndiName) {
        this.envProperties = envProperties == null || envProperties.size() == 0 ? null : envProperties;
        this.jndiName = jndiName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject() throws NamingException {
        Context externalContext;
        Context context = externalContext = this.getContext();
        synchronized (context) {
            return externalContext.lookup(this.jndiName);
        }
    }

    protected Context getContext() throws NamingException {
        if (this.context == null) {
            if (this.contextJndiName != null) {
                ContainerSystem containerSystem = SystemInstance.get().getComponent(ContainerSystem.class);
                this.context = (Context)containerSystem.getJNDIContext().lookup(this.contextJndiName);
            } else {
                this.context = new InitialContext(this.envProperties);
            }
        }
        return this.context;
    }
}

