/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.entity;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.NoSuchObjectException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.ejb.EJBAccessException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.EntityBean;
import javax.ejb.NoSuchEntityException;
import javax.ejb.Timer;
import javax.transaction.TransactionSynchronizationRegistry;
import org.apache.openejb.ApplicationException;
import org.apache.openejb.ContainerType;
import org.apache.openejb.DeploymentInfo;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.ProxyInfo;
import org.apache.openejb.RpcContainer;
import org.apache.openejb.SystemException;
import org.apache.openejb.core.BaseContext;
import org.apache.openejb.core.CoreDeploymentInfo;
import org.apache.openejb.core.ExceptionType;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.entity.EntityContext;
import org.apache.openejb.core.entity.EntityInstanceManager;
import org.apache.openejb.core.entity.EntrancyTracker;
import org.apache.openejb.core.timer.EjbTimerService;
import org.apache.openejb.core.timer.EjbTimerServiceImpl;
import org.apache.openejb.core.transaction.EjbTransactionUtil;
import org.apache.openejb.core.transaction.TransactionPolicy;
import org.apache.openejb.core.transaction.TransactionType;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.SecurityService;
import org.apache.openejb.util.ArrayEnumeration;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class EntityContainer
implements RpcContainer {
    private EntityInstanceManager instanceManager;
    private Map<String, CoreDeploymentInfo> deploymentRegistry = new HashMap<String, CoreDeploymentInfo>();
    private Object containerID = null;
    public static Logger logger = Logger.getInstance(LogCategory.OPENEJB, "org.apache.openejb.util.resources");
    private SecurityService securityService;
    protected EntrancyTracker entrancyTracker;

    public EntityContainer(Object id, SecurityService securityService, int poolSize) throws OpenEJBException {
        this.containerID = id;
        this.securityService = securityService;
        this.entrancyTracker = new EntrancyTracker(SystemInstance.get().getComponent(TransactionSynchronizationRegistry.class));
        this.instanceManager = new EntityInstanceManager(this, securityService, poolSize);
    }

    public synchronized DeploymentInfo[] deployments() {
        return this.deploymentRegistry.values().toArray(new DeploymentInfo[this.deploymentRegistry.size()]);
    }

    public synchronized DeploymentInfo getDeploymentInfo(Object deploymentID) {
        String id = (String)deploymentID;
        return this.deploymentRegistry.get(id);
    }

    public ContainerType getContainerType() {
        return ContainerType.BMP_ENTITY;
    }

    public Object getContainerID() {
        return this.containerID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(DeploymentInfo info) throws OpenEJBException {
        EntityContainer entityContainer = this;
        synchronized (entityContainer) {
            CoreDeploymentInfo deploymentInfo = (CoreDeploymentInfo)info;
            this.deploymentRegistry.put((String)deploymentInfo.getDeploymentID(), deploymentInfo);
            deploymentInfo.setContainer(this);
        }
        this.instanceManager.deploy(info);
        EjbTimerService timerService = info.getEjbTimerService();
        if (timerService != null) {
            timerService.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy(DeploymentInfo info) throws OpenEJBException {
        EjbTimerService timerService = info.getEjbTimerService();
        if (timerService != null) {
            timerService.stop();
        }
        this.instanceManager.undeploy(info);
        EntityContainer entityContainer = this;
        synchronized (entityContainer) {
            String id = (String)info.getDeploymentID();
            this.deploymentRegistry.remove(id);
            info.setContainer(null);
        }
    }

    public Object invoke(Object deployID, Method callMethod, Object[] args, Object primKey, Object securityIdentity) throws OpenEJBException {
        return this.invoke(deployID, null, callMethod.getDeclaringClass(), callMethod, args, primKey);
    }

    public Object invoke(Object deployID, Class callInterface, Method callMethod, Object[] args, Object primKey) throws OpenEJBException {
        return this.invoke(deployID, null, callInterface, callMethod, args, primKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object deployID, InterfaceType type, Class callInterface, Method callMethod, Object[] args, Object primKey) throws OpenEJBException {
        Object retValue;
        ThreadContext oldCallContext;
        ThreadContext callContext;
        CoreDeploymentInfo deployInfo;
        block14: {
            String methodName;
            Class<?> declaringClass;
            block10: {
                block11: {
                    block13: {
                        block12: {
                            ProxyInfo proxyInfo;
                            deployInfo = (CoreDeploymentInfo)this.getDeploymentInfo(deployID);
                            if (deployInfo == null) {
                                throw new OpenEJBException("Deployment does not exist in this container. Deployment(id='" + deployID + "'), Container(id='" + this.containerID + "')");
                            }
                            if (type == null) {
                                type = deployInfo.getInterfaceType(callInterface);
                            }
                            callContext = new ThreadContext(deployInfo, primKey);
                            oldCallContext = ThreadContext.enter(callContext);
                            try {
                                boolean authorized = this.getSecurityService().isCallerAuthorized(callMethod, type);
                                if (!authorized) {
                                    throw new ApplicationException((Exception)new EJBAccessException("Unauthorized Access by Principal Denied"));
                                }
                                declaringClass = callMethod.getDeclaringClass();
                                methodName = callMethod.getName();
                                if (!EJBHome.class.isAssignableFrom(declaringClass) && !EJBLocalHome.class.isAssignableFrom(declaringClass)) break block10;
                                if (declaringClass == EJBHome.class || declaringClass == EJBLocalHome.class) break block11;
                                if (!methodName.startsWith("create")) break block12;
                                proxyInfo = this.createEJBObject(callMethod, args, callContext);
                                Object var17_19 = null;
                            }
                            catch (Throwable throwable) {
                                Object var17_25 = null;
                                ThreadContext.exit(oldCallContext);
                                throw throwable;
                            }
                            ThreadContext.exit(oldCallContext);
                            return proxyInfo;
                        }
                        if (!methodName.startsWith("find")) break block13;
                        Object object = this.findMethod(callMethod, args, callContext);
                        Object var17_20 = null;
                        ThreadContext.exit(oldCallContext);
                        return object;
                    }
                    Object object = this.homeMethod(callMethod, args, callContext);
                    Object var17_21 = null;
                    ThreadContext.exit(oldCallContext);
                    return object;
                }
                if (!methodName.equals("remove")) break block14;
                this.removeEJBObject(callMethod, args, callContext);
                Object var13_16 = null;
                Object var17_22 = null;
                ThreadContext.exit(oldCallContext);
                return var13_16;
            }
            if (EJBObject.class != declaringClass && EJBLocalObject.class != declaringClass || !methodName.equals("remove")) break block14;
            this.removeEJBObject(callMethod, args, callContext);
            Object var13_17 = null;
            Object var17_23 = null;
            ThreadContext.exit(oldCallContext);
            return var13_17;
        }
        callContext.setCurrentOperation(Operation.BUSINESS);
        callContext.setCurrentAllowedStates(EntityContext.getStates());
        Method runMethod = deployInfo.getMatchingBeanMethod(callMethod);
        callContext.set(Method.class, runMethod);
        Object object = retValue = this.invoke(callMethod, runMethod, args, callContext);
        Object var17_24 = null;
        ThreadContext.exit(oldCallContext);
        return object;
    }

    private SecurityService getSecurityService() {
        return this.securityService;
    }

    public EntityInstanceManager getInstanceManager() {
        return this.instanceManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object invoke(Method callMethod, Method runMethod, Object[] args, ThreadContext callContext) throws OpenEJBException {
        CoreDeploymentInfo deploymentInfo = callContext.getDeploymentInfo();
        TransactionPolicy txPolicy = EjbTransactionUtil.createTransactionPolicy(deploymentInfo.getTransactionType(callMethod), callContext);
        EntityBean bean = null;
        Object returnValue = null;
        this.entrancyTracker.enter(callContext.getDeploymentInfo(), callContext.getPrimaryKey());
        try {
            try {
                bean = this.instanceManager.obtainInstance(callContext);
                this.ejbLoad_If_No_Transaction(callContext, bean);
                returnValue = runMethod.invoke((Object)bean, args);
                this.ejbStore_If_No_Transaction(callContext, bean);
                this.instanceManager.poolInstance(callContext, bean, callContext.getPrimaryKey());
            }
            catch (Throwable e) {
                this.handleException(txPolicy, e, callContext, bean);
                Object var11_10 = null;
                this.entrancyTracker.exit(callContext.getDeploymentInfo(), callContext.getPrimaryKey());
                EjbTransactionUtil.afterInvoke(txPolicy, callContext);
                return returnValue;
            }
            Object var11_9 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.entrancyTracker.exit(callContext.getDeploymentInfo(), callContext.getPrimaryKey());
            EjbTransactionUtil.afterInvoke(txPolicy, callContext);
            throw throwable;
        }
        this.entrancyTracker.exit(callContext.getDeploymentInfo(), callContext.getPrimaryKey());
        EjbTransactionUtil.afterInvoke(txPolicy, callContext);
        return returnValue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void ejbLoad_If_No_Transaction(ThreadContext callContext, EntityBean bean) throws Exception {
        TransactionPolicy callerTxPolicy;
        Operation orginalOperation = callContext.getCurrentOperation();
        BaseContext.State[] originalAllowedStates = callContext.getCurrentAllowedStates();
        if (orginalOperation != Operation.BUSINESS) {
            if (orginalOperation != Operation.REMOVE) return;
        }
        if ((callerTxPolicy = callContext.getTransactionPolicy()) != null && callerTxPolicy.isTransactionActive()) {
            return;
        }
        CoreDeploymentInfo deploymentInfo = callContext.getDeploymentInfo();
        TransactionPolicy txPolicy = deploymentInfo.getTransactionPolicyFactory().createTransactionPolicy(TransactionType.Supports);
        try {
            block7: {
                try {
                    if (txPolicy.isTransactionActive()) break block7;
                    callContext.setCurrentOperation(Operation.LOAD);
                    callContext.setCurrentAllowedStates(EntityContext.getStates());
                    bean.ejbLoad();
                }
                catch (NoSuchEntityException e) {
                    this.instanceManager.discardInstance(callContext, bean);
                    throw new ApplicationException(new NoSuchObjectException("Entity not found: " + callContext.getPrimaryKey()));
                }
                catch (Exception e) {
                    this.instanceManager.discardInstance(callContext, bean);
                    throw e;
                }
            }
            Object var10_8 = null;
            callContext.setCurrentOperation(orginalOperation);
            callContext.setCurrentAllowedStates(originalAllowedStates);
            txPolicy.commit();
            return;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            callContext.setCurrentOperation(orginalOperation);
            callContext.setCurrentAllowedStates(originalAllowedStates);
            txPolicy.commit();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void ejbStore_If_No_Transaction(ThreadContext callContext, EntityBean bean) throws Exception {
        Operation currentOp = callContext.getCurrentOperation();
        BaseContext.State[] originalAllowedStates = callContext.getCurrentAllowedStates();
        if (currentOp != Operation.BUSINESS) return;
        TransactionPolicy callerTxPolicy = callContext.getTransactionPolicy();
        if (callerTxPolicy != null && callerTxPolicy.isTransactionActive()) {
            return;
        }
        CoreDeploymentInfo deploymentInfo = callContext.getDeploymentInfo();
        TransactionPolicy txPolicy = deploymentInfo.getTransactionPolicyFactory().createTransactionPolicy(TransactionType.Supports);
        try {
            block5: {
                try {
                    if (txPolicy.isTransactionActive()) break block5;
                    callContext.setCurrentOperation(Operation.STORE);
                    callContext.setCurrentAllowedStates(EntityContext.getStates());
                    bean.ejbStore();
                }
                catch (Exception e) {
                    this.instanceManager.discardInstance(callContext, bean);
                    throw e;
                }
            }
            Object var10_8 = null;
            callContext.setCurrentOperation(currentOp);
            callContext.setCurrentAllowedStates(originalAllowedStates);
            txPolicy.commit();
            return;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            callContext.setCurrentOperation(currentOp);
            callContext.setCurrentAllowedStates(originalAllowedStates);
            txPolicy.commit();
            throw throwable;
        }
    }

    protected void didCreateBean(ThreadContext callContext, EntityBean bean) throws OpenEJBException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ProxyInfo createEJBObject(Method callMethod, Object[] args, ThreadContext callContext) throws OpenEJBException {
        CoreDeploymentInfo deploymentInfo = callContext.getDeploymentInfo();
        callContext.setCurrentOperation(Operation.CREATE);
        callContext.setCurrentAllowedStates(EntityContext.getStates());
        TransactionPolicy txPolicy = EjbTransactionUtil.createTransactionPolicy(deploymentInfo.getTransactionType(callMethod), callContext);
        EntityBean bean = null;
        Object primaryKey = null;
        try {
            try {
                bean = this.instanceManager.obtainInstance(callContext);
                Method ejbCreateMethod = deploymentInfo.getMatchingBeanMethod(callMethod);
                primaryKey = ejbCreateMethod.invoke((Object)bean, args);
                this.didCreateBean(callContext, bean);
                Method ejbPostCreateMethod = deploymentInfo.getMatchingPostCreateMethod(ejbCreateMethod);
                ThreadContext postCreateContext = new ThreadContext(deploymentInfo, primaryKey);
                postCreateContext.setCurrentOperation(Operation.POST_CREATE);
                postCreateContext.setCurrentAllowedStates(EntityContext.getStates());
                ThreadContext oldContext = ThreadContext.enter(postCreateContext);
                try {
                    ejbPostCreateMethod.invoke((Object)bean, args);
                    Object var13_13 = null;
                }
                catch (Throwable throwable) {
                    Object var13_14 = null;
                    ThreadContext.exit(oldContext);
                    throw throwable;
                }
                ThreadContext.exit(oldContext);
                this.instanceManager.poolInstance(callContext, bean, primaryKey);
            }
            catch (Throwable e) {
                this.handleException(txPolicy, e, callContext, bean);
                Object var15_17 = null;
                EjbTransactionUtil.afterInvoke(txPolicy, callContext);
                return new ProxyInfo(deploymentInfo, primaryKey);
            }
            Object var15_16 = null;
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            EjbTransactionUtil.afterInvoke(txPolicy, callContext);
            throw throwable;
        }
        EjbTransactionUtil.afterInvoke(txPolicy, callContext);
        return new ProxyInfo(deploymentInfo, primaryKey);
    }

    protected Object findMethod(Method callMethod, Object[] args, ThreadContext callContext) throws OpenEJBException {
        CoreDeploymentInfo deploymentInfo = callContext.getDeploymentInfo();
        callContext.setCurrentOperation(Operation.FIND);
        callContext.setCurrentAllowedStates(EntityContext.getStates());
        Method runMethod = deploymentInfo.getMatchingBeanMethod(callMethod);
        Serializable returnValue = this.invoke(callMethod, runMethod, args, callContext);
        if (returnValue instanceof Collection) {
            Iterator keys = ((Collection)((Object)returnValue)).iterator();
            Vector<ProxyInfo> proxies = new Vector<ProxyInfo>();
            while (keys.hasNext()) {
                Object primaryKey = keys.next();
                proxies.addElement(new ProxyInfo(deploymentInfo, primaryKey));
            }
            returnValue = proxies;
        } else if (returnValue instanceof Enumeration) {
            Enumeration keys = (Enumeration)((Object)returnValue);
            Vector<ProxyInfo> proxies = new Vector<ProxyInfo>();
            while (keys.hasMoreElements()) {
                Object primaryKey = keys.nextElement();
                proxies.addElement(new ProxyInfo(deploymentInfo, primaryKey));
            }
            returnValue = new ArrayEnumeration(proxies);
        } else {
            returnValue = new ProxyInfo(deploymentInfo, returnValue);
        }
        return returnValue;
    }

    protected Object homeMethod(Method callMethod, Object[] args, ThreadContext callContext) throws OpenEJBException {
        CoreDeploymentInfo deploymentInfo = callContext.getDeploymentInfo();
        callContext.setCurrentOperation(Operation.HOME);
        callContext.setCurrentAllowedStates(EntityContext.getStates());
        Method runMethod = deploymentInfo.getMatchingBeanMethod(callMethod);
        return this.invoke(callMethod, runMethod, args, callContext);
    }

    protected void didRemove(EntityBean bean, ThreadContext threadContext) throws OpenEJBException {
        this.cancelTimers(threadContext);
    }

    private void cancelTimers(ThreadContext threadContext) {
        EjbTimerService timerService;
        CoreDeploymentInfo deploymentInfo = threadContext.getDeploymentInfo();
        Object primaryKey = threadContext.getPrimaryKey();
        if (primaryKey != null && (timerService = deploymentInfo.getEjbTimerService()) != null && timerService instanceof EjbTimerServiceImpl) {
            for (Timer timer : deploymentInfo.getEjbTimerService().getTimers(primaryKey)) {
                timer.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void removeEJBObject(Method callMethod, Object[] args, ThreadContext callContext) throws OpenEJBException {
        callContext.setCurrentOperation(Operation.REMOVE);
        callContext.setCurrentAllowedStates(EntityContext.getStates());
        CoreDeploymentInfo deploymentInfo = callContext.getDeploymentInfo();
        TransactionPolicy txPolicy = EjbTransactionUtil.createTransactionPolicy(deploymentInfo.getTransactionType(callMethod), callContext);
        EntityBean bean = null;
        try {
            try {
                bean = this.instanceManager.obtainInstance(callContext);
                this.ejbLoad_If_No_Transaction(callContext, bean);
                bean.ejbRemove();
                this.didRemove(bean, callContext);
                this.instanceManager.poolInstance(callContext, bean, callContext.getPrimaryKey());
            }
            catch (Throwable e) {
                this.handleException(txPolicy, e, callContext, bean);
                Object var9_8 = null;
                EjbTransactionUtil.afterInvoke(txPolicy, callContext);
                return;
            }
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            EjbTransactionUtil.afterInvoke(txPolicy, callContext);
            throw throwable;
        }
        EjbTransactionUtil.afterInvoke(txPolicy, callContext);
    }

    private void handleException(TransactionPolicy txPolicy, Throwable e, ThreadContext callContext, EntityBean bean) throws OpenEJBException {
        ExceptionType type;
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
            type = callContext.getDeploymentInfo().getExceptionType(e);
        } else if (e instanceof ApplicationException) {
            e = ((ApplicationException)e).getRootCause();
            type = ExceptionType.APPLICATION;
        } else if (e instanceof SystemException) {
            e = ((SystemException)e).getRootCause();
            type = ExceptionType.SYSTEM;
        } else {
            type = ExceptionType.SYSTEM;
        }
        if (type == ExceptionType.SYSTEM) {
            if (bean != null) {
                try {
                    this.instanceManager.discardInstance(callContext, bean);
                }
                catch (SystemException e1) {
                    logger.error("The instance manager encountered an unkown system exception while trying to discard the entity instance with primary key " + callContext.getPrimaryKey());
                }
            }
            EjbTransactionUtil.handleSystemException(txPolicy, e, callContext);
        } else {
            this.instanceManager.poolInstance(callContext, bean, callContext.getPrimaryKey());
            EjbTransactionUtil.handleApplicationException(txPolicy, e, type == ExceptionType.APPLICATION_ROLLBACK);
        }
    }
}

