/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.openejb.core.BaseContext;
import org.apache.openejb.core.CoreDeploymentInfo;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.ThreadContextListener;
import org.apache.openejb.core.transaction.TransactionPolicy;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadContext {
    private static final Logger log = Logger.getInstance(LogCategory.OPENEJB, "org.apache.openejb.util.resources");
    private static final ThreadLocal<ThreadContext> threadStorage = new ThreadLocal();
    private static final List<ThreadContextListener> listeners = new CopyOnWriteArrayList<ThreadContextListener>();
    private final CoreDeploymentInfo deploymentInfo;
    private final Object primaryKey;
    private final HashMap<Class, Object> data = new HashMap();
    private ClassLoader oldClassLoader;
    private Operation currentOperation;
    private BaseContext.State[] currentAllowedStates;
    private Class invokedInterface;
    private TransactionPolicy transactionPolicy;
    private boolean discardInstance;

    public static ThreadContext getThreadContext() {
        ThreadContext threadContext = threadStorage.get();
        return threadContext;
    }

    public static ThreadContext enter(ThreadContext newContext) {
        if (newContext == null) {
            throw new NullPointerException("newContext is null");
        }
        newContext.oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(newContext.deploymentInfo.getClassLoader());
        ThreadContext oldContext = threadStorage.get();
        threadStorage.set(newContext);
        for (ThreadContextListener listener : listeners) {
            try {
                listener.contextEntered(oldContext, newContext);
            }
            catch (Throwable e) {
                log.warning("ThreadContextListener threw an exception", e);
            }
        }
        return oldContext;
    }

    public static void exit(ThreadContext oldContext) {
        ThreadContext exitingContext = threadStorage.get();
        if (exitingContext == null) {
            throw new IllegalStateException("No existing context");
        }
        Thread.currentThread().setContextClassLoader(exitingContext.oldClassLoader);
        exitingContext.oldClassLoader = null;
        threadStorage.set(oldContext);
        for (ThreadContextListener listener : listeners) {
            try {
                listener.contextExited(exitingContext, oldContext);
            }
            catch (Throwable e) {
                log.debug("ThreadContextListener threw an exception", e);
            }
        }
    }

    public static void addThreadContextListener(ThreadContextListener listener) {
        listeners.add(listener);
    }

    public static void removeThreadContextListener(ThreadContextListener listener) {
        listeners.remove(listener);
    }

    public ThreadContext(CoreDeploymentInfo deploymentInfo, Object primaryKey) {
        this(deploymentInfo, primaryKey, null);
    }

    public ThreadContext(CoreDeploymentInfo deploymentInfo, Object primaryKey, Operation operation) {
        if (deploymentInfo == null) {
            throw new NullPointerException("deploymentInfo is null");
        }
        this.deploymentInfo = deploymentInfo;
        this.primaryKey = primaryKey;
        this.currentOperation = operation;
    }

    public ThreadContext(ThreadContext that) {
        this.deploymentInfo = that.deploymentInfo;
        this.primaryKey = that.primaryKey;
        this.data.putAll(that.data);
        this.oldClassLoader = that.oldClassLoader;
    }

    public CoreDeploymentInfo getDeploymentInfo() {
        return this.deploymentInfo;
    }

    public Object getPrimaryKey() {
        return this.primaryKey;
    }

    public Operation getCurrentOperation() {
        return this.currentOperation;
    }

    public void setCurrentOperation(Operation operation) {
        this.currentOperation = operation;
    }

    public Class getInvokedInterface() {
        return this.invokedInterface;
    }

    public void setInvokedInterface(Class invokedInterface) {
        this.invokedInterface = invokedInterface;
    }

    public TransactionPolicy getTransactionPolicy() {
        return this.transactionPolicy;
    }

    public void setTransactionPolicy(TransactionPolicy transactionPolicy) {
        this.transactionPolicy = transactionPolicy;
    }

    public BaseContext.State[] getCurrentAllowedStates() {
        return this.currentAllowedStates;
    }

    public BaseContext.State[] setCurrentAllowedStates(BaseContext.State[] newAllowedStates) {
        BaseContext.State[] oldAllowedStates = this.currentAllowedStates;
        this.currentAllowedStates = newAllowedStates;
        return oldAllowedStates;
    }

    public <T> T get(Class<T> type) {
        return (T)this.data.get(type);
    }

    public <T> T set(Class<T> type, T value) {
        return (T)this.data.put(type, value);
    }

    public boolean isDiscardInstance() {
        return this.discardInstance;
    }

    public void setDiscardInstance(boolean discardInstance) {
        this.discardInstance = discardInstance;
    }
}

