/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config.sys;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Map;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.sys.JaxbOpenejb;
import org.apache.openejb.config.sys.ServiceProvider;
import org.apache.openejb.config.sys.ServicesJar;
import org.apache.openejb.util.SuperProperties;

public class WikiGenerator {
    protected ServicesJar servicesJar;

    public static void main(String[] args) throws Exception {
        System.out.println();
        System.out.println();
        System.out.println();
        new WikiGenerator("org.apache.openejb").generate(new PrintWriter(System.out));
        System.out.println();
        System.out.println();
        System.out.println();
    }

    public WikiGenerator(String providerName) throws OpenEJBException {
        this.servicesJar = JaxbOpenejb.readServicesJar(providerName);
    }

    public WikiGenerator(ServicesJar servicesJar) {
        this.servicesJar = servicesJar;
    }

    public void generate(PrintWriter out) throws Exception {
        out.println("{anchor: containers}");
        out.println("h1. Containers");
        for (ServiceProvider provider : this.servicesJar.getServiceProvider()) {
            if (!"Container".equals(provider.getService())) continue;
            this.generateService(out, provider, "container");
        }
        out.println();
        out.println("{anchor: resources}");
        out.println("h1. Resources");
        ArrayList<String> seen = new ArrayList<String>();
        for (ServiceProvider provider : this.servicesJar.getServiceProvider()) {
            if (!"Resource".equals(provider.getService()) || seen.containsAll(provider.getTypes())) continue;
            this.generateService(out, provider, "resource");
            seen.addAll(provider.getTypes());
        }
        out.println();
        out.flush();
    }

    private void generateService(PrintWriter out, ServiceProvider provider, String serviceType) {
        out.println("{anchor:" + provider.getId() + "-" + serviceType + "}");
        String type = provider.getTypes().get(0);
        out.println("h2. " + type);
        out.println("Declarable in openejb.xml via");
        out.println("{code:xml}");
        out.println("<" + provider.getService() + " id=\"Foo\" type=\"" + type + "\">");
        out.println("</" + provider.getService() + ">");
        out.println("{code}");
        out.println("Declarable in properties via");
        out.println("{panel}");
        out.println("Foo = new://" + provider.getService() + "?type=" + type + "");
        out.println("{panel}");
        SuperProperties properties = (SuperProperties)provider.getProperties();
        if (properties.size() > 0) {
            out.println("Supports the following properties");
            out.println("    || Property Name || Description ||");
            for (Object key : properties.keySet()) {
                String name;
                Map<String, String> attributes;
                if (!(key instanceof String) || (attributes = properties.getAttributes(name = (String)key)).containsKey("hidden")) continue;
                String value = properties.getProperty(name);
                String comment = properties.getComment(name);
                comment = this.scrubText(comment);
                if (value != null && value.length() > 0) {
                    if (comment.length() > 0) {
                        comment = comment + "\\\\ \\\\ ";
                    }
                    comment = comment + "Default value is _" + this.scrubText(value) + "_.|";
                }
                if (comment.length() == 0) {
                    comment = "No description.";
                }
                out.println("    | " + name + " | " + comment + "|");
            }
        } else {
            out.println("No properties.");
        }
        out.println();
    }

    private String scrubText(String text) {
        if (text == null) {
            text = "";
        }
        text = text.replaceAll("\r?\n", "\\\\\\\\ ");
        text = text.replaceAll("\\*", "\\\\*");
        text = text.replaceAll("\\_", "\\\\_");
        text = text.replaceAll("\\?", "\\\\?");
        text = text.replaceAll("\\-", "\\\\-");
        text = text.replaceAll("\\^", "\\\\^");
        text = text.replaceAll("\\~", "\\\\~");
        text = text.replaceAll("\\#", "\\\\#");
        text = text.replaceAll("\\[", "\\\\[");
        text = text.replaceAll("\\]", "\\\\]");
        text = text.replaceAll("\\{", "\\\\{");
        text = text.replaceAll("\\}", "\\\\}");
        text = text.replaceAll("\\(", "\\\\(");
        text = text.replaceAll("\\)", "\\\\)");
        text = text.replaceAll("http:", "{html}http:{html}");
        text = text.replaceAll("file:", "{html}file:{html}");
        text = text.replaceAll("    ", "{html}&nbsp;&nbsp;&nbsp;&nbsp;{html}");
        text = text.replaceAll("   ", "{html}&nbsp;&nbsp;&nbsp;{html}");
        text = text.replaceAll("  ", "{html}&nbsp;&nbsp;{html}");
        return text;
    }
}

