/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.openejb.assembler.classic.EjbLocalReferenceInfo;
import org.apache.openejb.assembler.classic.EjbReferenceInfo;
import org.apache.openejb.assembler.classic.EjbResolver;
import org.apache.openejb.assembler.classic.EnterpriseBeanInfo;
import org.apache.openejb.assembler.classic.EnvEntryInfo;
import org.apache.openejb.assembler.classic.InjectionInfo;
import org.apache.openejb.assembler.classic.JndiEncInfo;
import org.apache.openejb.assembler.classic.PersistenceContextReferenceInfo;
import org.apache.openejb.assembler.classic.PersistenceUnitReferenceInfo;
import org.apache.openejb.assembler.classic.PortRefInfo;
import org.apache.openejb.assembler.classic.ReferenceLocationInfo;
import org.apache.openejb.assembler.classic.ResourceEnvReferenceInfo;
import org.apache.openejb.assembler.classic.ResourceReferenceInfo;
import org.apache.openejb.assembler.classic.ServiceReferenceInfo;
import org.apache.openejb.config.ConfigurationFactory;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.jee.EjbLocalRef;
import org.apache.openejb.jee.EjbReference;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.EnvEntry;
import org.apache.openejb.jee.Injectable;
import org.apache.openejb.jee.InjectionTarget;
import org.apache.openejb.jee.JndiConsumer;
import org.apache.openejb.jee.JndiReference;
import org.apache.openejb.jee.PersistenceContextRef;
import org.apache.openejb.jee.PersistenceContextType;
import org.apache.openejb.jee.PersistenceUnitRef;
import org.apache.openejb.jee.PortComponentRef;
import org.apache.openejb.jee.Property;
import org.apache.openejb.jee.ResAuth;
import org.apache.openejb.jee.ResourceEnvRef;
import org.apache.openejb.jee.ResourceRef;
import org.apache.openejb.jee.ServiceRef;
import org.apache.openejb.jee.SessionBean;
import org.apache.openejb.jee.SessionType;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JndiEncInfoBuilder {
    public static final Logger logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP, JndiEncInfoBuilder.class);
    protected static final Messages messages = new Messages(JndiEncInfoBuilder.class);
    private final EjbResolver earResolver;
    private final Map<String, EjbResolver> ejbJarResolvers = new HashMap<String, EjbResolver>();

    public JndiEncInfoBuilder(AppInfo appInfo) {
        EjbResolver globalResolver = SystemInstance.get().getComponent(EjbResolver.class);
        this.earResolver = new EjbResolver(globalResolver, EjbResolver.Scope.EAR, appInfo.ejbJars);
        for (EjbJarInfo ejbJarInfo : appInfo.ejbJars) {
            EjbResolver ejbJarResolver = new EjbResolver(this.earResolver, EjbResolver.Scope.EJBJAR, ejbJarInfo);
            this.ejbJarResolvers.put(ejbJarInfo.moduleId, ejbJarResolver);
        }
    }

    private EjbResolver getEjbResolver(String moduleId) {
        EjbResolver resolver = this.ejbJarResolvers.get(moduleId);
        if (resolver == null) {
            resolver = this.earResolver;
        }
        return resolver;
    }

    public JndiEncInfo build(JndiConsumer jndiConsumer, String ejbName, String moduleId) throws OpenEJBException {
        URI moduleUri = null;
        if (moduleId != null) {
            try {
                moduleUri = new URI(moduleId);
            }
            catch (URISyntaxException e) {
                throw new OpenEJBException("Illegal moduleId " + moduleId, e);
            }
        }
        JndiEncInfo jndi = new JndiEncInfo();
        jndi.envEntries.addAll(this.buildEnvEntryInfos(jndiConsumer));
        jndi.resourceRefs.addAll(this.buildResourceRefInfos(jndiConsumer));
        jndi.resourceEnvRefs.addAll(this.buildResourceEnvRefInfos(jndiConsumer));
        this.buildEjbRefs(jndiConsumer, moduleUri, moduleId, ejbName, jndi);
        jndi.persistenceUnitRefs.addAll(this.buildPersistenceUnitRefInfos(jndiConsumer, moduleUri));
        jndi.persistenceContextRefs.addAll(this.buildPersistenceContextRefInfos(jndiConsumer, moduleUri));
        jndi.serviceRefs.addAll(this.buildServiceRefInfos(jndiConsumer));
        return jndi;
    }

    private void buildEjbRefs(JndiConsumer jndiConsumer, URI moduleUri, String moduleId, String ejbName, JndiEncInfo jndi) throws OpenEJBException {
        int size = jndiConsumer.getEjbRef().size() + jndiConsumer.getEjbLocalRef().size();
        ArrayList references = new ArrayList(size);
        references.addAll(jndiConsumer.getEjbRef());
        references.addAll(jndiConsumer.getEjbLocalRef());
        for (EjbReference ref : references) {
            EnterpriseBeanInfo otherBean;
            String deploymentId;
            EjbReferenceInfo info = new EjbReferenceInfo();
            info.homeClassName = ref.getHome();
            info.interfaceClassName = ref.getInterface();
            info.referenceName = ref.getName();
            info.link = ref.getEjbLink();
            info.location = this.buildLocationInfo((JndiReference)ref);
            info.targets.addAll(this.buildInjectionInfos((Injectable)ref));
            if (info.location != null) {
                if (ref.getRefType() == EjbReference.Type.LOCAL) {
                    jndi.ejbLocalReferences.add(this.toLocal(info));
                    continue;
                }
                jndi.ejbReferences.add(info);
                continue;
            }
            EjbResolver ejbResolver = this.getEjbResolver(moduleId);
            info.ejbDeploymentId = deploymentId = ejbResolver.resolve(new Ref(ref), moduleUri);
            if (info.ejbDeploymentId == null) {
                if (info.link != null) {
                    logger.warning("config.noBeanFoundEjbLink", ref.getName(), ejbName, ref.getEjbLink());
                } else {
                    logger.warning("config.noBeanFound", ref.getName(), ejbName, ref.getEjbLink());
                }
                if (ref.getRefType() == EjbReference.Type.LOCAL) {
                    jndi.ejbLocalReferences.add(this.toLocal(info));
                    continue;
                }
                jndi.ejbReferences.add(info);
                continue;
            }
            EjbResolver.Scope scope = ejbResolver.getScope(deploymentId);
            boolean bl = info.externalReference = scope != EjbResolver.Scope.EAR && scope != EjbResolver.Scope.EJBJAR;
            if (ref.getRefType() == EjbReference.Type.UNKNOWN && (otherBean = ejbResolver.getEnterpriseBeanInfo(deploymentId)) != null) {
                if (otherBean.businessLocal.contains(ref.getInterface())) {
                    ref.setRefType(EjbReference.Type.LOCAL);
                    jndiConsumer.getEjbRef().remove(ref);
                    jndiConsumer.getEjbLocalRef().add(new EjbLocalRef(ref));
                } else {
                    ref.setRefType(EjbReference.Type.REMOTE);
                }
            }
            if (ref.getRefType() == EjbReference.Type.LOCAL) {
                jndi.ejbLocalReferences.add(this.toLocal(info));
                continue;
            }
            jndi.ejbReferences.add(info);
        }
    }

    private EjbLocalReferenceInfo toLocal(EjbReferenceInfo r) {
        EjbLocalReferenceInfo l = new EjbLocalReferenceInfo();
        l.ejbDeploymentId = r.ejbDeploymentId;
        l.externalReference = r.externalReference;
        l.homeClassName = r.homeClassName;
        l.interfaceClassName = r.interfaceClassName;
        l.referenceName = r.referenceName;
        l.link = r.link;
        l.location = r.location;
        l.targets.addAll(r.targets);
        return l;
    }

    private List<ServiceReferenceInfo> buildServiceRefInfos(JndiConsumer jndiConsumer) {
        ArrayList<ServiceReferenceInfo> infos = new ArrayList<ServiceReferenceInfo>();
        for (ServiceRef ref : jndiConsumer.getServiceRef()) {
            ServiceReferenceInfo info = new ServiceReferenceInfo();
            info.referenceName = ref.getName();
            info.location = this.buildLocationInfo((JndiReference)ref);
            info.targets.addAll(this.buildInjectionInfos((Injectable)ref));
            infos.add(info);
            if (System.getProperty("duct tape") != null) continue;
            info.id = ref.getMappedName();
            info.serviceQName = ref.getServiceQname();
            info.serviceType = ref.getServiceInterface();
            info.referenceType = ref.getServiceRefType();
            info.wsdlFile = ref.getWsdlFile();
            info.jaxrpcMappingFile = ref.getJaxrpcMappingFile();
            info.handlerChains.addAll(ConfigurationFactory.toHandlerChainInfo(ref.getAllHandlers()));
            for (PortComponentRef portComponentRef : ref.getPortComponentRef()) {
                PortRefInfo portRefInfo = new PortRefInfo();
                portRefInfo.qname = portComponentRef.getQName();
                portRefInfo.serviceEndpointInterface = portComponentRef.getServiceEndpointInterface();
                portRefInfo.enableMtom = portComponentRef.isEnableMtom();
                portRefInfo.properties.putAll((Map<?, ?>)portComponentRef.getProperties());
                info.portRefs.add(portRefInfo);
            }
        }
        return infos;
    }

    private List<PersistenceUnitReferenceInfo> buildPersistenceUnitRefInfos(JndiConsumer jndiConsumer, URI moduleId) {
        ArrayList<PersistenceUnitReferenceInfo> infos = new ArrayList<PersistenceUnitReferenceInfo>();
        for (PersistenceUnitRef puRef : jndiConsumer.getPersistenceUnitRef()) {
            PersistenceUnitReferenceInfo info = new PersistenceUnitReferenceInfo();
            info.referenceName = puRef.getPersistenceUnitRefName();
            info.persistenceUnitName = puRef.getPersistenceUnitName();
            info.unitId = puRef.getMappedName();
            info.location = this.buildLocationInfo((JndiReference)puRef);
            info.targets.addAll(this.buildInjectionInfos((Injectable)puRef));
            infos.add(info);
        }
        return infos;
    }

    private List<PersistenceContextReferenceInfo> buildPersistenceContextRefInfos(JndiConsumer jndiConsumer, URI moduleId) {
        ArrayList<PersistenceContextReferenceInfo> infos = new ArrayList<PersistenceContextReferenceInfo>();
        for (PersistenceContextRef contextRef : jndiConsumer.getPersistenceContextRef()) {
            PersistenceContextReferenceInfo info = new PersistenceContextReferenceInfo();
            info.referenceName = contextRef.getPersistenceContextRefName();
            info.persistenceUnitName = contextRef.getPersistenceUnitName();
            info.unitId = contextRef.getMappedName();
            info.location = this.buildLocationInfo((JndiReference)contextRef);
            info.extended = contextRef.getPersistenceContextType() == PersistenceContextType.EXTENDED;
            List persistenceProperty = contextRef.getPersistenceProperty();
            for (Property property : persistenceProperty) {
                String name = property.getName();
                String value = property.getValue();
                info.properties.setProperty(name, value);
            }
            info.targets.addAll(this.buildInjectionInfos((Injectable)contextRef));
            infos.add(info);
        }
        return infos;
    }

    private List<ResourceReferenceInfo> buildResourceRefInfos(JndiConsumer item) {
        ArrayList<ResourceReferenceInfo> infos = new ArrayList<ResourceReferenceInfo>();
        for (ResourceRef res : item.getResourceRef()) {
            ResourceReferenceInfo info = new ResourceReferenceInfo();
            info.referenceAuth = res.getResAuth() != null ? res.getResAuth().toString() : ResAuth.CONTAINER.toString();
            info.referenceName = res.getResRefName();
            info.referenceType = res.getResType();
            info.resourceID = res.getMappedName();
            info.location = this.buildLocationInfo((JndiReference)res);
            info.targets.addAll(this.buildInjectionInfos((Injectable)res));
            infos.add(info);
        }
        return infos;
    }

    private List<ResourceEnvReferenceInfo> buildResourceEnvRefInfos(JndiConsumer item) {
        ResourceEnvReferenceInfo info;
        ArrayList<ResourceEnvReferenceInfo> infos = new ArrayList<ResourceEnvReferenceInfo>();
        for (ResourceEnvRef res : item.getResourceEnvRef()) {
            info = new ResourceEnvReferenceInfo();
            info.resourceEnvRefName = res.getResourceEnvRefName();
            info.resourceEnvRefType = res.getResourceEnvRefType();
            info.resourceID = res.getMappedName();
            info.location = this.buildLocationInfo((JndiReference)res);
            info.targets.addAll(this.buildInjectionInfos((Injectable)res));
            infos.add(info);
        }
        for (ResourceEnvRef res : item.getMessageDestinationRef()) {
            info = new ResourceEnvReferenceInfo();
            info.resourceEnvRefName = res.getMessageDestinationRefName();
            info.resourceEnvRefType = res.getMessageDestinationType();
            info.resourceID = res.getMappedName();
            info.location = this.buildLocationInfo((JndiReference)res);
            info.targets.addAll(this.buildInjectionInfos((Injectable)res));
            infos.add(info);
        }
        return infos;
    }

    private List<EnvEntryInfo> buildEnvEntryInfos(JndiConsumer item) {
        ArrayList<EnvEntryInfo> infos = new ArrayList<EnvEntryInfo>();
        for (EnvEntry env : item.getEnvEntry()) {
            if (env.getEnvEntryValue() == null) continue;
            if (env.getEnvEntryType() == null) {
                env.setEnvEntryType("java.lang.String");
            }
            EnvEntryInfo info = new EnvEntryInfo();
            info.name = env.getEnvEntryName();
            info.type = env.getEnvEntryType();
            info.value = env.getEnvEntryValue();
            info.location = this.buildLocationInfo((JndiReference)env);
            info.targets.addAll(this.buildInjectionInfos((Injectable)env));
            infos.add(info);
        }
        return infos;
    }

    public ReferenceLocationInfo buildLocationInfo(JndiReference reference) {
        String mappedName = reference.getMappedName();
        if (mappedName == null || !mappedName.startsWith("jndi:")) {
            return null;
        }
        ReferenceLocationInfo location = new ReferenceLocationInfo();
        location.jndiName = mappedName.replaceFirst("^jndi:", "");
        return location;
    }

    public Collection<? extends InjectionInfo> buildInjectionInfos(Injectable injectable) {
        ArrayList<InjectionInfo> infos = new ArrayList<InjectionInfo>();
        for (InjectionTarget target : injectable.getInjectionTarget()) {
            InjectionInfo info = new InjectionInfo();
            info.className = target.getInjectionTargetClass();
            info.propertyName = target.getInjectionTargetName();
            infos.add(info);
        }
        return infos;
    }

    public void buildDependsOnRefs(EjbModule module, EnterpriseBean enterpriseBean, EnterpriseBeanInfo beanInfo, String moduleId) throws OpenEJBException {
        if (!(enterpriseBean instanceof SessionBean)) {
            return;
        }
        SessionBean sessionBean = (SessionBean)enterpriseBean;
        if (sessionBean.getSessionType() != SessionType.SINGLETON) {
            return;
        }
        URI moduleUri = null;
        if (moduleId != null) {
            try {
                moduleUri = new URI(moduleId);
            }
            catch (URISyntaxException e) {
                throw new OpenEJBException("Illegal moduleId " + moduleId, e);
            }
        }
        EjbResolver ejbResolver = this.getEjbResolver(moduleId);
        for (String ejbName : sessionBean.getDependsOn()) {
            String deploymentId = ejbResolver.resolve(new SimpleRef(ejbName), moduleUri);
            if (deploymentId == null) continue;
            beanInfo.dependsOn.add(deploymentId);
        }
    }

    private static class Ref
    implements EjbResolver.Reference {
        private final EjbReference ref;

        public Ref(EjbReference ref) {
            this.ref = ref;
        }

        public String getName() {
            return this.ref.getName();
        }

        public String getEjbLink() {
            return this.ref.getEjbLink();
        }

        public String getHome() {
            return this.ref.getHome();
        }

        public String getInterface() {
            return this.ref.getInterface();
        }

        public String getMappedName() {
            return this.ref.getMappedName();
        }

        public EjbResolver.Type getRefType() {
            switch (this.ref.getRefType()) {
                case LOCAL: {
                    return EjbResolver.Type.LOCAL;
                }
                case REMOTE: {
                    return EjbResolver.Type.REMOTE;
                }
                case UNKNOWN: {
                    return EjbResolver.Type.UNKNOWN;
                }
            }
            return EjbResolver.Type.UNKNOWN;
        }
    }

    private static class SimpleRef
    implements EjbResolver.Reference {
        private final String name;

        public SimpleRef(String name) {
            this.name = name;
        }

        public String getEjbLink() {
            return this.name;
        }

        public String getHome() {
            return null;
        }

        public String getInterface() {
            return null;
        }

        public String getMappedName() {
            return null;
        }

        public String getName() {
            return this.name;
        }

        public EjbResolver.Type getRefType() {
            return EjbResolver.Type.UNKNOWN;
        }
    }
}

