/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.util.Map;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.DynamicDeployer;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.ResourceRef;
import org.apache.openejb.jee.oejb3.EjbDeployment;
import org.apache.openejb.jee.oejb3.EjbLink;
import org.apache.openejb.jee.oejb3.ResourceLink;

public class ApplyOpenejbJar
implements DynamicDeployer {
    public AppModule deploy(AppModule appModule) throws OpenEJBException {
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            Map ejbDeployments = ejbModule.getOpenejbJar().getDeploymentsByEjbName();
            for (EnterpriseBean enterpriseBean : ejbModule.getEjbJar().getEnterpriseBeans()) {
                EjbLink ejbLink;
                ResourceLink resourceLink;
                EjbDeployment ejbDeployment = (EjbDeployment)ejbDeployments.get(enterpriseBean.getEjbName());
                enterpriseBean.setId(ejbDeployment.getDeploymentId());
                for (ResourceRef ref : enterpriseBean.getResourceRef()) {
                    resourceLink = ejbDeployment.getResourceLink(ref.getName());
                    if (resourceLink == null || resourceLink.getResId() == null) continue;
                    ref.setMappedName(resourceLink.getResId());
                }
                for (ResourceRef ref : enterpriseBean.getResourceEnvRef()) {
                    resourceLink = ejbDeployment.getResourceLink(ref.getName());
                    if (resourceLink == null || resourceLink.getResId() == null) continue;
                    ref.setMappedName(resourceLink.getResId());
                }
                for (ResourceRef ref : enterpriseBean.getMessageDestinationRef()) {
                    resourceLink = ejbDeployment.getResourceLink(ref.getName());
                    if (resourceLink == null || resourceLink.getResId() == null) continue;
                    ref.setMappedName(resourceLink.getResId());
                }
                for (ResourceRef ref : enterpriseBean.getEjbRef()) {
                    ejbLink = ejbDeployment.getEjbLink(ref.getName());
                    if (ejbLink == null || ejbLink.getDeployentId() == null) continue;
                    ref.setMappedName(ejbLink.getDeployentId());
                }
                for (ResourceRef ref : enterpriseBean.getEjbLocalRef()) {
                    ejbLink = ejbDeployment.getEjbLink(ref.getName());
                    if (ejbLink == null || ejbLink.getDeployentId() == null) continue;
                    ref.setMappedName(ejbLink.getDeployentId());
                }
            }
        }
        return appModule;
    }
}

