/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.annotation.Resources;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.annotation.security.RunAs;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.ApplicationException;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.DependsOn;
import javax.ejb.EJB;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.EJBs;
import javax.ejb.Init;
import javax.ejb.Local;
import javax.ejb.LocalHome;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.MessageDriven;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.ejb.Remote;
import javax.ejb.RemoteHome;
import javax.ejb.Remove;
import javax.ejb.Schedules;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import javax.ejb.Timeout;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.interceptor.ExcludeClassInterceptors;
import javax.interceptor.ExcludeDefaultInterceptors;
import javax.interceptor.Interceptors;
import javax.jws.HandlerChain;
import javax.jws.WebService;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContexts;
import javax.persistence.PersistenceUnit;
import javax.persistence.PersistenceUnits;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceProvider;
import javax.xml.ws.WebServiceRef;
import javax.xml.ws.WebServiceRefs;
import org.apache.openejb.DeploymentInfo;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.api.LocalClient;
import org.apache.openejb.api.RemoteClient;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ClientModule;
import org.apache.openejb.config.ConnectorModule;
import org.apache.openejb.config.DeploymentLoader;
import org.apache.openejb.config.DeploymentModule;
import org.apache.openejb.config.DynamicDeployer;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.EnvEntriesPropertiesDeployer;
import org.apache.openejb.config.PersistenceContextAnn;
import org.apache.openejb.config.PersistenceContextAnnFactory;
import org.apache.openejb.config.ReadDescriptors;
import org.apache.openejb.config.ValidationContext;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.core.webservices.JaxWsUtils;
import org.apache.openejb.jee.ActivationConfig;
import org.apache.openejb.jee.ApplicationClient;
import org.apache.openejb.jee.AroundInvoke;
import org.apache.openejb.jee.AssemblyDescriptor;
import org.apache.openejb.jee.ConcurrencyAttribute;
import org.apache.openejb.jee.ConcurrencyType;
import org.apache.openejb.jee.ContainerConcurrency;
import org.apache.openejb.jee.ContainerTransaction;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.jee.EjbLocalRef;
import org.apache.openejb.jee.EjbRef;
import org.apache.openejb.jee.EjbReference;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.ExcludeList;
import org.apache.openejb.jee.FacesConfig;
import org.apache.openejb.jee.FacesManagedBean;
import org.apache.openejb.jee.Filter;
import org.apache.openejb.jee.Handler;
import org.apache.openejb.jee.HandlerChains;
import org.apache.openejb.jee.InitMethod;
import org.apache.openejb.jee.InjectionTarget;
import org.apache.openejb.jee.Interceptor;
import org.apache.openejb.jee.InterceptorBinding;
import org.apache.openejb.jee.JndiConsumer;
import org.apache.openejb.jee.JndiReference;
import org.apache.openejb.jee.Lifecycle;
import org.apache.openejb.jee.LifecycleCallback;
import org.apache.openejb.jee.Listener;
import org.apache.openejb.jee.MessageDrivenBean;
import org.apache.openejb.jee.Method;
import org.apache.openejb.jee.MethodAttribute;
import org.apache.openejb.jee.MethodParams;
import org.apache.openejb.jee.MethodPermission;
import org.apache.openejb.jee.MethodSchedule;
import org.apache.openejb.jee.NamedMethod;
import org.apache.openejb.jee.PersistenceContextRef;
import org.apache.openejb.jee.PersistenceContextType;
import org.apache.openejb.jee.PersistenceUnitRef;
import org.apache.openejb.jee.PortComponent;
import org.apache.openejb.jee.Property;
import org.apache.openejb.jee.RemoteBean;
import org.apache.openejb.jee.RemoveMethod;
import org.apache.openejb.jee.ResAuth;
import org.apache.openejb.jee.ResSharingScope;
import org.apache.openejb.jee.ResourceEnvRef;
import org.apache.openejb.jee.ResourceRef;
import org.apache.openejb.jee.Schedule;
import org.apache.openejb.jee.SecurityIdentity;
import org.apache.openejb.jee.SecurityRoleRef;
import org.apache.openejb.jee.ServiceRef;
import org.apache.openejb.jee.Servlet;
import org.apache.openejb.jee.Session;
import org.apache.openejb.jee.SessionBean;
import org.apache.openejb.jee.SessionType;
import org.apache.openejb.jee.SingletonBean;
import org.apache.openejb.jee.StatefulBean;
import org.apache.openejb.jee.StatelessBean;
import org.apache.openejb.jee.Tag;
import org.apache.openejb.jee.TimerConsumer;
import org.apache.openejb.jee.TldTaglib;
import org.apache.openejb.jee.TransAttribute;
import org.apache.openejb.jee.TransactionType;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.WebserviceDescription;
import org.apache.openejb.jee.oejb3.OpenejbJar;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.Join;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.xbean.finder.ClassFinder;

public class AnnotationDeployer
implements DynamicDeployer {
    public static final Logger logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP, AnnotationDeployer.class.getPackage().getName());
    public static final Logger startupLogger = Logger.getInstance(LogCategory.OPENEJB_STARTUP_CONFIG, "org.apache.openejb.util.resources");
    private static final ThreadLocal<DeploymentModule> currentModule = new ThreadLocal();
    private final DiscoverAnnotatedBeans discoverAnnotatedBeans = new DiscoverAnnotatedBeans();
    private final ProcessAnnotatedBeans processAnnotatedBeans = new ProcessAnnotatedBeans();
    private final EnvEntriesPropertiesDeployer envEntriesPropertiesDeployer = new EnvEntriesPropertiesDeployer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AppModule deploy(AppModule appModule) throws OpenEJBException {
        AnnotationDeployer.setModule(appModule);
        try {
            appModule = this.discoverAnnotatedBeans.deploy(appModule);
            appModule = this.envEntriesPropertiesDeployer.deploy(appModule);
            AppModule appModule2 = appModule = this.processAnnotatedBeans.deploy(appModule);
            return appModule2;
        }
        finally {
            AnnotationDeployer.removeModule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebModule deploy(WebModule webModule) throws OpenEJBException {
        AnnotationDeployer.setModule(webModule);
        try {
            webModule = this.discoverAnnotatedBeans.deploy(webModule);
            webModule = this.envEntriesPropertiesDeployer.deploy(webModule);
            WebModule webModule2 = webModule = this.processAnnotatedBeans.deploy(webModule);
            return webModule2;
        }
        finally {
            AnnotationDeployer.removeModule();
        }
    }

    public static DeploymentModule getModule() {
        return currentModule.get();
    }

    private static void setModule(DeploymentModule module) {
        currentModule.set(module);
    }

    private static void removeModule() {
        currentModule.remove();
    }

    private static ValidationContext getValidationContext() {
        return AnnotationDeployer.getModule().getValidation();
    }

    public static class FieldMember
    implements Member {
        private final Field field;

        public FieldMember(Field field) {
            this.field = field;
        }

        public Class getType() {
            return this.field.getType();
        }

        public String toString() {
            return this.field.toString();
        }

        public Class getDeclaringClass() {
            return this.field.getDeclaringClass();
        }

        public String getName() {
            return this.field.getName();
        }
    }

    public static class MethodMember
    implements Member {
        private final java.lang.reflect.Method setter;

        public MethodMember(java.lang.reflect.Method method) {
            this.setter = method;
        }

        public Class getType() {
            return this.setter.getParameterTypes()[0];
        }

        public Class getDeclaringClass() {
            return this.setter.getDeclaringClass();
        }

        public String getName() {
            StringBuilder name = new StringBuilder(this.setter.getName());
            name.delete(0, 3);
            name.setCharAt(0, Character.toLowerCase(name.charAt(0)));
            return name.toString();
        }

        public String toString() {
            return this.setter.toString();
        }
    }

    public static interface Member {
        public Class getDeclaringClass();

        public String getName();

        public Class getType();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ProcessAnnotatedBeans
    implements DynamicDeployer {
        public static final Set<String> knownResourceEnvTypes = new TreeSet<String>(Arrays.asList("javax.ejb.SessionContext", "javax.ejb.EntityContext", "javax.ejb.MessageDrivenContext", "javax.transaction.UserTransaction", "javax.jms.Queue", "javax.jms.Topic", "javax.xml.ws.WebServiceContext", "javax.ejb.TimerService"));
        public static final Set<String> knownEnvironmentEntries = new TreeSet<String>(Arrays.asList("boolean", "java.lang.Boolean", "char", "java.lang.Character", "byte", "java.lang.Byte", "short", "java.lang.Short", "int", "java.lang.Integer", "long", "java.lang.Long", "float", "java.lang.Float", "double", "java.lang.Double", "java.lang.String"));
        private static final String STRICT_INTERFACE_DECLARATION = "openejb.strict.interface.declaration";

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AppModule deploy(AppModule appModule) throws OpenEJBException {
            for (EjbModule ejbModule : appModule.getEjbModules()) {
                AnnotationDeployer.setModule(ejbModule);
                try {
                    this.deploy(ejbModule);
                }
                finally {
                    AnnotationDeployer.removeModule();
                }
            }
            for (ClientModule clientModule : appModule.getClientModules()) {
                AnnotationDeployer.setModule(clientModule);
                try {
                    this.deploy(clientModule);
                }
                finally {
                    AnnotationDeployer.removeModule();
                }
            }
            for (ConnectorModule connectorModule : appModule.getResourceModules()) {
                AnnotationDeployer.setModule(connectorModule);
                try {
                    this.deploy(connectorModule);
                }
                finally {
                    AnnotationDeployer.removeModule();
                }
            }
            for (WebModule webModule : appModule.getWebModules()) {
                AnnotationDeployer.setModule(webModule);
                try {
                    this.deploy(webModule);
                }
                finally {
                    AnnotationDeployer.removeModule();
                }
            }
            return appModule;
        }

        public ClientModule deploy(ClientModule clientModule) throws OpenEJBException {
            ClassFinder inheritedClassFinder;
            Class<?> clazz;
            if (clientModule.getApplicationClient() != null && clientModule.getApplicationClient().isMetadataComplete().booleanValue()) {
                return clientModule;
            }
            ClassLoader classLoader = clientModule.getClassLoader();
            ApplicationClient client = clientModule.getApplicationClient();
            if (client == null) {
                client = new ApplicationClient();
            }
            HashSet<Class> remoteClients = new HashSet<Class>();
            if (clientModule.getMainClass() != null) {
                String className = clientModule.getMainClass();
                if (className.indexOf("/") != -1) {
                    className = className.replaceAll("/", ".");
                    clientModule.setMainClass(className);
                }
                try {
                    Class<?> clazz2 = classLoader.loadClass(className);
                    remoteClients.add(clazz2);
                    ClassFinder inheritedClassFinder2 = this.createInheritedClassFinder(clazz2);
                    this.buildAnnotatedRefs((JndiConsumer)client, inheritedClassFinder2, classLoader);
                }
                catch (ClassNotFoundException e) {
                    if (clientModule.getAltDDs().containsKey("application-client.xml")) {
                        AnnotationDeployer.getValidationContext().fail("client", "client.missingMainClass", className);
                    }
                    AnnotationDeployer.getValidationContext().warn("client", "client.missingMainClass", className);
                }
            }
            for (String className : clientModule.getRemoteClients()) {
                try {
                    clazz = classLoader.loadClass(className);
                    remoteClients.add(clazz);
                }
                catch (ClassNotFoundException e) {
                    throw new OpenEJBException("Unable to load RemoteClient class: " + className, e);
                }
                inheritedClassFinder = this.createInheritedClassFinder(clazz);
                this.buildAnnotatedRefs((JndiConsumer)client, inheritedClassFinder, classLoader);
            }
            for (String className : clientModule.getLocalClients()) {
                try {
                    clazz = classLoader.loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    throw new OpenEJBException("Unable to load LocalClient class: " + className, e);
                }
                inheritedClassFinder = this.createInheritedClassFinder(clazz);
                this.buildAnnotatedRefs((JndiConsumer)client, inheritedClassFinder, classLoader);
            }
            this.validateRemoteClientRefs(classLoader, client, remoteClients);
            this.processWebServiceClientHandlers((JndiConsumer)client, classLoader);
            return clientModule;
        }

        private void validateRemoteClientRefs(ClassLoader classLoader, ApplicationClient client, Set<Class> remoteClients) {
            Class<?> targetClass;
            for (EjbLocalRef ref : client.getEjbLocalRef()) {
                for (InjectionTarget target : ref.getInjectionTarget()) {
                    try {
                        targetClass = classLoader.loadClass(target.getInjectionTargetClass());
                        for (Class remoteClient : remoteClients) {
                            if (!targetClass.isAssignableFrom(remoteClient)) continue;
                            this.fail(remoteClient.getName(), "remoteClient.ejbLocalRef", target.getInjectionTargetClass(), target.getInjectionTargetName());
                        }
                    }
                    catch (ClassNotFoundException ignore) {
                    }
                }
            }
            for (EjbLocalRef ref : client.getPersistenceContextRef()) {
                for (InjectionTarget target : ref.getInjectionTarget()) {
                    try {
                        targetClass = classLoader.loadClass(target.getInjectionTargetClass());
                        for (Class remoteClient : remoteClients) {
                            if (!targetClass.isAssignableFrom(remoteClient)) continue;
                            this.fail(remoteClient.getName(), "remoteClient.persistenceContextRef", target.getInjectionTargetClass(), target.getInjectionTargetName());
                        }
                    }
                    catch (ClassNotFoundException ignore) {
                    }
                }
            }
            ArrayList<String> unusableTypes = new ArrayList<String>(knownResourceEnvTypes);
            unusableTypes.remove("javax.jms.Topic");
            unusableTypes.remove("javax.jms.Queue");
            for (ResourceEnvRef ref : client.getResourceEnvRef()) {
                if (!unusableTypes.contains(ref.getType())) continue;
                for (InjectionTarget target : ref.getInjectionTarget()) {
                    try {
                        Class<?> targetClass2 = classLoader.loadClass(target.getInjectionTargetClass());
                        for (Class remoteClient : remoteClients) {
                            if (!targetClass2.isAssignableFrom(remoteClient)) continue;
                            this.fail(remoteClient.getName(), "remoteClient.resourceEnvRef", target.getInjectionTargetClass(), target.getInjectionTargetName(), ref.getType());
                        }
                    }
                    catch (ClassNotFoundException ignore) {
                    }
                }
            }
        }

        public ConnectorModule deploy(ConnectorModule connectorModule) throws OpenEJBException {
            return connectorModule;
        }

        public WebModule deploy(WebModule webModule) throws OpenEJBException {
            Class<?> clazz;
            Class<?> clazz2;
            WebApp webApp = webModule.getWebApp();
            if (webApp != null && webApp.isMetadataComplete().booleanValue()) {
                return webModule;
            }
            HashSet classes = new HashSet();
            ClassLoader classLoader = webModule.getClassLoader();
            for (Servlet servlet : webApp.getServlet()) {
                String servletClass = servlet.getServletClass();
                if (servletClass == null) continue;
                try {
                    Class<?> clazz22 = classLoader.loadClass(servletClass);
                    classes.add(clazz22);
                }
                catch (ClassNotFoundException e) {
                    throw new OpenEJBException("Unable to load servlet class: " + servletClass, e);
                }
            }
            for (Filter filter : webApp.getFilter()) {
                String filterClass = filter.getFilterClass();
                if (filterClass == null) continue;
                try {
                    clazz2 = classLoader.loadClass(filterClass);
                    classes.add(clazz2);
                }
                catch (ClassNotFoundException e) {
                    throw new OpenEJBException("Unable to load servlet filter class: " + filterClass, e);
                }
            }
            for (Listener listener : webApp.getListener()) {
                String listenerClass = listener.getListenerClass();
                if (listenerClass == null) continue;
                try {
                    clazz2 = classLoader.loadClass(listenerClass);
                    classes.add(clazz2);
                }
                catch (ClassNotFoundException e) {
                    throw new OpenEJBException("Unable to load servlet listener class: " + listenerClass, e);
                }
            }
            for (TldTaglib taglib : webModule.getTaglibs()) {
                for (Listener listener : taglib.getListener()) {
                    String string = listener.getListenerClass();
                    if (string == null) continue;
                    try {
                        clazz = classLoader.loadClass(string);
                        classes.add(clazz);
                    }
                    catch (ClassNotFoundException e) {
                        throw new OpenEJBException("Unable to load tag library servlet listener class: " + string, e);
                    }
                }
                for (Tag tag : taglib.getTag()) {
                    String string = tag.getTagClass();
                    if (string == null) continue;
                    try {
                        clazz = classLoader.loadClass(string);
                        classes.add(clazz);
                    }
                    catch (ClassNotFoundException e) {
                        throw new OpenEJBException("Unable to load tag library tag class: " + string, e);
                    }
                }
            }
            if (webModule.getWebservices() != null) {
                for (WebserviceDescription webservice : webModule.getWebservices().getWebserviceDescription()) {
                    for (PortComponent port : webservice.getPortComponent()) {
                        if (port.getServiceImplBean().getEjbLink() != null || port.getHandlerChains() == null) continue;
                        for (org.apache.openejb.jee.HandlerChain handlerChain : port.getHandlerChains().getHandlerChain()) {
                            for (Handler handler : handlerChain.getHandler()) {
                                String handlerClass = handler.getHandlerClass();
                                if (handlerClass == null) continue;
                                try {
                                    Class<?> clazz3 = classLoader.loadClass(handlerClass);
                                    classes.add(clazz3);
                                }
                                catch (ClassNotFoundException e) {
                                    throw new OpenEJBException("Unable to load webservice handler class: " + handlerClass, e);
                                }
                            }
                        }
                    }
                }
            }
            for (FacesConfig facesConfig : webModule.getFacesConfigs()) {
                for (FacesManagedBean bean : facesConfig.getManagedBean()) {
                    String string = bean.getManagedBeanClass().trim();
                    if (string == null) continue;
                    try {
                        clazz = classLoader.loadClass(string);
                        classes.add(clazz);
                    }
                    catch (ClassNotFoundException e) {
                        throw new OpenEJBException("Unable to load JSF managed bean class: " + string, e);
                    }
                }
            }
            ClassFinder finder = webModule.getFinder();
            if (finder != null) {
                String[] webComponentAnnotations = new String[]{"javax.faces.bean.ManagedBean", "javax.servlet.annotation.WebServlet", "javax.servlet.annotation.WebServletContextListener", "javax.servlet.annotation.ServletFilter"};
                ArrayList<Class<Annotation>> annotations = new ArrayList<Class<Annotation>>();
                for (String componentAnnotationName : webComponentAnnotations) {
                    try {
                        Class<?> clazz4 = classLoader.loadClass(componentAnnotationName);
                        annotations.add(clazz4.asSubclass(Annotation.class));
                    }
                    catch (ClassNotFoundException e) {
                        logger.debug("Support not enabled: " + componentAnnotationName);
                    }
                }
                for (Class clazz3 : annotations) {
                    logger.debug("Scanning for @" + clazz3.getName());
                    List list = finder.findAnnotatedClasses(clazz3);
                    if (logger.isDebugEnabled()) {
                        for (Class clazz4 : list) {
                            logger.debug("Found " + clazz4.getName());
                        }
                    }
                    classes.addAll(list);
                }
            }
            ClassFinder inheritedClassFinder = this.createInheritedClassFinder(classes.toArray(new Class[classes.size()]));
            this.buildAnnotatedRefs((JndiConsumer)webApp, inheritedClassFinder, classLoader);
            this.processWebServiceClientHandlers((JndiConsumer)webApp, classLoader);
            return webModule;
        }

        /*
         * Could not resolve type clashes
         */
        public EjbModule deploy(EjbModule ejbModule) throws OpenEJBException {
            EnterpriseBean[] enterpriseBeans;
            if (ejbModule.getEjbJar() != null && ejbModule.getEjbJar().isMetadataComplete().booleanValue()) {
                return ejbModule;
            }
            ClassLoader classLoader = ejbModule.getClassLoader();
            for (EnterpriseBean bean : enterpriseBeans = ejbModule.getEjbJar().getEnterpriseBeans()) {
                InterceptorBinding binding;
                EjbJar ejbJar;
                Interceptors interceptors;
                java.lang.reflect.Method method2;
                Class<?> clazz;
                String ejbName = bean.getEjbName();
                try {
                    clazz = classLoader.loadClass(bean.getEjbClass());
                }
                catch (ClassNotFoundException e) {
                    throw new OpenEJBException("Unable to load bean class: " + bean.getEjbClass(), e);
                }
                ClassFinder classFinder = new ClassFinder(new Class[]{clazz});
                ClassFinder inheritedClassFinder = this.createInheritedClassFinder(clazz);
                this.processCallbacks((Lifecycle)bean, inheritedClassFinder);
                if (bean.getTransactionType() == null) {
                    TransactionManagement tx = this.getInheritableAnnotation(clazz, TransactionManagement.class);
                    TransactionManagementType transactionType = TransactionManagementType.CONTAINER;
                    if (tx != null) {
                        transactionType = tx.value();
                    }
                    switch (transactionType) {
                        case BEAN: {
                            bean.setTransactionType(TransactionType.BEAN);
                            break;
                        }
                        case CONTAINER: {
                            bean.setTransactionType(TransactionType.CONTAINER);
                        }
                    }
                }
                AssemblyDescriptor assemblyDescriptor = ejbModule.getEjbJar().getAssemblyDescriptor();
                this.processApplicationExceptions(clazz, assemblyDescriptor);
                if (bean.getTransactionType() == TransactionType.CONTAINER) {
                    this.processAttributes(new TransactionAttributeHandler(assemblyDescriptor, ejbName), clazz, inheritedClassFinder);
                } else {
                    this.checkAttributes(new TransactionAttributeHandler(assemblyDescriptor, ejbName), ejbName, ejbModule, classFinder, "invalidTransactionAttribute");
                }
                this.processSecurityAnnotations(clazz, ejbName, ejbModule, inheritedClassFinder, bean);
                HashSet scheduleMethods = new HashSet();
                scheduleMethods.addAll(inheritedClassFinder.findAnnotatedMethods(Schedules.class));
                scheduleMethods.addAll(inheritedClassFinder.findAnnotatedMethods(javax.ejb.Schedule.class));
                Map existingDeclarations = assemblyDescriptor.getMethodScheduleMap(ejbName);
                Iterator i$ = scheduleMethods.iterator();
                while (i$.hasNext() && !this.hasMethodAttribute(existingDeclarations, method2 = (java.lang.reflect.Method)i$.next())) {
                    javax.ejb.Schedule scheduleAnnotation;
                    ArrayList<javax.ejb.Schedule> list = new ArrayList<javax.ejb.Schedule>();
                    Schedules schedulesAnnotation = method2.getAnnotation(Schedules.class);
                    if (schedulesAnnotation != null) {
                        list.addAll(Arrays.asList(schedulesAnnotation.value()));
                    }
                    if ((scheduleAnnotation = method2.getAnnotation(javax.ejb.Schedule.class)) != null) {
                        list.add(scheduleAnnotation);
                    }
                    if (list.size() == 0) continue;
                    MethodSchedule methodSchedule = new MethodSchedule(ejbName, method2, new Schedule[0]);
                    for (javax.ejb.Schedule schedule : list) {
                        Schedule s = new Schedule();
                        s.setSecond(schedule.second());
                        s.setMinute(schedule.minute());
                        s.setHour(schedule.hour());
                        s.setDayOfWeek(schedule.dayOfWeek());
                        s.setDayOfMonth(schedule.dayOfMonth());
                        s.setMonth(schedule.month());
                        s.setYear(schedule.year());
                        s.setPersistent(schedule.persistent());
                        s.setInfo(schedule.info());
                        methodSchedule.getSchedule().add(s);
                    }
                    assemblyDescriptor.getMethodSchedule().add(methodSchedule);
                }
                for (InterceptorBinding binding2 : assemblyDescriptor.getInterceptorBinding()) {
                    EjbJar ejbJar2 = ejbModule.getEjbJar();
                    ArrayList list = new ArrayList(binding2.getInterceptorClass());
                    if (binding2.getInterceptorOrder() != null) {
                        list.clear();
                        list.addAll(binding2.getInterceptorOrder().getInterceptorClass());
                    }
                    for (String interceptor : list) {
                        if (ejbJar2.getInterceptor(interceptor) != null) continue;
                        logger.debug("Adding '<ejb-jar><interceptors><interceptor>' entry for undeclared interceptor " + interceptor);
                        ejbJar2.addInterceptor(new Interceptor(interceptor));
                    }
                }
                for (Class interceptorsAnnotatedClass : inheritedClassFinder.findAnnotatedClasses(Interceptors.class)) {
                    interceptors = interceptorsAnnotatedClass.getAnnotation(Interceptors.class);
                    ejbJar = ejbModule.getEjbJar();
                    for (Class interceptor : interceptors.value()) {
                        if (ejbJar.getInterceptor(interceptor.getName()) != null) continue;
                        ejbJar.addInterceptor(new Interceptor(interceptor.getName()));
                    }
                    binding = new InterceptorBinding(bean, new Interceptor[0]);
                    assemblyDescriptor.getInterceptorBinding().add(0, binding);
                    for (Class interceptor : interceptors.value()) {
                        binding.getInterceptorClass().add(interceptor.getName());
                    }
                }
                for (java.lang.reflect.Method method2 : inheritedClassFinder.findAnnotatedMethods(Interceptors.class)) {
                    interceptors = method2.getAnnotation(Interceptors.class);
                    if (interceptors == null) continue;
                    ejbJar = ejbModule.getEjbJar();
                    for (Class interceptor : interceptors.value()) {
                        if (ejbJar.getInterceptor(interceptor.getName()) != null) continue;
                        ejbJar.addInterceptor(new Interceptor(interceptor.getName()));
                    }
                    binding = new InterceptorBinding(bean, new Interceptor[0]);
                    assemblyDescriptor.getInterceptorBinding().add(0, binding);
                    for (Class interceptor : interceptors.value()) {
                        binding.getInterceptorClass().add(interceptor.getName());
                    }
                    binding.setMethod(new NamedMethod(method2));
                }
                ExcludeDefaultInterceptors excludeDefaultInterceptors = clazz.getAnnotation(ExcludeDefaultInterceptors.class);
                if (excludeDefaultInterceptors != null) {
                    InterceptorBinding binding2;
                    binding2 = assemblyDescriptor.addInterceptorBinding(new InterceptorBinding(bean, new Interceptor[0]));
                    binding2.setExcludeDefaultInterceptors(true);
                }
                for (java.lang.reflect.Method method3 : classFinder.findAnnotatedMethods(ExcludeDefaultInterceptors.class)) {
                    InterceptorBinding binding3 = assemblyDescriptor.addInterceptorBinding(new InterceptorBinding(bean, new Interceptor[0]));
                    binding3.setExcludeDefaultInterceptors(true);
                    binding3.setMethod(new NamedMethod(method3));
                }
                ExcludeClassInterceptors excludeClassInterceptors = clazz.getAnnotation(ExcludeClassInterceptors.class);
                if (excludeClassInterceptors != null) {
                    InterceptorBinding binding4 = assemblyDescriptor.addInterceptorBinding(new InterceptorBinding(bean, new Interceptor[0]));
                    binding4.setExcludeClassInterceptors(true);
                }
                for (java.lang.reflect.Method method4 : classFinder.findAnnotatedMethods(ExcludeClassInterceptors.class)) {
                    binding = assemblyDescriptor.addInterceptorBinding(new InterceptorBinding(bean, new Interceptor[0]));
                    binding.setExcludeClassInterceptors(true);
                    binding.setMethod(new NamedMethod(method4));
                }
                if (bean instanceof RemoteBean) {
                    LocalHome localHome;
                    java.lang.reflect.Method create;
                    Class homeClass;
                    RemoteHome remoteHome;
                    RemoteBean remoteBean = (RemoteBean)bean;
                    if (remoteBean.getHome() == null && (remoteHome = this.getInheritableAnnotation(clazz, RemoteHome.class)) != null) {
                        homeClass = remoteHome.value();
                        try {
                            create = null;
                            for (java.lang.reflect.Method method5 : homeClass.getMethods()) {
                                if (!method5.getName().startsWith("create")) continue;
                                create = method5;
                                break;
                            }
                            if (create == null) {
                                throw new NoSuchMethodException("create");
                            }
                            Class<?> remoteClass = create.getReturnType();
                            remoteBean.setHome(homeClass.getName());
                            remoteBean.setRemote(remoteClass.getName());
                        }
                        catch (NoSuchMethodException e) {
                            logger.error("Class annotated as a RemoteHome has no 'create()' method.  Unable to determine remote interface type.  Bean class: " + clazz.getName() + ",  Home class: " + homeClass.getName());
                        }
                    }
                    if (remoteBean.getLocalHome() == null && (localHome = this.getInheritableAnnotation(clazz, LocalHome.class)) != null) {
                        homeClass = localHome.value();
                        try {
                            create = null;
                            for (java.lang.reflect.Method method5 : homeClass.getMethods()) {
                                if (!method5.getName().startsWith("create")) continue;
                                create = method5;
                                break;
                            }
                            if (create == null) {
                                throw new NoSuchMethodException("create");
                            }
                            Class<?> remoteClass = create.getReturnType();
                            remoteBean.setLocalHome(homeClass.getName());
                            remoteBean.setLocal(remoteClass.getName());
                        }
                        catch (NoSuchMethodException e) {
                            logger.error("Class annotated as a LocalHome has no 'create()' method.  Unable to determine remote interface type.  Bean class: " + clazz.getName() + ",  Home class: " + homeClass.getName());
                        }
                    }
                    if (remoteBean instanceof SessionBean) {
                        SessionBean sessionBean = (SessionBean)remoteBean;
                        this.processSessionInterfaces(sessionBean, clazz, ejbModule);
                        if (sessionBean.getSessionType() == SessionType.SINGLETON) {
                            if (sessionBean.getConcurrencyType() == null) {
                                ConcurrencyManagement tx = this.getInheritableAnnotation(clazz, ConcurrencyManagement.class);
                                ConcurrencyManagementType concurrencyType = ConcurrencyManagementType.CONTAINER;
                                if (tx != null) {
                                    concurrencyType = tx.value();
                                }
                                switch (concurrencyType) {
                                    case BEAN: {
                                        sessionBean.setConcurrencyType(ConcurrencyType.BEAN);
                                        break;
                                    }
                                    case CONTAINER: {
                                        sessionBean.setConcurrencyType(ConcurrencyType.CONTAINER);
                                    }
                                }
                            }
                            if (sessionBean.getConcurrencyType() == ConcurrencyType.CONTAINER) {
                                this.processAttributes(new ConcurrencyAttributeHandler(assemblyDescriptor, ejbName), clazz, inheritedClassFinder);
                            } else {
                                this.checkAttributes(new ConcurrencyAttributeHandler(assemblyDescriptor, ejbName), ejbName, ejbModule, classFinder, "invalidConcurrencyAttribute");
                            }
                            if (!sessionBean.hasLoadOnStartup()) {
                                Startup startup = this.getInheritableAnnotation(clazz, Startup.class);
                                sessionBean.setLoadOnStartup(startup != null);
                            }
                            if (sessionBean.getDependsOn() == null) {
                                DependsOn dependsOn = this.getInheritableAnnotation(clazz, DependsOn.class);
                                if (dependsOn != null) {
                                    sessionBean.setDependsOn(dependsOn.value());
                                } else {
                                    sessionBean.setDependsOn(Collections.EMPTY_LIST);
                                }
                            }
                        }
                    }
                }
                if (bean instanceof MessageDrivenBean) {
                    MessageDrivenBean mdb = (MessageDrivenBean)bean;
                    MessageDriven messageDriven = clazz.getAnnotation(MessageDriven.class);
                    if (messageDriven != null) {
                        Class interfce;
                        ActivationConfigProperty[] configProperties = messageDriven.activationConfig();
                        if (configProperties != null) {
                            ActivationConfig activationConfig = mdb.getActivationConfig();
                            if (activationConfig == null) {
                                activationConfig = new ActivationConfig();
                                mdb.setActivationConfig(activationConfig);
                            }
                            Properties properties = activationConfig.toProperties();
                            for (ActivationConfigProperty property : configProperties) {
                                if (properties.containsKey(property.propertyName())) continue;
                                activationConfig.addProperty(property.propertyName(), property.propertyValue());
                            }
                        }
                        if (mdb.getMessagingType() == null && (interfce = messageDriven.messageListenerInterface()) != null && !interfce.equals(Object.class)) {
                            if (!interfce.isInterface()) {
                                throw new OpenEJBException("MessageListenerInterface property of @MessageDriven is not an interface");
                            }
                            mdb.setMessagingType(interfce.getName());
                        }
                    }
                    if (mdb.getMessagingType() == null) {
                        ArrayList<Class> interfaces = new ArrayList<Class>();
                        for (Class intf : clazz.getInterfaces()) {
                            String name = intf.getName();
                            if (name.equals("java.io.Serializable") || name.equals("java.io.Externalizable") || name.startsWith("javax.ejb.")) continue;
                            interfaces.add(intf);
                        }
                        if (interfaces.size() != 1) {
                            String msg = "When annotating a bean class as @MessageDriven without declaring messageListenerInterface, the bean must implement exactly one interface, no more and no less. beanClass=" + clazz.getName() + " interfaces=";
                            for (Class intf : interfaces) {
                                msg = msg + intf.getName() + ", ";
                            }
                            throw new IllegalStateException(msg);
                        }
                        mdb.setMessagingType(((Class)interfaces.get(0)).getName());
                    }
                }
                HashSet classes = new HashSet();
                classes.add(clazz);
                if (ejbModule.getWebservices() != null) {
                    for (WebserviceDescription webservice : ejbModule.getWebservices().getWebserviceDescription()) {
                        for (PortComponent port : webservice.getPortComponent()) {
                            if (!ejbName.equals(port.getServiceImplBean().getEjbLink()) || port.getHandlerChains() == null) continue;
                            for (org.apache.openejb.jee.HandlerChain handlerChain : port.getHandlerChains().getHandlerChain()) {
                                for (Handler handler : handlerChain.getHandler()) {
                                    String handlerClass = handler.getHandlerClass();
                                    if (handlerClass == null) continue;
                                    try {
                                        Class<?> handlerClazz = classLoader.loadClass(handlerClass);
                                        classes.add(handlerClazz);
                                    }
                                    catch (ClassNotFoundException e) {
                                        throw new OpenEJBException("Unable to load webservice handler class: " + handlerClass, e);
                                    }
                                }
                            }
                        }
                    }
                }
                inheritedClassFinder = this.createInheritedClassFinder(classes.toArray(new Class[classes.size()]));
                this.buildAnnotatedRefs((JndiConsumer)bean, inheritedClassFinder, classLoader);
                this.processWebServiceClientHandlers((JndiConsumer)bean, classLoader);
            }
            for (EnterpriseBean interceptor : ejbModule.getEjbJar().getInterceptors()) {
                Class<?> clazz;
                try {
                    clazz = classLoader.loadClass(interceptor.getInterceptorClass());
                }
                catch (ClassNotFoundException e) {
                    throw new OpenEJBException("Unable to load interceptor class: " + interceptor.getInterceptorClass(), e);
                }
                ClassFinder inheritedClassFinder = this.createInheritedClassFinder(clazz);
                this.processCallbacks((Lifecycle)interceptor, inheritedClassFinder);
                this.processApplicationExceptions(clazz, ejbModule.getEjbJar().getAssemblyDescriptor());
                this.buildAnnotatedRefs((JndiConsumer)interceptor, inheritedClassFinder, classLoader);
                this.processWebServiceClientHandlers((JndiConsumer)interceptor, classLoader);
                for (EnterpriseBean bean : enterpriseBeans) {
                    bean.getEnvEntry().addAll(interceptor.getEnvEntry());
                    bean.getEjbRef().addAll(interceptor.getEjbRef());
                    bean.getEjbLocalRef().addAll(interceptor.getEjbLocalRef());
                    bean.getResourceRef().addAll(interceptor.getResourceRef());
                    bean.getResourceEnvRef().addAll(interceptor.getResourceEnvRef());
                    bean.getPersistenceContextRef().addAll(interceptor.getPersistenceContextRef());
                    bean.getPersistenceUnitRef().addAll(interceptor.getPersistenceUnitRef());
                    bean.getMessageDestinationRef().addAll(interceptor.getMessageDestinationRef());
                    bean.getServiceRef().addAll(interceptor.getServiceRef());
                }
            }
            return ejbModule;
        }

        private boolean hasMethodAttribute(Map<String, List<MethodAttribute>> existingDeclarations, java.lang.reflect.Method method) {
            MethodAttribute attribute;
            MethodParams methodParams;
            List<MethodAttribute> list = existingDeclarations.get(method.getName());
            if (list == null) {
                return false;
            }
            Iterator<MethodAttribute> i$ = list.iterator();
            if (i$.hasNext() && (methodParams = (attribute = i$.next()).getMethodParams()) != null) {
                List params1 = methodParams.getMethodParam();
                String[] params2 = this.asStrings(method.getParameterTypes());
                if (params1.size() == params2.length) {
                    String b;
                    String a;
                    for (int i = 0; i < params1.size() && (a = (String)params1.get(i)).equals(b = params2[i]); ++i) {
                    }
                    return true;
                }
            }
            return false;
        }

        private void processApplicationExceptions(Class<?> clazz, AssemblyDescriptor assemblyDescriptor) {
            for (java.lang.reflect.Method method : clazz.getMethods()) {
                for (Class<?> exception : method.getExceptionTypes()) {
                    ApplicationException annotation = exception.getAnnotation(ApplicationException.class);
                    if (annotation == null || assemblyDescriptor.getApplicationException(exception) != null) continue;
                    assemblyDescriptor.addApplicationException(exception, annotation.rollback());
                }
            }
        }

        private void processSessionInterfaces(SessionBean sessionBean, Class<?> beanClass, EjbModule ejbModule) {
            ValidationContext validation = ejbModule.getValidation();
            String ejbName = sessionBean.getEjbName();
            boolean strict = this.getProperty(ejbModule, STRICT_INTERFACE_DECLARATION, "false").equalsIgnoreCase("true");
            ArrayList<String> descriptor = new ArrayList<String>();
            descriptor.add(sessionBean.getHome());
            descriptor.add(sessionBean.getRemote());
            descriptor.add(sessionBean.getLocalHome());
            descriptor.add(sessionBean.getLocal());
            descriptor.addAll(sessionBean.getBusinessLocal());
            descriptor.addAll(sessionBean.getBusinessRemote());
            descriptor.add(sessionBean.getServiceEndpoint());
            BusinessInterfaces xml = new BusinessInterfaces();
            xml.addLocals(sessionBean.getBusinessLocal(), ejbModule.getClassLoader());
            xml.addRemotes(sessionBean.getBusinessRemote(), ejbModule.getClassLoader());
            if (strict) {
                for (Class interfce : xml.local) {
                    if (!xml.remote.contains(interfce)) continue;
                    validation.fail(ejbName, "xml.localRemote.conflict", interfce.getName());
                }
            }
            BusinessInterfaces all = new BusinessInterfaces();
            all.local.addAll(xml.local);
            all.remote.addAll(xml.remote);
            for (Class<?> clazz : this.ancestors(beanClass)) {
                if (sessionBean.getServiceEndpoint() == null) {
                    Class defaultEndpoint = DeploymentInfo.ServiceEndpoint.class;
                    for (Class<?> interfce : clazz.getInterfaces()) {
                        if (!interfce.isAnnotationPresent(WebService.class)) continue;
                        defaultEndpoint = interfce;
                    }
                    WebService webService = clazz.getAnnotation(WebService.class);
                    if (webService != null) {
                        String className = webService.endpointInterface();
                        if (!className.equals("")) {
                            sessionBean.setServiceEndpoint(className);
                        } else {
                            sessionBean.setServiceEndpoint(defaultEndpoint.getName());
                        }
                    } else if (clazz.isAnnotationPresent(WebServiceProvider.class)) {
                        sessionBean.setServiceEndpoint(defaultEndpoint.getName());
                    } else if (!defaultEndpoint.equals(DeploymentInfo.ServiceEndpoint.class)) {
                        sessionBean.setServiceEndpoint(defaultEndpoint.getName());
                    }
                }
                ArrayList interfaces = new ArrayList();
                for (Class<?> interfce : clazz.getInterfaces()) {
                    String name = interfce.getName();
                    if (name.equals("java.io.Serializable") || name.equals("java.io.Externalizable") || name.startsWith("javax.ejb.") || descriptor.contains(interfce.getName())) continue;
                    interfaces.add(interfce);
                }
                interfaces.removeAll(all.local);
                interfaces.removeAll(all.remote);
                Local local = clazz.getAnnotation(Local.class);
                Remote remote = clazz.getAnnotation(Remote.class);
                boolean impliedLocal = local != null && local.value().length == 0;
                boolean impliedRemote = remote != null && remote.value().length == 0;
                BusinessInterfaces bean = new BusinessInterfaces();
                if (local != null) {
                    bean.local.addAll(Arrays.asList(local.value()));
                }
                if (remote != null) {
                    bean.remote.addAll(Arrays.asList(remote.value()));
                }
                if (strict) {
                    for (Class interfce : bean.local) {
                        if (!bean.remote.contains(interfce)) continue;
                        validation.fail(ejbName, "ann.localRemote.conflict", interfce.getName());
                    }
                }
                interfaces.removeAll(bean.local);
                interfaces.removeAll(bean.remote);
                if (impliedLocal || impliedRemote) {
                    if (interfaces.size() == 1) {
                        Class interfce = (Class)interfaces.remove(0);
                        if (strict && impliedLocal && impliedRemote) {
                            validation.fail(ejbName, "ann.localRemote.ambiguous", interfce.getName());
                        } else {
                            if (impliedLocal) {
                                bean.local.add(interfce);
                            }
                            if (impliedRemote) {
                                bean.remote.add(interfce);
                            }
                        }
                    } else {
                        if (impliedLocal) {
                            validation.fail(ejbName, "ann.local.noAttributes", Join.join(", ", interfaces));
                        }
                        if (impliedRemote) {
                            validation.fail(ejbName, "ann.remote.noAttributes", Join.join(", ", interfaces));
                        }
                        return;
                    }
                }
                BusinessInterfaces implemented = new BusinessInterfaces();
                for (Class clazz2 : interfaces) {
                    boolean isLocal = clazz2.isAnnotationPresent(Local.class);
                    boolean isRemote = clazz2.isAnnotationPresent(Remote.class);
                    if (strict && isLocal && isRemote) {
                        validation.fail(ejbName, "ann.localRemote.conflict", clazz2.getName());
                        continue;
                    }
                    if (isLocal) {
                        implemented.local.add(clazz2);
                    }
                    if (!isRemote) continue;
                    implemented.remote.add(clazz2);
                }
                interfaces.removeAll(implemented.local);
                interfaces.removeAll(implemented.remote);
                bean.local.removeAll(all.local);
                bean.local.removeAll(all.remote);
                bean.remote.removeAll(all.remote);
                bean.remote.removeAll(all.local);
                for (Class clazz3 : bean.local) {
                    this.validateLocalInterface(clazz3, validation, ejbName);
                }
                for (Class clazz4 : bean.remote) {
                    this.validateRemoteInterface(clazz4, validation, ejbName);
                }
                all.local.addAll(bean.local);
                all.remote.addAll(bean.remote);
                implemented.local.removeAll(all.local);
                implemented.local.removeAll(all.remote);
                implemented.remote.removeAll(all.remote);
                implemented.remote.removeAll(all.local);
                for (Class clazz5 : implemented.local) {
                    this.validateLocalInterface(clazz5, validation, ejbName);
                }
                for (Class clazz6 : implemented.remote) {
                    this.validateRemoteInterface(clazz6, validation, ejbName);
                }
                all.local.addAll(implemented.local);
                all.remote.addAll(implemented.remote);
                all.unspecified.addAll(interfaces);
            }
            for (Class<Object> interfce : all.local) {
                sessionBean.addBusinessLocal(interfce);
            }
            for (Class<Object> interfce : all.remote) {
                sessionBean.addBusinessRemote(interfce);
            }
            for (Class<Object> interfce : all.unspecified) {
                sessionBean.addBusinessLocal(interfce);
            }
        }

        private String getProperty(EjbModule ejbModule, String key, String defaultValue) {
            OpenejbJar openejbJar = ejbModule.getOpenejbJar();
            String value = SystemInstance.get().getProperty(key, defaultValue);
            if (openejbJar != null && openejbJar.getProperties() != null) {
                value = openejbJar.getProperties().getProperty(key, value);
            }
            return value;
        }

        private void processSecurityAnnotations(Class<?> beanClass, String ejbName, EjbModule ejbModule, ClassFinder classFinder, EnterpriseBean bean) {
            List securityRoleRefs;
            RemoteBean remoteBean;
            MethodPermission methodPermission;
            AssemblyDescriptor assemblyDescriptor = ejbModule.getEjbJar().getAssemblyDescriptor();
            List<String> classPermissions = this.getDeclaredClassPermissions(assemblyDescriptor, ejbName);
            for (Class<?> clazz : this.ancestors(beanClass)) {
                DeclareRoles declareRoles;
                RunAs runAs;
                if (!classPermissions.contains("*") || !classPermissions.contains(clazz.getName())) {
                    RolesAllowed rolesAllowed = clazz.getAnnotation(RolesAllowed.class);
                    PermitAll permitAll = clazz.getAnnotation(PermitAll.class);
                    if (rolesAllowed != null && permitAll != null) {
                        ejbModule.getValidation().fail(ejbName, "permitAllAndRolesAllowedOnClass", clazz.getName());
                    }
                    if (rolesAllowed != null) {
                        methodPermission = new MethodPermission();
                        methodPermission.getRoleName().addAll(Arrays.asList(rolesAllowed.value()));
                        methodPermission.getMethod().add(new Method(ejbName, clazz.getName(), "*"));
                        assemblyDescriptor.getMethodPermission().add(methodPermission);
                        remoteBean = (RemoteBean)bean;
                        securityRoleRefs = remoteBean.getSecurityRoleRef();
                        for (String role : rolesAllowed.value()) {
                            securityRoleRefs.add(new SecurityRoleRef(role));
                        }
                    }
                    if (permitAll != null) {
                        methodPermission = new MethodPermission();
                        methodPermission.setUnchecked(true);
                        methodPermission.getMethod().add(new Method(ejbName, clazz.getName(), "*"));
                        assemblyDescriptor.getMethodPermission().add(methodPermission);
                    }
                }
                if ((runAs = clazz.getAnnotation(RunAs.class)) != null && bean.getSecurityIdentity() == null) {
                    SecurityIdentity securityIdentity = new SecurityIdentity();
                    securityIdentity.setRunAs(runAs.value());
                    bean.setSecurityIdentity(securityIdentity);
                }
                if ((declareRoles = clazz.getAnnotation(DeclareRoles.class)) == null || !(bean instanceof RemoteBean)) continue;
                RemoteBean remoteBean2 = (RemoteBean)bean;
                List securityRoleRefs2 = remoteBean2.getSecurityRoleRef();
                for (String role : declareRoles.value()) {
                    securityRoleRefs2.add(new SecurityRoleRef(role));
                }
            }
            ArrayList<java.lang.reflect.Method> seen = new ArrayList<java.lang.reflect.Method>();
            for (java.lang.reflect.Method method : classFinder.findAnnotatedMethods(RolesAllowed.class)) {
                this.checkConflictingSecurityAnnotations(method, ejbName, ejbModule, seen);
                RolesAllowed rolesAllowed = method.getAnnotation(RolesAllowed.class);
                methodPermission = new MethodPermission();
                methodPermission.getRoleName().addAll(Arrays.asList(rolesAllowed.value()));
                methodPermission.getMethod().add(new Method(ejbName, method));
                assemblyDescriptor.getMethodPermission().add(methodPermission);
                remoteBean = (RemoteBean)bean;
                securityRoleRefs = remoteBean.getSecurityRoleRef();
                for (String role : rolesAllowed.value()) {
                    securityRoleRefs.add(new SecurityRoleRef(role));
                }
            }
            for (java.lang.reflect.Method method : classFinder.findAnnotatedMethods(PermitAll.class)) {
                this.checkConflictingSecurityAnnotations(method, ejbName, ejbModule, seen);
                MethodPermission methodPermission2 = new MethodPermission();
                methodPermission2.setUnchecked(true);
                methodPermission2.getMethod().add(new Method(ejbName, method));
                assemblyDescriptor.getMethodPermission().add(methodPermission2);
            }
            for (java.lang.reflect.Method method : classFinder.findAnnotatedMethods(DenyAll.class)) {
                this.checkConflictingSecurityAnnotations(method, ejbName, ejbModule, seen);
                ExcludeList excludeList = assemblyDescriptor.getExcludeList();
                excludeList.addMethod(new Method(ejbName, method));
            }
        }

        private void checkConflictingSecurityAnnotations(java.lang.reflect.Method method, String ejbName, EjbModule ejbModule, List<java.lang.reflect.Method> seen) {
            if (seen.contains(method)) {
                return;
            }
            seen.add(method);
            ArrayList<String> annotations = new ArrayList<String>();
            for (Class annotation : Arrays.asList(RolesAllowed.class, PermitAll.class, DenyAll.class)) {
                if (method.getAnnotation(annotation) == null) continue;
                annotations.add("@" + annotation.getSimpleName());
            }
            if (annotations.size() > 1) {
                ejbModule.getValidation().fail(ejbName, "conflictingSecurityAnnotations", method.getName(), Join.join(" and ", annotations), method.getDeclaringClass());
            }
        }

        private void processCallbacks(Lifecycle bean, ClassFinder classFinder) {
            TimerConsumer timerConsumer;
            AroundInvoke aroundInvoke;
            LifecycleCallback preDestroy;
            LifecycleCallback postConstruct = (LifecycleCallback)this.getFirst(bean.getPostConstruct());
            if (postConstruct == null) {
                for (java.lang.reflect.Method method : classFinder.findAnnotatedMethods(PostConstruct.class)) {
                    bean.getPostConstruct().add(new LifecycleCallback(method));
                }
            }
            if ((preDestroy = (LifecycleCallback)this.getFirst(bean.getPreDestroy())) == null) {
                for (java.lang.reflect.Method method : classFinder.findAnnotatedMethods(PreDestroy.class)) {
                    bean.getPreDestroy().add(new LifecycleCallback(method));
                }
            }
            if ((aroundInvoke = (AroundInvoke)this.getFirst(bean.getAroundInvoke())) == null) {
                for (java.lang.reflect.Method method : classFinder.findAnnotatedMethods(javax.interceptor.AroundInvoke.class)) {
                    bean.getAroundInvoke().add(new AroundInvoke(method));
                }
            }
            if (bean instanceof TimerConsumer && (timerConsumer = (TimerConsumer)bean).getTimeoutMethod() == null) {
                List timeoutMethods = classFinder.findAnnotatedMethods(Timeout.class);
                for (java.lang.reflect.Method method : timeoutMethods) {
                    timerConsumer.setTimeoutMethod(new NamedMethod(method));
                }
            }
            if (bean instanceof Session) {
                LifecycleCallback prePassivate;
                Session session = (Session)bean;
                LifecycleCallback postActivate = (LifecycleCallback)this.getFirst(session.getPostActivate());
                if (postActivate == null) {
                    for (java.lang.reflect.Method method : classFinder.findAnnotatedMethods(PostActivate.class)) {
                        session.getPostActivate().add(new LifecycleCallback(method));
                    }
                }
                if ((prePassivate = (LifecycleCallback)this.getFirst(session.getPrePassivate())) == null) {
                    for (java.lang.reflect.Method method : classFinder.findAnnotatedMethods(PrePassivate.class)) {
                        session.getPrePassivate().add(new LifecycleCallback(method));
                    }
                }
                List initMethods = classFinder.findAnnotatedMethods(Init.class);
                for (java.lang.reflect.Method method : initMethods) {
                    InitMethod initMethod = new InitMethod(method);
                    Init init = method.getAnnotation(Init.class);
                    if (init.value() != null && !init.value().equals("")) {
                        initMethod.setCreateMethod(init.value());
                    }
                    session.getInitMethod().add(initMethod);
                }
                List removeMethods = classFinder.findAnnotatedMethods(Remove.class);
                HashMap<NamedMethod, RemoveMethod> declaredRemoveMethods = new HashMap<NamedMethod, RemoveMethod>();
                for (RemoveMethod removeMethod : session.getRemoveMethod()) {
                    declaredRemoveMethods.put(removeMethod.getBeanMethod(), removeMethod);
                }
                for (java.lang.reflect.Method method : removeMethods) {
                    Remove remove;
                    RemoveMethod removeMethod = new RemoveMethod(method, (remove = method.getAnnotation(Remove.class)).retainIfException());
                    RemoveMethod declaredRemoveMethod = (RemoveMethod)declaredRemoveMethods.get(removeMethod.getBeanMethod());
                    if (declaredRemoveMethod == null) {
                        session.getRemoveMethod().add(removeMethod);
                        continue;
                    }
                    if (declaredRemoveMethod.isExplicitlySet()) continue;
                    declaredRemoveMethod.setRetainIfException(remove.retainIfException());
                }
            }
        }

        private void buildAnnotatedRefs(JndiConsumer consumer, ClassFinder classFinder, ClassLoader classLoader) throws OpenEJBException {
            Member member;
            PersistenceContext pCtx;
            PersistenceUnit pUnit;
            Member member2;
            HandlerChain handlerChain;
            WebServiceRef webserviceref;
            Member member3;
            Resource resource;
            Member member4;
            EJB ejb;
            ArrayList<EJB> ejbList = new ArrayList<EJB>();
            for (Class clazz : classFinder.findAnnotatedClasses(EJBs.class)) {
                EJBs ejbs = clazz.getAnnotation(EJBs.class);
                ejbList.addAll(Arrays.asList(ejbs.value()));
            }
            for (Class clazz : classFinder.findAnnotatedClasses(EJB.class)) {
                EJB e = clazz.getAnnotation(EJB.class);
                ejbList.add(e);
            }
            for (EJB ejb2 : ejbList) {
                this.buildEjbRef(consumer, ejb2, null);
            }
            for (Field field : classFinder.findAnnotatedFields(EJB.class)) {
                ejb = field.getAnnotation(EJB.class);
                member4 = new FieldMember(field);
                this.buildEjbRef(consumer, ejb, member4);
            }
            for (java.lang.reflect.Method method : classFinder.findAnnotatedMethods(EJB.class)) {
                ejb = method.getAnnotation(EJB.class);
                member4 = new MethodMember(method);
                this.buildEjbRef(consumer, ejb, member4);
            }
            ArrayList<Resource> resourceList = new ArrayList<Resource>();
            for (Class clazz : classFinder.findAnnotatedClasses(Resources.class)) {
                Resources resources = clazz.getAnnotation(Resources.class);
                resourceList.addAll(Arrays.asList(resources.value()));
            }
            for (Class clazz : classFinder.findAnnotatedClasses(Resource.class)) {
                resource = clazz.getAnnotation(Resource.class);
                resourceList.add(resource);
            }
            for (Resource resource2 : resourceList) {
                this.buildResource(consumer, resource2, null);
            }
            for (Field field : classFinder.findAnnotatedFields(Resource.class)) {
                resource = field.getAnnotation(Resource.class);
                member3 = new FieldMember(field);
                this.buildResource(consumer, resource, member3);
            }
            for (java.lang.reflect.Method method : classFinder.findAnnotatedMethods(Resource.class)) {
                resource = method.getAnnotation(Resource.class);
                member3 = new MethodMember(method);
                this.buildResource(consumer, resource, member3);
            }
            ArrayList<WebServiceRef> webservicerefList = new ArrayList<WebServiceRef>();
            for (Class clazz : classFinder.findAnnotatedClasses(WebServiceRefs.class)) {
                WebServiceRefs webServiceRefs = clazz.getAnnotation(WebServiceRefs.class);
                webservicerefList.addAll(Arrays.asList(webServiceRefs.value()));
            }
            for (Class clazz : classFinder.findAnnotatedClasses(WebServiceRef.class)) {
                WebServiceRef webServiceRef = clazz.getAnnotation(WebServiceRef.class);
                webservicerefList.add(webServiceRef);
            }
            for (WebServiceRef webserviceref2 : webservicerefList) {
                this.buildWebServiceRef(consumer, webserviceref2, null, null, classLoader);
            }
            for (Field field : classFinder.findAnnotatedFields(WebServiceRef.class)) {
                webserviceref = field.getAnnotation(WebServiceRef.class);
                handlerChain = field.getAnnotation(HandlerChain.class);
                member2 = new FieldMember(field);
                this.buildWebServiceRef(consumer, webserviceref, handlerChain, member2, classLoader);
            }
            for (java.lang.reflect.Method method : classFinder.findAnnotatedMethods(WebServiceRef.class)) {
                webserviceref = method.getAnnotation(WebServiceRef.class);
                handlerChain = method.getAnnotation(HandlerChain.class);
                member2 = new MethodMember(method);
                this.buildWebServiceRef(consumer, webserviceref, handlerChain, member2, classLoader);
            }
            ArrayList<PersistenceUnit> persistenceUnitList = new ArrayList<PersistenceUnit>();
            for (Class clazz : classFinder.findAnnotatedClasses(PersistenceUnits.class)) {
                PersistenceUnits persistenceUnits = clazz.getAnnotation(PersistenceUnits.class);
                persistenceUnitList.addAll(Arrays.asList(persistenceUnits.value()));
            }
            for (Class clazz : classFinder.findAnnotatedClasses(PersistenceUnit.class)) {
                PersistenceUnit persistenceUnit = clazz.getAnnotation(PersistenceUnit.class);
                persistenceUnitList.add(persistenceUnit);
            }
            for (PersistenceUnit pUnit2 : persistenceUnitList) {
                this.buildPersistenceUnit(consumer, pUnit2, null);
            }
            for (Field field : classFinder.findAnnotatedFields(PersistenceUnit.class)) {
                pUnit = field.getAnnotation(PersistenceUnit.class);
                member2 = new FieldMember(field);
                this.buildPersistenceUnit(consumer, pUnit, member2);
            }
            for (java.lang.reflect.Method method : classFinder.findAnnotatedMethods(PersistenceUnit.class)) {
                pUnit = method.getAnnotation(PersistenceUnit.class);
                member2 = new MethodMember(method);
                this.buildPersistenceUnit(consumer, pUnit, member2);
            }
            PersistenceContextAnnFactory pcFactory = new PersistenceContextAnnFactory();
            ArrayList<PersistenceContext> persistenceContextList = new ArrayList<PersistenceContext>();
            for (Class clazz : classFinder.findAnnotatedClasses(PersistenceContexts.class)) {
                PersistenceContexts persistenceContexts = clazz.getAnnotation(PersistenceContexts.class);
                persistenceContextList.addAll(Arrays.asList(persistenceContexts.value()));
                pcFactory.addAnnotations(clazz);
            }
            for (Class clazz : classFinder.findAnnotatedClasses(PersistenceContext.class)) {
                PersistenceContext persistenceContext = clazz.getAnnotation(PersistenceContext.class);
                persistenceContextList.add(persistenceContext);
                pcFactory.addAnnotations(clazz);
            }
            for (PersistenceContext pCtx2 : persistenceContextList) {
                this.buildPersistenceContext(consumer, pcFactory.create(pCtx2, null), null);
            }
            for (Field field : classFinder.findAnnotatedFields(PersistenceContext.class)) {
                pCtx = field.getAnnotation(PersistenceContext.class);
                member = new FieldMember(field);
                this.buildPersistenceContext(consumer, pcFactory.create(pCtx, member), member);
            }
            for (java.lang.reflect.Method method : classFinder.findAnnotatedMethods(PersistenceContext.class)) {
                pCtx = method.getAnnotation(PersistenceContext.class);
                member = new MethodMember(method);
                this.buildPersistenceContext(consumer, pcFactory.create(pCtx, member), member);
            }
        }

        private void buildEjbRef(JndiConsumer consumer, EJB ejb, Member member) {
            String ejbName;
            Class interfce;
            String name = consumer.getJndiConsumerName();
            if (member == null) {
                boolean shouldReturn = false;
                if (ejb.name().equals("")) {
                    this.fail(name, "ejbAnnotation.onClassWithNoName", new Object[0]);
                    shouldReturn = true;
                }
                if (ejb.beanInterface().equals(Object.class)) {
                    this.fail(name, "ejbAnnotation.onClassWithNoBeanInterface", new Object[0]);
                    shouldReturn = true;
                }
                if (shouldReturn) {
                    return;
                }
            }
            EjbRef ejbRef = new EjbRef();
            ejbRef.setRefType(EjbReference.Type.UNKNOWN);
            String refName = ejb.name();
            if (refName.equals("")) {
                refName = member == null ? null : member.getDeclaringClass().getName() + "/" + member.getName();
            }
            ejbRef.setEjbRefName(refName);
            if (member != null) {
                InjectionTarget target = new InjectionTarget();
                target.setInjectionTargetClass(member.getDeclaringClass().getName());
                target.setInjectionTargetName(member.getName());
                ejbRef.getInjectionTarget().add(target);
            }
            if ((interfce = ejb.beanInterface()).equals(Object.class)) {
                Class clazz = interfce = member == null ? null : member.getType();
            }
            if (interfce != null && !this.isValidEjbInterface(name, interfce, ejbRef.getName())) {
                return;
            }
            if (interfce != null && !interfce.equals(Object.class)) {
                java.lang.reflect.Method[] methods;
                if (EJBHome.class.isAssignableFrom(interfce)) {
                    ejbRef.setHome(interfce.getName());
                    for (java.lang.reflect.Method method : methods = interfce.getMethods()) {
                        if (!method.getName().startsWith("create")) continue;
                        ejbRef.setRemote(method.getReturnType().getName());
                        break;
                    }
                    ejbRef.setRefType(EjbReference.Type.REMOTE);
                } else if (EJBLocalHome.class.isAssignableFrom(interfce)) {
                    ejbRef.setHome(interfce.getName());
                    for (java.lang.reflect.Method method : methods = interfce.getMethods()) {
                        if (!method.getName().startsWith("create")) continue;
                        ejbRef.setRemote(method.getReturnType().getName());
                        break;
                    }
                    ejbRef.setRefType(EjbReference.Type.LOCAL);
                } else {
                    ejbRef.setRemote(interfce.getName());
                    if (interfce.getAnnotation(Local.class) != null) {
                        ejbRef.setRefType(EjbReference.Type.LOCAL);
                    } else if (interfce.getAnnotation(Remote.class) != null) {
                        ejbRef.setRefType(EjbReference.Type.REMOTE);
                    }
                }
            }
            if ((ejbName = ejb.beanName()).equals("")) {
                ejbName = null;
            }
            ejbRef.setEjbLink(ejbName);
            String mappedName = ejb.mappedName();
            if (mappedName.equals("")) {
                mappedName = null;
            }
            ejbRef.setMappedName(mappedName);
            Map remoteRefs = consumer.getEjbRefMap();
            if (remoteRefs.containsKey(ejbRef.getName())) {
                EjbRef ref = (EjbRef)remoteRefs.get(ejbRef.getName());
                if (ref.getRemote() == null) {
                    ref.setRemote(ejbRef.getRemote());
                }
                if (ref.getHome() == null) {
                    ref.setHome(ejbRef.getHome());
                }
                if (ref.getMappedName() == null) {
                    ref.setMappedName(ejbRef.getMappedName());
                }
                ref.getInjectionTarget().addAll(ejbRef.getInjectionTarget());
                return;
            }
            Map localRefs = consumer.getEjbLocalRefMap();
            if (localRefs.containsKey(ejbRef.getName())) {
                EjbLocalRef ejbLocalRef = new EjbLocalRef((EjbReference)ejbRef);
                EjbLocalRef ref = (EjbLocalRef)localRefs.get(ejbLocalRef.getName());
                if (ref.getLocal() == null) {
                    ref.setLocal(ejbLocalRef.getLocal());
                }
                if (ref.getLocalHome() == null) {
                    ref.setLocalHome(ejbLocalRef.getLocalHome());
                }
                if (ref.getMappedName() == null) {
                    ref.setMappedName(ejbLocalRef.getMappedName());
                }
                ref.getInjectionTarget().addAll(ejbLocalRef.getInjectionTarget());
                return;
            }
            switch (ejbRef.getRefType()) {
                case UNKNOWN: 
                case REMOTE: {
                    consumer.getEjbRef().add(ejbRef);
                    break;
                }
                case LOCAL: {
                    consumer.getEjbLocalRef().add(new EjbLocalRef((EjbReference)ejbRef));
                }
            }
        }

        private boolean isValidEjbInterface(String b, Class clazz, String refName) {
            if (!clazz.isInterface()) {
                DeploymentModule module = AnnotationDeployer.getModule();
                if (module instanceof EjbModule) {
                    HashSet<String> beanClasses = new HashSet<String>();
                    EjbModule ejbModule = (EjbModule)module;
                    for (EnterpriseBean bean : ejbModule.getEjbJar().getEnterpriseBeans()) {
                        beanClasses.add(bean.getEjbClass());
                    }
                    if (beanClasses.contains(clazz.getName())) {
                        this.fail(b, "ann.ejb.beanClass", clazz.getName(), refName);
                    } else {
                        this.fail(b, "ann.ejb.notInterface", clazz.getName(), refName);
                    }
                } else {
                    this.fail(b, "ann.ejb.notInterface", clazz.getName(), refName);
                }
                return false;
            }
            if (EJBObject.class.isAssignableFrom(clazz)) {
                this.fail(b, "ann.ejb.ejbObject", clazz.getName(), refName);
                return false;
            }
            if (EJBLocalObject.class.isAssignableFrom(clazz)) {
                this.fail(b, "ann.ejb.ejbLocalObject", clazz.getName(), refName);
                return false;
            }
            return true;
        }

        private void fail(String component, String key, Object ... details) {
            AnnotationDeployer.getValidationContext().fail(component, key, details);
        }

        private void buildResource(JndiConsumer consumer, Resource resource, Member member) {
            JndiReference reference;
            String refName = resource.name();
            if (refName.equals("")) {
                String string = refName = member == null ? null : member.getDeclaringClass().getName() + "/" + member.getName();
            }
            if (member == null) {
                boolean shouldReturn = false;
                if (resource.name().equals("")) {
                    this.fail(consumer.getJndiConsumerName(), "resourceAnnotation.onClassWithNoName", new Object[0]);
                    shouldReturn = true;
                }
                if (resource.type().equals(Object.class)) {
                    this.fail(consumer.getJndiConsumerName(), "resourceAnnotation.onClassWithNoType", new Object[0]);
                    shouldReturn = true;
                }
                if (shouldReturn) {
                    return;
                }
            }
            if ((reference = (JndiReference)consumer.getEnvEntryMap().get(refName)) == null) {
                Object type;
                if (member != null) {
                    type = member.getType();
                    boolean shouldReturn = false;
                    if (EntityManager.class.isAssignableFrom((Class<?>)type)) {
                        this.fail(consumer.getJndiConsumerName(), "resourceRef.onEntityManager", refName);
                        shouldReturn = true;
                    } else if (EntityManagerFactory.class.isAssignableFrom((Class<?>)type)) {
                        this.fail(consumer.getJndiConsumerName(), "resourceRef.onEntityManagerFactory", refName);
                        shouldReturn = true;
                    }
                    if (shouldReturn) {
                        return;
                    }
                }
                if (knownResourceEnvTypes.contains(type = resource.type() != Object.class ? resource.type().getName() : member.getType().getName())) {
                    ResourceEnvRef resourceEnvRef = (ResourceEnvRef)consumer.getResourceEnvRefMap().get(refName);
                    if (resourceEnvRef == null) {
                        resourceEnvRef = new ResourceEnvRef();
                        resourceEnvRef.setName(refName);
                        consumer.getResourceEnvRef().add(resourceEnvRef);
                    }
                    if (resourceEnvRef.getResourceEnvRefType() == null || "".equals(resourceEnvRef.getResourceEnvRefType())) {
                        if (resource.type() != Object.class) {
                            resourceEnvRef.setResourceEnvRefType(resource.type().getName());
                        } else {
                            resourceEnvRef.setResourceEnvRefType(member.getType().getName());
                        }
                    }
                    reference = resourceEnvRef;
                } else if (!knownEnvironmentEntries.contains(type)) {
                    ResourceRef resourceRef = (ResourceRef)consumer.getResourceRefMap().get(refName);
                    if (resourceRef == null) {
                        resourceRef = new ResourceRef();
                        resourceRef.setName(refName);
                        consumer.getResourceRef().add(resourceRef);
                    }
                    if (resourceRef.getResAuth() == null) {
                        if (resource.authenticationType() == Resource.AuthenticationType.APPLICATION) {
                            resourceRef.setResAuth(ResAuth.APPLICATION);
                        } else {
                            resourceRef.setResAuth(ResAuth.CONTAINER);
                        }
                    }
                    if (resourceRef.getResType() == null || "".equals(resourceRef.getResType())) {
                        if (resource.type() != Object.class) {
                            resourceRef.setResType(resource.type().getName());
                        } else {
                            resourceRef.setResType(member.getType().getName());
                        }
                    }
                    if (resourceRef.getResSharingScope() == null) {
                        if (resource.shareable()) {
                            resourceRef.setResSharingScope(ResSharingScope.SHAREABLE);
                        } else {
                            resourceRef.setResSharingScope(ResSharingScope.UNSHAREABLE);
                        }
                    }
                    reference = resourceRef;
                }
            }
            if (reference == null) {
                return;
            }
            if (member != null) {
                InjectionTarget target = new InjectionTarget();
                target.setInjectionTargetClass(member.getDeclaringClass().getName());
                target.setInjectionTargetName(member.getName());
                reference.getInjectionTarget().add(target);
            }
            if (reference.getMappedName() == null && !resource.mappedName().equals("")) {
                reference.setMappedName(resource.mappedName());
            }
        }

        private void buildPersistenceUnit(JndiConsumer consumer, PersistenceUnit persistenceUnit, Member member) throws OpenEJBException {
            String refName = persistenceUnit.name();
            if (refName.equals("")) {
                String string = refName = member == null ? null : member.getDeclaringClass().getName() + "/" + member.getName();
            }
            if (refName == null && member == null) {
                this.fail(consumer.getJndiConsumerName(), "presistenceUnitAnnotation.onClassWithNoName", persistenceUnit.unitName());
                return;
            }
            PersistenceUnitRef persistenceUnitRef = (PersistenceUnitRef)consumer.getPersistenceUnitRefMap().get(refName);
            if (persistenceUnitRef == null) {
                persistenceUnitRef = new PersistenceUnitRef();
                persistenceUnitRef.setPersistenceUnitName(persistenceUnit.unitName());
                persistenceUnitRef.setPersistenceUnitRefName(refName);
                consumer.getPersistenceUnitRef().add(persistenceUnitRef);
            }
            if (member != null) {
                Class type = member.getType();
                if (EntityManager.class.isAssignableFrom(type)) {
                    ValidationContext validationContext = AnnotationDeployer.getValidationContext();
                    String jndiConsumerName = consumer.getJndiConsumerName();
                    String name = persistenceUnitRef.getName();
                    validationContext.fail(jndiConsumerName, "presistenceUnitAnnotation.onEntityManager", name);
                } else if (!EntityManagerFactory.class.isAssignableFrom(type)) {
                    this.fail(consumer.getJndiConsumerName(), "presistenceUnitAnnotation.onNonEntityManagerFactory", persistenceUnitRef.getName());
                } else {
                    InjectionTarget target = new InjectionTarget();
                    target.setInjectionTargetClass(member.getDeclaringClass().getName());
                    target.setInjectionTargetName(member.getName());
                    persistenceUnitRef.getInjectionTarget().add(target);
                }
            }
            if (persistenceUnitRef.getPersistenceUnitName() == null && !persistenceUnit.unitName().equals("")) {
                persistenceUnitRef.setPersistenceUnitName(persistenceUnit.unitName());
            }
        }

        private void buildPersistenceContext(JndiConsumer consumer, PersistenceContextAnn persistenceContext, Member member) throws OpenEJBException {
            String refName = persistenceContext.name();
            if (refName.equals("")) {
                String string = refName = member == null ? null : member.getDeclaringClass().getName() + "/" + member.getName();
            }
            if (refName == null && member == null) {
                this.fail(consumer.getJndiConsumerName(), "presistenceContextAnnotation.onClassWithNoName", persistenceContext.unitName());
                return;
            }
            PersistenceContextRef persistenceContextRef = (PersistenceContextRef)consumer.getPersistenceContextRefMap().get(refName);
            if (persistenceContextRef == null) {
                persistenceContextRef = new PersistenceContextRef();
                persistenceContextRef.setPersistenceUnitName(persistenceContext.unitName());
                persistenceContextRef.setPersistenceContextRefName(refName);
                if ("EXTENDED".equalsIgnoreCase(persistenceContext.type())) {
                    persistenceContextRef.setPersistenceContextType(PersistenceContextType.EXTENDED);
                } else {
                    persistenceContextRef.setPersistenceContextType(PersistenceContextType.TRANSACTION);
                }
                consumer.getPersistenceContextRef().add(persistenceContextRef);
            } else {
                if (persistenceContextRef.getPersistenceUnitName() == null || "".equals(persistenceContextRef.getPersistenceUnitName())) {
                    persistenceContextRef.setPersistenceUnitName(persistenceContext.unitName());
                }
                if (persistenceContextRef.getPersistenceContextType() == null || "".equals(persistenceContextRef.getPersistenceContextType())) {
                    if ("EXTENDED".equalsIgnoreCase(persistenceContext.type())) {
                        persistenceContextRef.setPersistenceContextType(PersistenceContextType.EXTENDED);
                    } else {
                        persistenceContextRef.setPersistenceContextType(PersistenceContextType.TRANSACTION);
                    }
                }
            }
            ArrayList<Property> persistenceProperties = persistenceContextRef.getPersistenceProperty();
            if (persistenceProperties == null) {
                persistenceProperties = new ArrayList<Property>();
                persistenceContextRef.setPersistenceProperty(persistenceProperties);
            }
            for (Map.Entry<String, String> persistenceProperty : persistenceContext.properties().entrySet()) {
                boolean flag = true;
                for (Property prpty : persistenceProperties) {
                    if (!prpty.getName().equals(persistenceProperty.getKey())) continue;
                    flag = false;
                    break;
                }
                if (!flag) continue;
                Property property = new Property();
                property.setName(persistenceProperty.getKey());
                property.setValue(persistenceProperty.getValue());
                persistenceProperties.add(property);
            }
            if (member != null) {
                Class type = member.getType();
                if (EntityManagerFactory.class.isAssignableFrom(type)) {
                    this.fail(consumer.getJndiConsumerName(), "presistenceContextAnnotation.onEntityManagerFactory", persistenceContextRef.getName());
                } else if (!EntityManager.class.isAssignableFrom(type)) {
                    this.fail(consumer.getJndiConsumerName(), "presistenceContextAnnotation.onNonEntityManager", persistenceContextRef.getName());
                } else {
                    InjectionTarget target = new InjectionTarget();
                    target.setInjectionTargetClass(member.getDeclaringClass().getName());
                    target.setInjectionTargetName(member.getName());
                    persistenceContextRef.getInjectionTarget().add(target);
                }
            }
        }

        private void buildWebServiceRef(JndiConsumer consumer, WebServiceRef webService, HandlerChain handlerChain, Member member, ClassLoader classLoader) throws OpenEJBException {
            String wsdlLocation;
            ServiceRef serviceRef;
            String refName = webService.name();
            if (refName.equals("")) {
                String string = refName = member == null ? null : member.getDeclaringClass().getName() + "/" + member.getName();
            }
            if ((serviceRef = (ServiceRef)consumer.getServiceRefMap().get(refName)) == null) {
                serviceRef = new ServiceRef();
                serviceRef.setServiceRefName(refName);
                consumer.getServiceRef().add(serviceRef);
            }
            if (member != null) {
                InjectionTarget target = new InjectionTarget();
                target.setInjectionTargetClass(member.getDeclaringClass().getName());
                target.setInjectionTargetName(member.getName());
                serviceRef.getInjectionTarget().add(target);
            }
            Class serviceInterface = null;
            if (serviceRef.getServiceInterface() == null && (serviceInterface = webService.type()).equals(Object.class)) {
                serviceInterface = member != null ? member.getType() : webService.value();
            }
            if (serviceInterface == null || !serviceInterface.isAssignableFrom(Service.class)) {
                serviceInterface = Service.class;
            }
            serviceRef.setServiceInterface(serviceInterface.getName());
            if (serviceRef.getServiceRefType() == null || "".equals(serviceRef.getServiceRefType())) {
                if (webService.type() != Object.class) {
                    serviceRef.setServiceRefType(webService.type().getName());
                } else {
                    serviceRef.setServiceRefType(member.getType().getName());
                }
            }
            Class<?> refType = null;
            try {
                refType = classLoader.loadClass(serviceRef.getType());
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (serviceRef.getMappedName() == null) {
                String mappedName = webService.mappedName();
                if (mappedName.equals("")) {
                    mappedName = null;
                }
                serviceRef.setMappedName(mappedName);
            }
            if (serviceRef.getWsdlFile() == null && !(wsdlLocation = webService.wsdlLocation()).equals("")) {
                serviceRef.setWsdlFile(wsdlLocation);
            }
            if (System.getProperty("duct tape") != null) {
                return;
            }
            if (serviceRef.getWsdlFile() == null && refType != null) {
                serviceRef.setWsdlFile(JaxWsUtils.getServiceWsdlLocation(refType, classLoader));
            }
            if (serviceRef.getWsdlFile() == null && serviceInterface != null) {
                serviceRef.setWsdlFile(JaxWsUtils.getServiceWsdlLocation(serviceInterface, classLoader));
            }
            if (serviceRef.getServiceQname() == null && refType != null) {
                serviceRef.setServiceQname(JaxWsUtils.getServiceQName(refType));
            }
            if (serviceRef.getServiceQname() == null && serviceInterface != null) {
                serviceRef.setServiceQname(JaxWsUtils.getServiceQName(serviceInterface));
            }
            if (serviceRef.getHandlerChains() == null && handlerChain != null) {
                try {
                    URL handlerFileURL = member.getDeclaringClass().getResource(handlerChain.file());
                    HandlerChains handlerChains = ReadDescriptors.readHandlerChains(handlerFileURL);
                    serviceRef.setHandlerChains(handlerChains);
                }
                catch (Throwable e) {
                    throw new OpenEJBException("Unable to load handler chain file: " + handlerChain.file(), e);
                }
            }
        }

        private void processWebServiceClientHandlers(JndiConsumer consumer, ClassLoader classLoader) throws OpenEJBException {
            if (System.getProperty("duct tape") != null) {
                return;
            }
            HashSet processedClasses = new HashSet();
            HashSet handlerClasses = new HashSet();
            do {
                handlerClasses.clear();
                for (ServiceRef serviceRef : consumer.getServiceRef()) {
                    HandlerChains chains = serviceRef.getAllHandlers();
                    if (chains == null) continue;
                    for (org.apache.openejb.jee.HandlerChain handlerChain : chains.getHandlerChain()) {
                        for (Handler handler : handlerChain.getHandler()) {
                            if (handler.getHandlerClass() == null) continue;
                            try {
                                Class<?> clazz = classLoader.loadClass(handler.getHandlerClass());
                                handlerClasses.add(clazz);
                            }
                            catch (ClassNotFoundException e) {
                                throw new OpenEJBException("Unable to load webservice handler class: " + handler.getHandlerClass(), e);
                            }
                        }
                    }
                }
                handlerClasses.removeAll(processedClasses);
                ClassFinder handlerClassFinder = this.createInheritedClassFinder(handlerClasses.toArray(new Class[handlerClasses.size()]));
                this.buildAnnotatedRefs(consumer, handlerClassFinder, classLoader);
                processedClasses.addAll(handlerClasses);
            } while (!handlerClasses.isEmpty());
        }

        private List<String> getDeclaredClassPermissions(AssemblyDescriptor assemblyDescriptor, String ejbName) {
            List permissions = assemblyDescriptor.getMethodPermission();
            ArrayList<String> classPermissions = new ArrayList<String>();
            for (MethodPermission permission : permissions) {
                for (Method method : permission.getMethod()) {
                    if (!method.getEjbName().equals(ejbName) || !"*".equals(method.getMethodName())) continue;
                    String className = method.getClassName();
                    if (className == null) {
                        className = "*";
                    }
                    classPermissions.add(className);
                }
            }
            return classPermissions;
        }

        private <A extends Annotation> void checkAttributes(AnnotationHandler<A> handler, String ejbName, EjbModule ejbModule, ClassFinder classFinder, String messageKey) {
            Map<String, List<MethodAttribute>> existingDeclarations = handler.getExistingDeclarations();
            int xml = 0;
            for (List<MethodAttribute> methodAttributes : existingDeclarations.values()) {
                xml += methodAttributes.size();
            }
            if (xml > 0) {
                ejbModule.getValidation().warn(ejbName, "xml." + messageKey, xml);
            }
            int ann = classFinder.findAnnotatedClasses(handler.getAnnotationClass()).size();
            if ((ann += classFinder.findAnnotatedMethods(handler.getAnnotationClass()).size()) > 0) {
                ejbModule.getValidation().warn(ejbName, "ann." + messageKey, ann);
            }
        }

        private <A extends Annotation> void processAttributes(AnnotationHandler<A> handler, Class<?> clazz, ClassFinder classFinder) {
            Map<String, List<MethodAttribute>> existingDeclarations = handler.getExistingDeclarations();
            Class<A> annotationClass = handler.getAnnotationClass();
            if (!this.hasMethodAttribute("*", null, existingDeclarations)) {
                for (Class<?> type : this.ancestors(clazz)) {
                    A attribute;
                    if (this.hasMethodAttribute("*", type, existingDeclarations) || (attribute = type.getAnnotation(annotationClass)) == null) continue;
                    handler.addClassLevelDeclaration(attribute, type);
                }
            }
            List methods = classFinder.findAnnotatedMethods(annotationClass);
            for (java.lang.reflect.Method method : methods) {
                A attribute = method.getAnnotation(annotationClass);
                if (!existingDeclarations.containsKey(method.getName())) {
                    handler.addMethodLevelDeclaration(attribute, method);
                    continue;
                }
                List<MethodAttribute> list = existingDeclarations.get(method.getName());
                block2: for (MethodAttribute mtx : list) {
                    MethodParams methodParams = mtx.getMethodParams();
                    if (methodParams == null) {
                        handler.addMethodLevelDeclaration(attribute, method);
                        continue;
                    }
                    List params1 = methodParams.getMethodParam();
                    String[] params2 = this.asStrings(method.getParameterTypes());
                    if (params1.size() != params2.length) {
                        handler.addMethodLevelDeclaration(attribute, method);
                        continue;
                    }
                    for (int i = 0; i < params1.size(); ++i) {
                        String b;
                        String a = (String)params1.get(i);
                        if (a.equals(b = params2[i])) continue;
                        handler.addMethodLevelDeclaration(attribute, method);
                        continue block2;
                    }
                }
            }
        }

        private boolean hasMethodAttribute(String methodName, Class clazz, Map<String, List<MethodAttribute>> map) {
            return this.getMethodAttribute(methodName, clazz, map) != null;
        }

        private MethodAttribute getMethodAttribute(String methodName, Class clazz, Map<String, List<MethodAttribute>> map) {
            List<MethodAttribute> methodAttributes = map.get(methodName);
            if (methodAttributes == null) {
                return null;
            }
            Iterator<MethodAttribute> i$ = methodAttributes.iterator();
            while (i$.hasNext()) {
                MethodAttribute methodAttribute;
                String className = clazz != null ? clazz.getName() : null + "";
                if (!className.equals((methodAttribute = i$.next()).getClassName() + "")) continue;
                return methodAttribute;
            }
            return null;
        }

        private <A extends Annotation> A getInheritableAnnotation(Class clazz, Class<A> annotationClass) {
            if (clazz == null || clazz.equals(Object.class)) {
                return null;
            }
            A annotation = clazz.getAnnotation(annotationClass);
            if (annotation != null) {
                return annotation;
            }
            return this.getInheritableAnnotation(clazz.getSuperclass(), annotationClass);
        }

        private List<Class<?>> ancestors(Class clazz) {
            ArrayList ancestors = new ArrayList();
            while (clazz != null && !clazz.equals(Object.class)) {
                ancestors.add(clazz);
                clazz = clazz.getSuperclass();
            }
            return ancestors;
        }

        private ClassFinder createInheritedClassFinder(Class<?> ... classes) {
            ArrayList parents = new ArrayList();
            for (Class<?> clazz : classes) {
                parents.addAll(this.ancestors(clazz));
            }
            return new ClassFinder(parents);
        }

        private List<Class<?>> copy(List<Class<?>> classes) {
            return new ArrayList(classes);
        }

        private String[] asStrings(Class[] types) {
            ArrayList<String> names = new ArrayList<String>();
            for (Class clazz : types) {
                names.add(clazz.getName());
            }
            return names.toArray(new String[names.size()]);
        }

        private <T> T getFirst(List<T> list) {
            if (list.size() > 0) {
                return list.get(0);
            }
            return null;
        }

        private boolean validateRemoteInterface(Class interfce, ValidationContext validation, String ejbName) {
            return this.isValidInterface(interfce, validation, ejbName, "Remote");
        }

        private boolean validateLocalInterface(Class interfce, ValidationContext validation, String ejbName) {
            return this.isValidInterface(interfce, validation, ejbName, "Local");
        }

        private boolean isValidInterface(Class interfce, ValidationContext validation, String ejbName, String annotationName) {
            if (!interfce.isInterface()) {
                validation.fail(ejbName, "ann.notAnInterface", annotationName, interfce.getName());
                return false;
            }
            if (EJBHome.class.isAssignableFrom(interfce)) {
                validation.fail(ejbName, "ann.remoteOrLocal.ejbHome", annotationName, interfce.getName());
                return false;
            }
            if (EJBObject.class.isAssignableFrom(interfce)) {
                validation.fail(ejbName, "ann.remoteOrLocal.ejbObject", annotationName, interfce.getName());
                return false;
            }
            if (EJBLocalHome.class.isAssignableFrom(interfce)) {
                validation.fail(ejbName, "ann.remoteOrLocal.ejbLocalHome", annotationName, interfce.getName());
                return false;
            }
            if (EJBLocalObject.class.isAssignableFrom(interfce)) {
                validation.fail(ejbName, "ann.remoteOrLocal.ejbLocalObject", annotationName, interfce.getName());
                return false;
            }
            return true;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class ConcurrencyAttributeHandler
        implements AnnotationHandler<Lock> {
            private final AssemblyDescriptor assemblyDescriptor;
            private final String ejbName;

            public ConcurrencyAttributeHandler(AssemblyDescriptor assemblyDescriptor, String ejbName) {
                this.assemblyDescriptor = assemblyDescriptor;
                this.ejbName = ejbName;
            }

            @Override
            public Map<String, List<MethodAttribute>> getExistingDeclarations() {
                return this.assemblyDescriptor.getMethodConcurrencyMap(this.ejbName);
            }

            @Override
            public void addClassLevelDeclaration(Lock attribute, Class type) {
                ContainerConcurrency ctx = new ContainerConcurrency(this.cast(attribute.value()), type.getName(), this.ejbName, "*");
                this.assemblyDescriptor.getContainerConcurrency().add(ctx);
            }

            @Override
            public void addMethodLevelDeclaration(Lock attribute, java.lang.reflect.Method method) {
                ContainerConcurrency ctx = new ContainerConcurrency(this.cast(attribute.value()), this.ejbName, method);
                this.assemblyDescriptor.getContainerConcurrency().add(ctx);
            }

            @Override
            public Class<Lock> getAnnotationClass() {
                return Lock.class;
            }

            private ConcurrencyAttribute cast(LockType lockType) {
                return ConcurrencyAttribute.valueOf((String)lockType.toString());
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class TransactionAttributeHandler
        implements AnnotationHandler<TransactionAttribute> {
            private final AssemblyDescriptor assemblyDescriptor;
            private final String ejbName;

            public TransactionAttributeHandler(AssemblyDescriptor assemblyDescriptor, String ejbName) {
                this.assemblyDescriptor = assemblyDescriptor;
                this.ejbName = ejbName;
            }

            @Override
            public Map<String, List<MethodAttribute>> getExistingDeclarations() {
                return this.assemblyDescriptor.getMethodTransactionMap(this.ejbName);
            }

            @Override
            public void addClassLevelDeclaration(TransactionAttribute attribute, Class type) {
                ContainerTransaction ctx = new ContainerTransaction(this.cast(attribute.value()), type.getName(), this.ejbName, "*");
                this.assemblyDescriptor.getContainerTransaction().add(ctx);
            }

            @Override
            public void addMethodLevelDeclaration(TransactionAttribute attribute, java.lang.reflect.Method method) {
                ContainerTransaction ctx = new ContainerTransaction(this.cast(attribute.value()), this.ejbName, method);
                this.assemblyDescriptor.getContainerTransaction().add(ctx);
            }

            @Override
            public Class<TransactionAttribute> getAnnotationClass() {
                return TransactionAttribute.class;
            }

            private TransAttribute cast(TransactionAttributeType transactionAttributeType) {
                return TransAttribute.valueOf((String)transactionAttributeType.toString());
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface AnnotationHandler<A extends Annotation> {
            public Class<A> getAnnotationClass();

            public Map<String, List<MethodAttribute>> getExistingDeclarations();

            public void addClassLevelDeclaration(A var1, Class var2);

            public void addMethodLevelDeclaration(A var1, java.lang.reflect.Method var2);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class BusinessInterfaces {
            private Set<Class> local = new LinkedHashSet<Class>();
            private Set<Class> remote = new LinkedHashSet<Class>();
            private Set<Class> unspecified = new LinkedHashSet<Class>();

            private BusinessInterfaces() {
            }

            public void addLocals(Collection<String> names, ClassLoader loader) {
                this.add(loader, names, this.local);
            }

            public void addRemotes(Collection<String> names, ClassLoader loader) {
                this.add(loader, names, this.remote);
            }

            private void add(ClassLoader loader, Collection<String> names, Set<Class> classes) {
                for (String className : names) {
                    try {
                        classes.add(loader.loadClass(className));
                    }
                    catch (Throwable t) {}
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DiscoverAnnotatedBeans
    implements DynamicDeployer {
        public static final Set<String> knownResourceEnvTypes = new TreeSet<String>(Arrays.asList("javax.ejb.SessionContext", "javax.ejb.EntityContext", "javax.ejb.MessageDrivenContext", "javax.transaction.UserTransaction", "javax.jms.Queue", "javax.jms.Topic", "javax.xml.ws.WebServiceContext", "javax.ejb.TimerService"));
        public static final Set<String> knownEnvironmentEntries = new TreeSet<String>(Arrays.asList("boolean", "java.lang.Boolean", "char", "java.lang.Character", "byte", "java.lang.Byte", "short", "java.lang.Short", "int", "java.lang.Integer", "long", "java.lang.Long", "float", "java.lang.Float", "double", "java.lang.Double", "java.lang.String"));

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AppModule deploy(AppModule appModule) throws OpenEJBException {
            for (EjbModule ejbModule : appModule.getEjbModules()) {
                AnnotationDeployer.setModule(ejbModule);
                try {
                    this.deploy(ejbModule);
                }
                finally {
                    AnnotationDeployer.removeModule();
                }
            }
            for (ClientModule clientModule : appModule.getClientModules()) {
                AnnotationDeployer.setModule(clientModule);
                try {
                    this.deploy(clientModule);
                }
                finally {
                    AnnotationDeployer.removeModule();
                }
            }
            for (ConnectorModule connectorModule : appModule.getResourceModules()) {
                AnnotationDeployer.setModule(connectorModule);
                try {
                    this.deploy(connectorModule);
                }
                finally {
                    AnnotationDeployer.removeModule();
                }
            }
            for (WebModule webModule : appModule.getWebModules()) {
                AnnotationDeployer.setModule(webModule);
                try {
                    this.deploy(webModule);
                }
                finally {
                    AnnotationDeployer.removeModule();
                }
            }
            return appModule;
        }

        public ClientModule deploy(ClientModule clientModule) throws OpenEJBException {
            if (clientModule.getApplicationClient() == null) {
                clientModule.setApplicationClient(new ApplicationClient());
            }
            if (clientModule.getFinder() == null && clientModule.getAltDDs().containsKey("application-client.xml") && clientModule.getApplicationClient() != null && clientModule.getApplicationClient().isMetadataComplete().booleanValue()) {
                return clientModule;
            }
            ClassFinder finder = clientModule.getFinder();
            if (finder == null) {
                try {
                    if (clientModule.getJarLocation() != null) {
                        String location = clientModule.getJarLocation();
                        File file = new File(location);
                        URL url = file.exists() ? file.toURL() : new URL(location);
                        finder = new ClassFinder(clientModule.getClassLoader(), url);
                    } else {
                        finder = new ClassFinder(clientModule.getClassLoader());
                    }
                }
                catch (MalformedURLException e) {
                    startupLogger.warning("startup.scrapeFailedForClientModule.url", clientModule.getJarLocation());
                    return clientModule;
                }
                catch (Exception e) {
                    startupLogger.warning("startup.scrapeFailedForClientModule", e, clientModule.getJarLocation());
                    return clientModule;
                }
            }
            for (Class clazz : finder.findAnnotatedClasses(LocalClient.class)) {
                clientModule.getLocalClients().add(clazz.getName());
            }
            for (Class clazz : finder.findAnnotatedClasses(RemoteClient.class)) {
                clientModule.getRemoteClients().add(clazz.getName());
            }
            if (clientModule.getApplicationClient() == null && (clientModule.getRemoteClients().size() > 0 || clientModule.getLocalClients().size() > 0)) {
                clientModule.setApplicationClient(new ApplicationClient());
            }
            return clientModule;
        }

        public ConnectorModule deploy(ConnectorModule connectorModule) throws OpenEJBException {
            return connectorModule;
        }

        public WebModule deploy(WebModule webModule) throws OpenEJBException {
            ClassFinder finder;
            WebApp webApp = webModule.getWebApp();
            if (webApp != null && webApp.isMetadataComplete().booleanValue()) {
                return webModule;
            }
            try {
                File file = new File(webModule.getJarLocation());
                URL[] urls = DeploymentLoader.getWebappUrls(file);
                ClassLoader webClassLoader = webModule.getClassLoader();
                finder = new ClassFinder(webClassLoader, Arrays.asList(urls));
                ClassFinder finder2 = new ClassFinder(webClassLoader);
                webModule.setFinder(finder);
            }
            catch (Exception e) {
                startupLogger.warning("Unable to scrape for @WebService or @WebServiceProvider annotations. ClassFinder failed.", e);
                return webModule;
            }
            if (webApp == null) {
                webApp = new WebApp();
                webModule.setWebApp(webApp);
            }
            ArrayList<String> existingServlets = new ArrayList<String>();
            for (Servlet servlet : webApp.getServlet()) {
                existingServlets.add(servlet.getServletClass());
            }
            ArrayList classes = new ArrayList();
            classes.addAll(finder.findAnnotatedClasses(WebService.class));
            classes.addAll(finder.findAnnotatedClasses(WebServiceProvider.class));
            for (Class webServiceClass : classes) {
                int modifiers;
                if (webServiceClass.isAnnotationPresent(Singleton.class) || webServiceClass.isAnnotationPresent(Stateless.class) || !Modifier.isPublic(modifiers = webServiceClass.getModifiers()) || Modifier.isFinal(modifiers) || Modifier.isAbstract(modifiers) || existingServlets.contains(webServiceClass.getName())) continue;
                Servlet servlet = new Servlet();
                servlet.setServletName(webServiceClass.getName());
                servlet.setServletClass(webServiceClass.getName());
                webApp.getServlet().add(servlet);
            }
            return webModule;
        }

        public EjbModule deploy(EjbModule ejbModule) throws OpenEJBException {
            SessionBean sessionBean;
            EnterpriseBean enterpriseBean;
            String ejbName;
            ClassFinder finder;
            if (ejbModule.getEjbJar() != null && ejbModule.getEjbJar().isMetadataComplete().booleanValue()) {
                return ejbModule;
            }
            if (ejbModule.getJarLocation() != null) {
                try {
                    String location = ejbModule.getJarLocation();
                    File file = new File(location);
                    URL url = file.exists() ? file.toURL() : new URL(location);
                    finder = new ClassFinder(ejbModule.getClassLoader(), url);
                }
                catch (MalformedURLException e) {
                    startupLogger.warning("startup.scrapeFailedForModule", ejbModule.getJarLocation());
                    return ejbModule;
                }
            }
            try {
                finder = new ClassFinder(ejbModule.getClassLoader());
            }
            catch (Exception e) {
                startupLogger.warning("Unable to scrape for @Stateful, @Stateless, @Singleton or @MessageDriven annotations. ClassFinder failed.", e);
                return ejbModule;
            }
            EjbJar ejbJar = ejbModule.getEjbJar();
            for (Class beanClass : finder.findAnnotatedClasses(Singleton.class)) {
                Singleton singleton;
                if (!this.isValidEjbAnnotationUsage(Singleton.class, beanClass, ejbName = this.getEjbName(singleton = beanClass.getAnnotation(Singleton.class), beanClass), ejbModule)) continue;
                enterpriseBean = ejbJar.getEnterpriseBean(ejbName);
                if (enterpriseBean == null) {
                    enterpriseBean = new SingletonBean(ejbName, beanClass.getName());
                    ejbJar.addEnterpriseBean(enterpriseBean);
                }
                if (enterpriseBean.getEjbClass() == null) {
                    enterpriseBean.setEjbClass(beanClass.getName());
                }
                if (!(enterpriseBean instanceof SessionBean)) continue;
                sessionBean = (SessionBean)enterpriseBean;
                sessionBean.setSessionType(SessionType.SINGLETON);
            }
            for (Class beanClass : finder.findAnnotatedClasses(Stateless.class)) {
                Stateless stateless;
                if (!this.isValidEjbAnnotationUsage(Stateless.class, beanClass, ejbName = this.getEjbName(stateless = beanClass.getAnnotation(Stateless.class), beanClass), ejbModule)) continue;
                enterpriseBean = ejbJar.getEnterpriseBean(ejbName);
                if (enterpriseBean == null) {
                    enterpriseBean = new StatelessBean(ejbName, beanClass.getName());
                    ejbJar.addEnterpriseBean(enterpriseBean);
                }
                if (enterpriseBean.getEjbClass() == null) {
                    enterpriseBean.setEjbClass(beanClass.getName());
                }
                if (!(enterpriseBean instanceof SessionBean)) continue;
                sessionBean = (SessionBean)enterpriseBean;
                sessionBean.setSessionType(SessionType.STATELESS);
                if (stateless.mappedName() == null) continue;
                sessionBean.setMappedName(stateless.mappedName());
            }
            for (Class beanClass : finder.findAnnotatedClasses(Stateful.class)) {
                Stateful stateful;
                if (!this.isValidEjbAnnotationUsage(Stateful.class, beanClass, ejbName = this.getEjbName(stateful = beanClass.getAnnotation(Stateful.class), beanClass), ejbModule)) continue;
                enterpriseBean = ejbJar.getEnterpriseBean(ejbName);
                if (enterpriseBean == null) {
                    enterpriseBean = new StatefulBean(ejbName, beanClass.getName());
                    ejbJar.addEnterpriseBean(enterpriseBean);
                }
                if (enterpriseBean.getEjbClass() == null) {
                    enterpriseBean.setEjbClass(beanClass.getName());
                }
                if (!(enterpriseBean instanceof SessionBean)) continue;
                sessionBean = (SessionBean)enterpriseBean;
                sessionBean.setSessionType(SessionType.STATEFUL);
                if (stateful.mappedName() == null) continue;
                sessionBean.setMappedName(stateful.mappedName());
            }
            List classes = finder.findAnnotatedClasses(MessageDriven.class);
            for (Class beanClass : classes) {
                MessageDriven mdb;
                String ejbName2;
                if (!this.isValidEjbAnnotationUsage(MessageDriven.class, beanClass, ejbName2 = this.getEjbName(mdb = beanClass.getAnnotation(MessageDriven.class), beanClass), ejbModule)) continue;
                MessageDrivenBean messageBean = (MessageDrivenBean)ejbJar.getEnterpriseBean(ejbName2);
                if (messageBean == null) {
                    messageBean = new MessageDrivenBean(ejbName2);
                    ejbJar.addEnterpriseBean((EnterpriseBean)messageBean);
                }
                if (messageBean.getEjbClass() != null) continue;
                messageBean.setEjbClass(beanClass.getName());
            }
            AssemblyDescriptor assemblyDescriptor = ejbModule.getEjbJar().getAssemblyDescriptor();
            if (assemblyDescriptor == null) {
                assemblyDescriptor = new AssemblyDescriptor();
                ejbModule.getEjbJar().setAssemblyDescriptor(assemblyDescriptor);
            }
            startupLogger.debug("Searching for inherited application exceptions (see OPENEJB-980) - it doesn't care whether inherited is true/false");
            List appExceptions = finder.findInheritedAnnotatedClasses(ApplicationException.class);
            for (Class exceptionClass : appExceptions) {
                startupLogger.debug("...handling " + exceptionClass);
                if (assemblyDescriptor.getApplicationException(exceptionClass) != null) continue;
                ApplicationException annotation = exceptionClass.getAnnotation(ApplicationException.class);
                if (annotation == null) {
                    Class parentExceptionClass = exceptionClass;
                    while (annotation == null) {
                        parentExceptionClass = parentExceptionClass.getSuperclass();
                        annotation = parentExceptionClass.getAnnotation(ApplicationException.class);
                    }
                }
                startupLogger.debug("...adding " + exceptionClass + " with rollback=" + annotation.rollback());
                assemblyDescriptor.addApplicationException(exceptionClass, annotation.rollback());
            }
            ejbModule.getFinderReference().set(finder);
            return ejbModule;
        }

        private String getEjbName(MessageDriven mdb, Class<?> beanClass) {
            String ejbName = mdb.name().length() == 0 ? beanClass.getSimpleName() : mdb.name();
            return ejbName;
        }

        private String getEjbName(Stateful stateful, Class<?> beanClass) {
            String ejbName = stateful.name().length() == 0 ? beanClass.getSimpleName() : stateful.name();
            return ejbName;
        }

        private String getEjbName(Stateless stateless, Class<?> beanClass) {
            String ejbName = stateless.name().length() == 0 ? beanClass.getSimpleName() : stateless.name();
            return ejbName;
        }

        private String getEjbName(Singleton singleton, Class<?> beanClass) {
            String ejbName = singleton.name().length() == 0 ? beanClass.getSimpleName() : singleton.name();
            return ejbName;
        }

        private boolean isValidEjbAnnotationUsage(Class annotationClass, Class<?> beanClass, String ejbName, EjbModule ejbModule) {
            ArrayList<Class> annotations = new ArrayList<Class>(Arrays.asList(Singleton.class, Stateless.class, Stateful.class, MessageDriven.class));
            annotations.remove(annotationClass);
            HashMap names = new HashMap();
            boolean b = true;
            for (Class secondAnnotation : annotations) {
                Object annotation = beanClass.getAnnotation(secondAnnotation);
                if (annotation == null) continue;
                String secondEjbName = null;
                if (annotation instanceof Stateful) {
                    secondEjbName = this.getEjbName((Stateful)annotation, beanClass);
                } else if (annotation instanceof Stateless) {
                    secondEjbName = this.getEjbName((Stateless)annotation, beanClass);
                } else if (annotation instanceof Singleton) {
                    secondEjbName = this.getEjbName((Singleton)annotation, beanClass);
                } else if (annotation instanceof MessageDriven) {
                    secondEjbName = this.getEjbName((MessageDriven)annotation, beanClass);
                }
                if (!ejbName.equals(secondEjbName)) continue;
                ejbModule.getValidation().fail(ejbName, "multiplyAnnotatedAsBean", annotationClass.getSimpleName(), secondAnnotation.getSimpleName(), ejbName, beanClass.getName());
            }
            if (beanClass.isInterface()) {
                ejbModule.getValidation().fail(ejbName, "interfaceAnnotatedAsBean", annotationClass.getSimpleName(), beanClass.getName());
                return false;
            }
            if (Modifier.isAbstract(beanClass.getModifiers())) {
                ejbModule.getValidation().fail(ejbName, "abstractAnnotatedAsBean", annotationClass.getSimpleName(), beanClass.getName());
                return false;
            }
            return b;
        }
    }
}

