/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.assembler.classic;

import java.util.HashMap;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.assembler.classic.PersistenceUnitInfo;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.persistence.PersistenceClassLoaderHandler;
import org.apache.openejb.persistence.PersistenceUnitInfoImpl;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class PersistenceBuilder {
    public static final Logger logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP, PersistenceBuilder.class);
    public static final String PROVIDER_PROP = "javax.persistence.provider";
    public static final String TRANSACTIONTYPE_PROP = "javax.persistence.transactionType";
    public static final String JTADATASOURCE_PROP = "javax.persistence.jtaDataSource";
    public static final String NON_JTADATASOURCE_PROP = "javax.persistence.nonJtaDataSource";
    private static final String DEFAULT_PERSISTENCE_PROVIDER = "org.apache.openjpa.persistence.PersistenceProviderImpl";
    private final PersistenceClassLoaderHandler persistenceClassLoaderHandler;
    private String providerEnv;
    private String transactionTypeEnv;
    private String jtaDataSourceEnv;
    private String nonJtaDataSourceEnv;

    public PersistenceBuilder(PersistenceClassLoaderHandler persistenceClassLoaderHandler) {
        this.loadSystemProps();
        this.persistenceClassLoaderHandler = persistenceClassLoaderHandler;
    }

    private void loadSystemProps() {
        this.providerEnv = System.getProperty(PROVIDER_PROP);
        this.transactionTypeEnv = System.getProperty(TRANSACTIONTYPE_PROP);
        this.jtaDataSourceEnv = System.getProperty(JTADATASOURCE_PROP);
        this.nonJtaDataSourceEnv = System.getProperty(NON_JTADATASOURCE_PROP);
    }

    public EntityManagerFactory createEntityManagerFactory(PersistenceUnitInfo info, ClassLoader classLoader) throws Exception {
        PersistenceUnitTransactionType type;
        PersistenceUnitInfoImpl unitInfo = new PersistenceUnitInfoImpl(this.persistenceClassLoaderHandler);
        unitInfo.setId(info.id);
        unitInfo.setPersistenceUnitName(info.name);
        if (this.providerEnv != null) {
            unitInfo.setPersistenceProviderClassName(this.providerEnv);
        } else {
            unitInfo.setPersistenceProviderClassName(info.provider);
        }
        unitInfo.setClassLoader(classLoader);
        unitInfo.setExcludeUnlistedClasses(info.excludeUnlistedClasses);
        String jtaDataSourceId = info.jtaDataSource;
        if (this.jtaDataSourceEnv != null) {
            jtaDataSourceId = this.jtaDataSourceEnv;
        }
        if (jtaDataSourceId != null && System.getProperty("duct tape") == null) {
            try {
                if (!jtaDataSourceId.startsWith("java:openejb/Resource/") && !jtaDataSourceId.startsWith("openejb/Resource/")) {
                    jtaDataSourceId = "openejb/Resource/" + jtaDataSourceId;
                }
                Context context = SystemInstance.get().getComponent(ContainerSystem.class).getJNDIContext();
                DataSource jtaDataSource = (DataSource)context.lookup(jtaDataSourceId);
                unitInfo.setJtaDataSource(jtaDataSource);
            }
            catch (NamingException e) {
                throw new OpenEJBException("Could not lookup <jta-data-source> '" + jtaDataSourceId + "' for unit '" + unitInfo.getPersistenceUnitName() + "'", e);
            }
        }
        unitInfo.setManagedClassNames(info.classes);
        unitInfo.setMappingFileNames(info.mappingFiles);
        unitInfo.setProperties(info.properties);
        if (this.transactionTypeEnv != null) {
            try {
                type = Enum.valueOf(PersistenceUnitTransactionType.class, this.transactionTypeEnv.toUpperCase());
                unitInfo.setTransactionType(type);
            }
            catch (IllegalArgumentException e) {
                throw (IllegalArgumentException)new IllegalArgumentException("Unknown javax.persistence.transactionType, valid options are " + PersistenceUnitTransactionType.JTA + " or " + PersistenceUnitTransactionType.RESOURCE_LOCAL).initCause(e);
            }
        } else {
            type = Enum.valueOf(PersistenceUnitTransactionType.class, info.transactionType);
            unitInfo.setTransactionType(type);
        }
        String nonJtaDataSourceId = info.nonJtaDataSource;
        if (this.nonJtaDataSourceEnv != null) {
            nonJtaDataSourceId = this.nonJtaDataSourceEnv;
        }
        if (nonJtaDataSourceId != null && System.getProperty("duct tape") == null) {
            try {
                if (!nonJtaDataSourceId.startsWith("java:openejb/Resource/")) {
                    nonJtaDataSourceId = "java:openejb/Resource/" + nonJtaDataSourceId;
                }
                Context context = SystemInstance.get().getComponent(ContainerSystem.class).getJNDIContext();
                DataSource nonJtaDataSource = (DataSource)context.lookup(nonJtaDataSourceId);
                unitInfo.setNonJtaDataSource(nonJtaDataSource);
            }
            catch (NamingException e) {
                throw new OpenEJBException("Could not lookup <non-jta-data-source> '" + nonJtaDataSourceId + "' for unit '" + unitInfo.getPersistenceUnitName() + "'", e);
            }
        }
        unitInfo.setRootUrlAndJarUrls(info.persistenceUnitRootUrl, info.jarFiles);
        String persistenceProviderClassName = unitInfo.getPersistenceProviderClassName();
        if (persistenceProviderClassName == null) {
            persistenceProviderClassName = DEFAULT_PERSISTENCE_PROVIDER;
        }
        unitInfo.setPersistenceProviderClassName(persistenceProviderClassName);
        Class<?> clazz = classLoader.loadClass(persistenceProviderClassName);
        PersistenceProvider persistenceProvider = (PersistenceProvider)clazz.newInstance();
        logger.info("assembler.buildingPersistenceUnit", unitInfo.getPersistenceUnitName(), unitInfo.getPersistenceProviderClassName(), unitInfo.getPersistenceUnitRootUrl(), unitInfo.getTransactionType());
        EntityManagerFactory emf = persistenceProvider.createContainerEntityManagerFactory((javax.persistence.spi.PersistenceUnitInfo)unitInfo, new HashMap());
        return emf;
    }
}

