/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.assembler.classic;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.EJBContext;
import javax.ejb.TimerService;
import javax.ejb.spi.HandleDelegate;
import javax.naming.Context;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.persistence.EntityManagerFactory;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceContext;
import org.apache.openejb.Injection;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.assembler.classic.EjbLocalReferenceInfo;
import org.apache.openejb.assembler.classic.EjbReferenceInfo;
import org.apache.openejb.assembler.classic.EjbResolver;
import org.apache.openejb.assembler.classic.EnvEntryInfo;
import org.apache.openejb.assembler.classic.JndiBuilder;
import org.apache.openejb.assembler.classic.JndiEncInfo;
import org.apache.openejb.assembler.classic.LazyEjbReference;
import org.apache.openejb.assembler.classic.PersistenceContextReferenceInfo;
import org.apache.openejb.assembler.classic.PersistenceUnitReferenceInfo;
import org.apache.openejb.assembler.classic.PortRefInfo;
import org.apache.openejb.assembler.classic.ReferenceLocationInfo;
import org.apache.openejb.assembler.classic.ResourceEnvReferenceInfo;
import org.apache.openejb.assembler.classic.ResourceReferenceInfo;
import org.apache.openejb.assembler.classic.ServiceReferenceInfo;
import org.apache.openejb.assembler.classic.WsBuilder;
import org.apache.openejb.core.CoreUserTransaction;
import org.apache.openejb.core.JndiFactory;
import org.apache.openejb.core.TransactionSynchronizationRegistryWrapper;
import org.apache.openejb.core.ivm.naming.CrossClassLoaderJndiReference;
import org.apache.openejb.core.ivm.naming.IntraVmJndiReference;
import org.apache.openejb.core.ivm.naming.JaxWsServiceReference;
import org.apache.openejb.core.ivm.naming.JndiReference;
import org.apache.openejb.core.ivm.naming.JndiUrlReference;
import org.apache.openejb.core.ivm.naming.PersistenceContextReference;
import org.apache.openejb.core.ivm.naming.Reference;
import org.apache.openejb.core.ivm.naming.SystemComponentReference;
import org.apache.openejb.core.ivm.naming.URLReference;
import org.apache.openejb.core.timer.TimerServiceWrapper;
import org.apache.openejb.core.webservices.HandlerChainData;
import org.apache.openejb.core.webservices.PortRefData;
import org.apache.openejb.core.webservices.ServiceRefData;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.persistence.JtaEntityManager;
import org.apache.openejb.persistence.JtaEntityManagerRegistry;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.omg.CORBA.ORB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JndiEncBuilder {
    public static final Logger logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP, JndiEncBuilder.class.getPackage().getName());
    private final boolean beanManagedTransactions;
    private final JndiEncInfo jndiEnc;
    private final URI moduleUri;
    private final List<Injection> injections;
    private final ClassLoader classLoader;
    private boolean useCrossClassLoaderRef = true;
    private boolean client = false;

    public JndiEncBuilder(JndiEncInfo jndiEnc, List<Injection> injections, String moduleId, ClassLoader classLoader) throws OpenEJBException {
        this(jndiEnc, injections, null, moduleId, classLoader);
    }

    public JndiEncBuilder(JndiEncInfo jndiEnc, List<Injection> injections, String transactionType, String moduleId, ClassLoader classLoader) throws OpenEJBException {
        this.jndiEnc = jndiEnc;
        this.injections = injections;
        this.beanManagedTransactions = transactionType != null && transactionType.equalsIgnoreCase("Bean");
        try {
            this.moduleUri = new URI(moduleId);
        }
        catch (URISyntaxException e) {
            throw new OpenEJBException(e);
        }
        this.classLoader = classLoader;
    }

    public boolean isUseCrossClassLoaderRef() {
        return this.useCrossClassLoaderRef;
    }

    public void setUseCrossClassLoaderRef(boolean useCrossClassLoaderRef) {
        this.useCrossClassLoaderRef = useCrossClassLoaderRef;
    }

    public boolean isClient() {
        return this.client;
    }

    public void setClient(boolean client) {
        this.client = client;
    }

    public Context build() throws OpenEJBException {
        Map<String, Object> bindings = this.buildMap();
        JndiFactory jndiFactory = SystemInstance.get().getComponent(JndiFactory.class);
        return jndiFactory.createComponentContext(bindings);
    }

    public Map<String, Object> buildMap() throws OpenEJBException {
        Object reference;
        Reference reference2;
        String jndiName;
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        TransactionManager transactionManager = SystemInstance.get().getComponent(TransactionManager.class);
        bindings.put("java:comp/TransactionManager", transactionManager);
        bindings.put("java:comp/TransactionSynchronizationRegistry", new TransactionSynchronizationRegistryWrapper());
        bindings.put("java:comp/ORB", (Object)new SystemComponentReference(ORB.class));
        bindings.put("java:comp/HandleDelegate", (Object)new SystemComponentReference(HandleDelegate.class));
        JtaEntityManagerRegistry jtaEntityManagerRegistry = SystemInstance.get().getComponent(JtaEntityManagerRegistry.class);
        CoreUserTransaction userTransaction = null;
        if (this.beanManagedTransactions) {
            userTransaction = new CoreUserTransaction(transactionManager);
            bindings.put("java:comp/UserTransaction", userTransaction);
        }
        bindings.put("java:comp/TimerService", new TimerServiceWrapper());
        for (EjbReferenceInfo ejbReferenceInfo : this.jndiEnc.ejbReferences) {
            Reference reference22 = null;
            if (ejbReferenceInfo.location != null) {
                reference22 = this.buildReferenceLocation(ejbReferenceInfo.location);
            } else if (ejbReferenceInfo.ejbDeploymentId == null) {
                reference22 = new LazyEjbReference(new Ref(ejbReferenceInfo), this.moduleUri, this.useCrossClassLoaderRef);
            } else {
                jndiName = "openejb/Deployment/" + JndiBuilder.format(ejbReferenceInfo.ejbDeploymentId, ejbReferenceInfo.interfaceClassName, InterfaceType.BUSINESS_REMOTE);
                reference22 = this.useCrossClassLoaderRef && ejbReferenceInfo.externalReference ? new CrossClassLoaderJndiReference(jndiName) : new IntraVmJndiReference(jndiName);
            }
            bindings.put(this.normalize(ejbReferenceInfo.referenceName), (Object)reference22);
        }
        for (EjbLocalReferenceInfo ejbLocalReferenceInfo : this.jndiEnc.ejbLocalReferences) {
            reference2 = null;
            if (ejbLocalReferenceInfo.location != null) {
                reference2 = this.buildReferenceLocation(ejbLocalReferenceInfo.location);
            } else if (ejbLocalReferenceInfo.ejbDeploymentId == null) {
                reference2 = new LazyEjbReference(new Ref(ejbLocalReferenceInfo), this.moduleUri, false);
            } else {
                jndiName = "openejb/Deployment/" + JndiBuilder.format(ejbLocalReferenceInfo.ejbDeploymentId, ejbLocalReferenceInfo.interfaceClassName, InterfaceType.BUSINESS_LOCAL);
                reference2 = new IntraVmJndiReference(jndiName);
            }
            bindings.put(this.normalize(ejbLocalReferenceInfo.referenceName), (Object)reference2);
        }
        for (EnvEntryInfo envEntryInfo : this.jndiEnc.envEntries) {
            if (envEntryInfo.location != null) {
                reference2 = this.buildReferenceLocation(envEntryInfo.location);
                bindings.put(this.normalize(envEntryInfo.name), (Object)reference2);
                continue;
            }
            try {
                Class<?> type = Class.forName(envEntryInfo.type.trim());
                Object obj = null;
                if (type == String.class) {
                    obj = new String(envEntryInfo.value);
                } else if (type == Double.class) {
                    obj = new Double(envEntryInfo.value);
                } else if (type == Integer.class) {
                    obj = new Integer(envEntryInfo.value);
                } else if (type == Long.class) {
                    obj = new Long(envEntryInfo.value);
                } else if (type == Float.class) {
                    obj = new Float(envEntryInfo.value);
                } else if (type == Short.class) {
                    obj = new Short(envEntryInfo.value);
                } else if (type == Boolean.class) {
                    obj = new Boolean(envEntryInfo.value);
                } else if (type == Byte.class) {
                    obj = new Byte(envEntryInfo.value);
                } else if (type == Character.class) {
                    StringBuilder sb = new StringBuilder(envEntryInfo.value + " ");
                    obj = new Character(sb.charAt(0));
                } else if (type == URL.class) {
                    obj = new URL(envEntryInfo.value);
                } else {
                    throw new IllegalArgumentException("Invalid env-ref-type " + type);
                }
                bindings.put(this.normalize(envEntryInfo.name), obj);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Invalid environment entry type: " + envEntryInfo.type.trim() + " for entry: " + envEntryInfo.name, e);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("The env-entry-value for entry " + envEntryInfo.name + " was not recognizable as type " + envEntryInfo.type + ". Received Message: " + e.getLocalizedMessage(), e);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("URL for reference " + envEntryInfo.name + " was not a valid URL: " + envEntryInfo.value, e);
            }
        }
        for (ResourceReferenceInfo resourceReferenceInfo : this.jndiEnc.resourceRefs) {
            reference2 = null;
            if ("java.net.URL".equals(resourceReferenceInfo.referenceType)) {
                reference2 = resourceReferenceInfo.location != null ? this.buildReferenceLocation(resourceReferenceInfo.location) : new URLReference(resourceReferenceInfo.resourceID);
            } else if (resourceReferenceInfo.location != null) {
                reference2 = this.buildReferenceLocation(resourceReferenceInfo.location);
            } else if (resourceReferenceInfo.resourceID != null) {
                jndiName = "openejb/Resource/" + resourceReferenceInfo.resourceID;
                reference2 = new IntraVmJndiReference(jndiName);
            } else {
                jndiName = "openejb/Resource/" + resourceReferenceInfo.referenceName;
                reference2 = new IntraVmJndiReference(jndiName);
            }
            bindings.put(this.normalize(resourceReferenceInfo.referenceName), (Object)reference2);
        }
        for (ResourceEnvReferenceInfo resourceEnvReferenceInfo : this.jndiEnc.resourceEnvRefs) {
            String jndiName2;
            LinkRef linkRef = null;
            try {
                Class<?> type = Class.forName(resourceEnvReferenceInfo.resourceEnvRefType, true, EJBContext.class.getClassLoader());
                if (EJBContext.class.isAssignableFrom(type)) {
                    String jndiName22 = "java:comp/EJBContext";
                    linkRef = new LinkRef(jndiName22);
                    bindings.put(this.normalize(resourceEnvReferenceInfo.resourceEnvRefName), linkRef);
                    continue;
                }
                if (WebServiceContext.class.equals(type)) {
                    jndiName2 = "java:comp/WebServiceContext";
                    linkRef = new LinkRef(jndiName2);
                    bindings.put(this.normalize(resourceEnvReferenceInfo.resourceEnvRefName), linkRef);
                    continue;
                }
                if (TimerService.class.equals(type)) {
                    jndiName2 = "java:comp/TimerService";
                    linkRef = new LinkRef(jndiName2);
                    bindings.put(this.normalize(resourceEnvReferenceInfo.resourceEnvRefName), linkRef);
                    continue;
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            reference = null;
            if (UserTransaction.class.getName().equals(resourceEnvReferenceInfo.resourceEnvRefType)) {
                reference = userTransaction;
            } else if (resourceEnvReferenceInfo.location != null) {
                reference = this.buildReferenceLocation(resourceEnvReferenceInfo.location);
            } else if (resourceEnvReferenceInfo.resourceID != null) {
                jndiName2 = "openejb/Resource/" + resourceEnvReferenceInfo.resourceID;
                reference = new IntraVmJndiReference(jndiName2);
            } else {
                jndiName2 = "openejb/Resource/" + resourceEnvReferenceInfo.resourceEnvRefName;
                reference = new IntraVmJndiReference(jndiName2);
            }
            if (reference == null) continue;
            bindings.put(this.normalize(resourceEnvReferenceInfo.resourceEnvRefName), reference);
        }
        for (PersistenceUnitReferenceInfo persistenceUnitReferenceInfo : this.jndiEnc.persistenceUnitRefs) {
            if (persistenceUnitReferenceInfo.location != null) {
                reference2 = this.buildReferenceLocation(persistenceUnitReferenceInfo.location);
                bindings.put(this.normalize(persistenceUnitReferenceInfo.referenceName), (Object)reference2);
                continue;
            }
            String jndiName3 = "openejb/PersistenceUnit/" + persistenceUnitReferenceInfo.unitId;
            reference = new IntraVmJndiReference(jndiName3);
            bindings.put(this.normalize(persistenceUnitReferenceInfo.referenceName), reference);
        }
        for (PersistenceContextReferenceInfo persistenceContextReferenceInfo : this.jndiEnc.persistenceContextRefs) {
            EntityManagerFactory factory;
            if (persistenceContextReferenceInfo.location != null) {
                reference2 = this.buildReferenceLocation(persistenceContextReferenceInfo.location);
                bindings.put(this.normalize(persistenceContextReferenceInfo.referenceName), (Object)reference2);
                continue;
            }
            Context context = SystemInstance.get().getComponent(ContainerSystem.class).getJNDIContext();
            try {
                factory = (EntityManagerFactory)context.lookup("openejb/PersistenceUnit/" + persistenceContextReferenceInfo.unitId);
            }
            catch (NamingException e) {
                throw new OpenEJBException("PersistenceUnit '" + persistenceContextReferenceInfo.unitId + "' not found for EXTENDED ref '" + persistenceContextReferenceInfo.referenceName + "'");
            }
            JtaEntityManager jtaEntityManager = new JtaEntityManager(jtaEntityManagerRegistry, factory, persistenceContextReferenceInfo.properties, persistenceContextReferenceInfo.extended);
            PersistenceContextReference reference3 = new PersistenceContextReference(jtaEntityManager);
            bindings.put(this.normalize(persistenceContextReferenceInfo.referenceName), (Object)reference3);
        }
        for (ServiceReferenceInfo serviceReferenceInfo : this.jndiEnc.serviceRefs) {
            URL wsdlUrl;
            Class<?> referenceClass;
            Class<Service> serviceClass;
            block77: {
                if (serviceReferenceInfo.location != null) {
                    reference2 = this.buildReferenceLocation(serviceReferenceInfo.location);
                    bindings.put(this.normalize(serviceReferenceInfo.referenceName), (Object)reference2);
                    continue;
                }
                serviceClass = Service.class;
                if (serviceReferenceInfo.serviceType != null) {
                    try {
                        serviceClass = this.classLoader.loadClass(serviceReferenceInfo.serviceType).asSubclass(Service.class);
                    }
                    catch (Exception e) {
                        throw new OpenEJBException("Could not load service type class " + serviceReferenceInfo.serviceType, e);
                    }
                }
                referenceClass = null;
                if (serviceReferenceInfo.referenceType != null) {
                    try {
                        referenceClass = this.classLoader.loadClass(serviceReferenceInfo.referenceType);
                    }
                    catch (Exception e) {
                        throw new OpenEJBException("Could not load reference type class " + serviceReferenceInfo.referenceType, e);
                    }
                }
                if (referenceClass != null && Service.class.isAssignableFrom(referenceClass)) {
                    serviceClass = referenceClass.asSubclass(Service.class);
                }
                wsdlUrl = null;
                if (serviceReferenceInfo.wsdlFile != null) {
                    try {
                        wsdlUrl = new URL(serviceReferenceInfo.wsdlFile);
                    }
                    catch (MalformedURLException e) {
                        wsdlUrl = this.classLoader.getResource(serviceReferenceInfo.wsdlFile);
                        if (wsdlUrl != null) break block77;
                        logger.warning("Error obtaining WSDL: " + serviceReferenceInfo.wsdlFile, e);
                    }
                }
            }
            ArrayList<PortRefData> portRefs = new ArrayList<PortRefData>(serviceReferenceInfo.portRefs.size());
            for (PortRefInfo portRefInfo : serviceReferenceInfo.portRefs) {
                PortRefData portRef = new PortRefData();
                portRef.setQName(portRefInfo.qname);
                portRef.setServiceEndpointInterface(portRefInfo.serviceEndpointInterface);
                portRef.setEnableMtom(portRefInfo.enableMtom);
                portRef.getProperties().putAll((Map<?, ?>)portRefInfo.properties);
                portRefs.add(portRef);
            }
            List<HandlerChainData> handlerChains = null;
            if (!serviceReferenceInfo.handlerChains.isEmpty()) {
                handlerChains = WsBuilder.toHandlerChainData(serviceReferenceInfo.handlerChains, this.classLoader);
            }
            if (!this.client) {
                JaxWsServiceReference reference4 = new JaxWsServiceReference(serviceReferenceInfo.id, serviceReferenceInfo.serviceQName, serviceClass, serviceReferenceInfo.portQName, referenceClass, wsdlUrl, portRefs, handlerChains, this.injections);
                bindings.put(this.normalize(serviceReferenceInfo.referenceName), (Object)reference4);
                continue;
            }
            ServiceRefData serviceRefData = new ServiceRefData(serviceReferenceInfo.id, serviceReferenceInfo.serviceQName, serviceClass, serviceReferenceInfo.portQName, referenceClass, wsdlUrl, handlerChains, portRefs);
            bindings.put(this.normalize(serviceReferenceInfo.referenceName), serviceRefData);
        }
        return bindings;
    }

    public static boolean bindingExists(Context context, Name contextName) {
        try {
            return context.lookup(contextName) != null;
        }
        catch (NamingException namingException) {
            return false;
        }
    }

    private Reference buildReferenceLocation(ReferenceLocationInfo location) {
        if (location.jndiProviderId != null) {
            String subContextName = "openejb/remote_jndi_contexts/" + location.jndiProviderId;
            return new JndiReference(subContextName, location.jndiName);
        }
        return new JndiUrlReference(location.jndiName);
    }

    private String normalize(String name) {
        if (name.charAt(0) == '/') {
            name = name.substring(1);
        }
        if (!name.startsWith("java:comp/env") && !name.startsWith("comp/env")) {
            name = name.startsWith("env/") ? "java:comp/" + name : "java:comp/env/" + name;
        }
        return name;
    }

    private static class Ref
    implements EjbResolver.Reference,
    Serializable {
        private final EjbReferenceInfo info;

        public Ref(EjbReferenceInfo info) {
            this.info = info;
        }

        public String getEjbLink() {
            return this.info.link;
        }

        public String getHome() {
            return this.info.homeClassName;
        }

        public String getInterface() {
            return this.info.interfaceClassName;
        }

        public String getMappedName() {
            return null;
        }

        public String getName() {
            return this.info.referenceName;
        }

        public EjbResolver.Type getRefType() {
            if (this.info instanceof EjbLocalReferenceInfo) {
                return EjbResolver.Type.LOCAL;
            }
            if (this.info.homeClassName != null) {
                return EjbResolver.Type.REMOTE;
            }
            return EjbResolver.Type.UNKNOWN;
        }
    }
}

