/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.assembler.classic;

import java.io.File;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.persistence.EntityManagerFactory;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.XATerminator;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.apache.geronimo.connector.work.GeronimoWorkManager;
import org.apache.geronimo.transaction.manager.GeronimoTransactionManager;
import org.apache.geronimo.transaction.manager.XAWork;
import org.apache.openejb.BeanType;
import org.apache.openejb.ClassLoaderUtil;
import org.apache.openejb.Container;
import org.apache.openejb.DeploymentInfo;
import org.apache.openejb.DuplicateDeploymentIdException;
import org.apache.openejb.Injection;
import org.apache.openejb.NoSuchApplicationException;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.UndeployException;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.ApplicationExceptionInfo;
import org.apache.openejb.assembler.classic.AssemblerTool;
import org.apache.openejb.assembler.classic.ClientInfo;
import org.apache.openejb.assembler.classic.CmpJarBuilder;
import org.apache.openejb.assembler.classic.ConnectionManagerInfo;
import org.apache.openejb.assembler.classic.ConnectorInfo;
import org.apache.openejb.assembler.classic.ContainerInfo;
import org.apache.openejb.assembler.classic.ContainerSystemInfo;
import org.apache.openejb.assembler.classic.DeploymentListener;
import org.apache.openejb.assembler.classic.EjbJarBuilder;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.openejb.assembler.classic.EjbResolver;
import org.apache.openejb.assembler.classic.EnterpriseBeanInfo;
import org.apache.openejb.assembler.classic.FacilitiesInfo;
import org.apache.openejb.assembler.classic.InjectionBuilder;
import org.apache.openejb.assembler.classic.JaccPermissionsBuilder;
import org.apache.openejb.assembler.classic.JndiBuilder;
import org.apache.openejb.assembler.classic.JndiContextInfo;
import org.apache.openejb.assembler.classic.JndiEncBuilder;
import org.apache.openejb.assembler.classic.MdbContainerInfo;
import org.apache.openejb.assembler.classic.MethodConcurrencyBuilder;
import org.apache.openejb.assembler.classic.MethodScheduleBuilder;
import org.apache.openejb.assembler.classic.MethodTransactionBuilder;
import org.apache.openejb.assembler.classic.OpenEjbConfiguration;
import org.apache.openejb.assembler.classic.OpenEjbConfigurationFactory;
import org.apache.openejb.assembler.classic.PersistenceBuilder;
import org.apache.openejb.assembler.classic.PersistenceUnitInfo;
import org.apache.openejb.assembler.classic.PolicyContext;
import org.apache.openejb.assembler.classic.ProxyFactoryInfo;
import org.apache.openejb.assembler.classic.ResourceInfo;
import org.apache.openejb.assembler.classic.SecurityServiceInfo;
import org.apache.openejb.assembler.classic.ServiceInfo;
import org.apache.openejb.assembler.classic.TransactionServiceInfo;
import org.apache.openejb.assembler.classic.WebAppBuilder;
import org.apache.openejb.assembler.classic.WebAppInfo;
import org.apache.openejb.core.ConnectorReference;
import org.apache.openejb.core.CoreContainerSystem;
import org.apache.openejb.core.CoreDeploymentInfo;
import org.apache.openejb.core.CoreUserTransaction;
import org.apache.openejb.core.JndiFactory;
import org.apache.openejb.core.ServerFederation;
import org.apache.openejb.core.SimpleTransactionSynchronizationRegistry;
import org.apache.openejb.core.TransactionSynchronizationRegistryWrapper;
import org.apache.openejb.core.ivm.naming.IvmContext;
import org.apache.openejb.core.ivm.naming.IvmJndiFactory;
import org.apache.openejb.core.timer.EjbTimerServiceImpl;
import org.apache.openejb.core.timer.NullEjbTimerServiceImpl;
import org.apache.openejb.core.transaction.JtaTransactionPolicyFactory;
import org.apache.openejb.core.transaction.SimpleBootstrapContext;
import org.apache.openejb.core.transaction.SimpleWorkManager;
import org.apache.openejb.core.transaction.TransactionPolicyFactory;
import org.apache.openejb.core.transaction.TransactionType;
import org.apache.openejb.javaagent.Agent;
import org.apache.openejb.loader.Options;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.persistence.JtaEntityManagerRegistry;
import org.apache.openejb.persistence.PersistenceClassLoaderHandler;
import org.apache.openejb.resource.GeronimoConnectionManagerFactory;
import org.apache.openejb.spi.ApplicationServer;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.spi.SecurityService;
import org.apache.openejb.util.AsmParameterNameLoader;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.Messages;
import org.apache.openejb.util.OpenEJBErrorHandler;
import org.apache.openejb.util.References;
import org.apache.openejb.util.SafeToolkit;
import org.apache.openejb.util.proxy.ProxyFactory;
import org.apache.openejb.util.proxy.ProxyManager;
import org.apache.xbean.finder.ResourceFinder;
import org.apache.xbean.recipe.ObjectRecipe;
import org.apache.xbean.recipe.Option;
import org.apache.xbean.recipe.UnsetPropertiesRecipe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Assembler
extends AssemblerTool
implements org.apache.openejb.spi.Assembler {
    public static final String JAVA_OPENEJB_NAMING_CONTEXT = "openejb/";
    public static final String PERSISTENCE_UNIT_NAMING_CONTEXT = "openejb/PersistenceUnit/";
    private static final String OPENEJB_URL_PKG_PREFIX = "org.apache.openejb.core.ivm.naming";
    public static final String DUCT_TAPE_PROPERTY = "duct tape";
    public static final Logger logger;
    Messages messages = new Messages(Assembler.class.getPackage().getName());
    private final CoreContainerSystem containerSystem;
    private final PersistenceClassLoaderHandler persistenceClassLoaderHandler;
    private final JndiBuilder jndiBuilder;
    private TransactionManager transactionManager;
    private SecurityService securityService;
    protected OpenEjbConfigurationFactory configFactory;
    private final Map<String, AppInfo> deployedApplications = new HashMap<String, AppInfo>();
    private final List<DeploymentListener> deploymentListeners = new ArrayList<DeploymentListener>();
    protected SafeToolkit toolkit = SafeToolkit.getToolkit("Assembler");
    protected OpenEjbConfiguration config;
    private static ThreadLocal<Map<String, Object>> context;

    @Override
    public ContainerSystem getContainerSystem() {
        return this.containerSystem;
    }

    @Override
    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    @Override
    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public synchronized void addDeploymentListener(DeploymentListener deploymentListener) {
        this.deploymentListeners.add(deploymentListener);
    }

    public synchronized void removeDeploymentListener(DeploymentListener deploymentListener) {
        this.deploymentListeners.remove(deploymentListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void fireAfterApplicationCreated(AppInfo appInfo) {
        ArrayList<DeploymentListener> listeners;
        Assembler assembler = this;
        synchronized (assembler) {
            listeners = new ArrayList<DeploymentListener>(this.deploymentListeners);
        }
        for (DeploymentListener listener : listeners) {
            String listenerName = listener.getClass().getSimpleName();
            try {
                logger.debug("appCreationEvent.start", listenerName, appInfo.jarPath);
                listener.afterApplicationCreated(appInfo);
            }
            catch (Throwable e) {
                logger.error("appCreationEvent.failed", e, listenerName, appInfo.jarPath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void fireBeforeApplicationDestroyed(AppInfo appInfo) {
        ArrayList<DeploymentListener> listeners;
        Assembler assembler = this;
        synchronized (assembler) {
            listeners = new ArrayList<DeploymentListener>(this.deploymentListeners);
        }
        for (DeploymentListener listener : listeners) {
            String listenerName = listener.getClass().getSimpleName();
            try {
                logger.debug("appDestroyedEvent.start", listenerName, appInfo.jarPath);
                listener.beforeApplicationDestroyed(appInfo);
            }
            catch (Throwable e) {
                logger.error("appDestroyedEvent.failed", e, listenerName, appInfo.jarPath);
            }
        }
    }

    public Assembler() {
        this(new IvmJndiFactory());
    }

    public Assembler(JndiFactory jndiFactory) {
        this.persistenceClassLoaderHandler = new PersistenceClassLoaderHandlerImpl();
        Assembler.installNaming();
        SystemInstance system = SystemInstance.get();
        system.setComponent(Assembler.class, this);
        this.containerSystem = new CoreContainerSystem(jndiFactory);
        system.setComponent(ContainerSystem.class, this.containerSystem);
        this.jndiBuilder = new JndiBuilder(this.containerSystem.getJNDIContext());
        this.setConfiguration(new OpenEjbConfiguration());
        ApplicationServer appServer = system.getComponent(ApplicationServer.class);
        if (appServer == null) {
            system.setComponent(ApplicationServer.class, new ServerFederation());
        }
        system.setComponent(EjbResolver.class, new EjbResolver(null, EjbResolver.Scope.GLOBAL, new EjbJarInfo[0]));
    }

    private void setConfiguration(OpenEjbConfiguration config) {
        this.config = config;
        if (config.containerSystem == null) {
            config.containerSystem = new ContainerSystemInfo();
        }
        if (config.facilities == null) {
            config.facilities = new FacilitiesInfo();
        }
        SystemInstance.get().setComponent(OpenEjbConfiguration.class, this.config);
    }

    @Override
    public void init(Properties props) throws OpenEJBException {
        this.props = new Properties(props);
        Options options = new Options(props, SystemInstance.get().getOptions());
        String className = options.get("openejb.configurator", "org.apache.openejb.config.ConfigurationFactory");
        this.configFactory = (OpenEjbConfigurationFactory)this.toolkit.newInstance(className);
        this.configFactory.init(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void installNaming() {
        Properties systemProperties;
        if (System.getProperty(DUCT_TAPE_PROPERTY) != null) {
            return;
        }
        Properties properties = systemProperties = System.getProperties();
        synchronized (properties) {
            String str = systemProperties.getProperty("java.naming.factory.url.pkgs");
            String naming = OPENEJB_URL_PKG_PREFIX;
            if (str == null) {
                str = naming;
            } else if (str.indexOf(naming) == -1) {
                str = str + ":" + naming;
            }
            systemProperties.setProperty("java.naming.factory.url.pkgs", str);
        }
    }

    public static void setContext(Map<String, Object> map) {
        context.set(map);
    }

    public static Map<String, Object> getContext() {
        Map<String, Object> map = context.get();
        if (map == null) {
            map = new HashMap<String, Object>();
            context.set(map);
        }
        return map;
    }

    @Override
    public void build() throws OpenEJBException {
        Assembler.setContext(new HashMap<String, Object>());
        try {
            OpenEjbConfiguration config = this.getOpenEjbConfiguration();
            this.buildContainerSystem(config);
        }
        catch (OpenEJBException ae) {
            throw ae;
        }
        catch (Exception e) {
            OpenEJBErrorHandler.handleUnknownError(e, "Assembler");
            throw new OpenEJBException(e);
        }
        finally {
            context.set(null);
        }
    }

    protected OpenEjbConfiguration getOpenEjbConfiguration() throws OpenEJBException {
        OpenEjbConfiguration config = this.configFactory.getOpenEjbConfiguration();
        return config;
    }

    public void buildContainerSystem(OpenEjbConfiguration configInfo) throws Exception {
        ContainerSystemInfo containerSystemInfo = configInfo.containerSystem;
        if (configInfo.facilities.intraVmServer != null) {
            this.createProxyFactory(configInfo.facilities.intraVmServer);
        }
        for (JndiContextInfo contextInfo : configInfo.facilities.remoteJndiContexts) {
            this.createExternalContext(contextInfo);
        }
        this.createTransactionManager(configInfo.facilities.transactionService);
        this.createSecurityService(configInfo.facilities.securityService);
        for (ResourceInfo resourceInfo : configInfo.facilities.resources) {
            this.createResource(resourceInfo);
        }
        for (ContainerInfo serviceInfo : containerSystemInfo.containers) {
            this.createContainer(serviceInfo);
        }
        for (AppInfo appInfo : containerSystemInfo.applications) {
            try {
                this.createApplication(appInfo, this.createAppClassLoader(appInfo));
            }
            catch (DuplicateDeploymentIdException e) {
            }
            catch (Throwable e) {
                logger.error("appNotDeployed", e, appInfo.jarPath);
            }
        }
    }

    public Collection<AppInfo> getDeployedApplications() {
        return new ArrayList<AppInfo>(this.deployedApplications.values());
    }

    public void createApplication(EjbJarInfo ejbJar) throws NamingException, IOException, OpenEJBException {
        this.createEjbJar(ejbJar);
    }

    public void createEjbJar(EjbJarInfo ejbJar) throws NamingException, IOException, OpenEJBException {
        AppInfo appInfo = new AppInfo();
        appInfo.jarPath = ejbJar.jarPath;
        appInfo.ejbJars.add(ejbJar);
        this.createApplication(appInfo);
    }

    public void createApplication(EjbJarInfo ejbJar, ClassLoader classLoader) throws NamingException, IOException, OpenEJBException {
        this.createEjbJar(ejbJar, classLoader);
    }

    public void createEjbJar(EjbJarInfo ejbJar, ClassLoader classLoader) throws NamingException, IOException, OpenEJBException {
        AppInfo appInfo = new AppInfo();
        appInfo.jarPath = ejbJar.jarPath;
        appInfo.ejbJars.add(ejbJar);
        this.createApplication(appInfo, classLoader);
    }

    public void createClient(ClientInfo clientInfo) throws NamingException, IOException, OpenEJBException {
        AppInfo appInfo = new AppInfo();
        appInfo.jarPath = clientInfo.moduleId;
        appInfo.clients.add(clientInfo);
        this.createApplication(appInfo);
    }

    public void createClient(ClientInfo clientInfo, ClassLoader classLoader) throws NamingException, IOException, OpenEJBException {
        AppInfo appInfo = new AppInfo();
        appInfo.jarPath = clientInfo.moduleId;
        appInfo.clients.add(clientInfo);
        this.createApplication(appInfo, classLoader);
    }

    public void createConnector(ConnectorInfo connectorInfo) throws NamingException, IOException, OpenEJBException {
        AppInfo appInfo = new AppInfo();
        appInfo.jarPath = connectorInfo.moduleId;
        appInfo.connectors.add(connectorInfo);
        this.createApplication(appInfo);
    }

    public void createConnector(ConnectorInfo connectorInfo, ClassLoader classLoader) throws NamingException, IOException, OpenEJBException {
        AppInfo appInfo = new AppInfo();
        appInfo.jarPath = connectorInfo.moduleId;
        appInfo.connectors.add(connectorInfo);
        this.createApplication(appInfo, classLoader);
    }

    public void createWebApp(WebAppInfo webAppInfo) throws NamingException, IOException, OpenEJBException {
        AppInfo appInfo = new AppInfo();
        appInfo.jarPath = webAppInfo.moduleId;
        appInfo.webApps.add(webAppInfo);
        this.createApplication(appInfo);
    }

    public void createWebApp(WebAppInfo webAppInfo, ClassLoader classLoader) throws NamingException, IOException, OpenEJBException {
        AppInfo appInfo = new AppInfo();
        appInfo.jarPath = webAppInfo.moduleId;
        appInfo.webApps.add(webAppInfo);
        this.createApplication(appInfo, classLoader);
    }

    public void createApplication(AppInfo appInfo) throws OpenEJBException, IOException, NamingException {
        this.createApplication(appInfo, this.createAppClassLoader(appInfo));
    }

    public void createApplication(AppInfo appInfo, ClassLoader classLoader) throws OpenEJBException, IOException, NamingException {
        this.createApplication(appInfo, classLoader, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DeploymentInfo> createApplication(AppInfo appInfo, ClassLoader classLoader, boolean start) throws OpenEJBException, IOException, NamingException {
        logger.info("createApplication.start", appInfo.jarPath);
        ArrayList<String> used = new ArrayList<String>();
        for (EjbJarInfo ejbJarInfo : appInfo.ejbJars) {
            for (EnterpriseBeanInfo beanInfo : ejbJarInfo.enterpriseBeans) {
                if (this.containerSystem.getDeploymentInfo(beanInfo.ejbDeploymentId) == null) continue;
                used.add(beanInfo.ejbDeploymentId);
            }
        }
        if (used.size() > 0) {
            String message = logger.error("createApplication.appFailedDuplicateIds", appInfo.jarPath);
            for (String id : used) {
                logger.debug("createApplication.deploymentIdInUse", id);
                message = message + "\n    " + id;
            }
            throw new DuplicateDeploymentIdException(message);
        }
        try {
            CmpJarBuilder cmpJarBuilder = new CmpJarBuilder(appInfo, classLoader);
            File generatedJar = cmpJarBuilder.getJarFile();
            if (generatedJar != null) {
                classLoader = ClassLoaderUtil.createClassLoader(appInfo.jarPath, new URL[]{generatedJar.toURL()}, classLoader);
            }
            PersistenceBuilder persistenceBuilder = new PersistenceBuilder(this.persistenceClassLoaderHandler);
            for (PersistenceUnitInfo info : appInfo.persistenceUnits) {
                try {
                    EntityManagerFactory factory = persistenceBuilder.createEntityManagerFactory(info, classLoader);
                    this.containerSystem.getJNDIContext().bind(PERSISTENCE_UNIT_NAMING_CONTEXT + info.id, (Object)factory);
                }
                catch (NameAlreadyBoundException e) {
                    throw new OpenEJBException("PersistenceUnit already deployed: " + info.persistenceUnitRootUrl);
                }
                catch (Exception e) {
                    throw new OpenEJBException(e);
                }
            }
            for (ConnectorInfo connector : appInfo.connectors) {
                ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(classLoader);
                try {
                    if (connector.resourceAdapter != null) {
                        this.createResource(connector.resourceAdapter);
                    }
                    for (ResourceInfo outbound : connector.outbound) {
                        this.createResource(outbound);
                    }
                    for (MdbContainerInfo inbound : connector.inbound) {
                        this.createContainer(inbound);
                    }
                    for (ResourceInfo adminObject : connector.adminObject) {
                        this.createResource(adminObject);
                    }
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                }
            }
            List<DeploymentInfo> allDeployments = new ArrayList<DeploymentInfo>();
            EjbJarBuilder ejbJarBuilder = new EjbJarBuilder(this.props, classLoader);
            for (EjbJarInfo ejbJar : appInfo.ejbJars) {
                HashMap<String, DeploymentInfo> deployments = ejbJarBuilder.build(ejbJar);
                JaccPermissionsBuilder jaccPermissionsBuilder = new JaccPermissionsBuilder();
                PolicyContext policyContext = jaccPermissionsBuilder.build(ejbJar, deployments);
                if (System.getProperty(DUCT_TAPE_PROPERTY) == null) {
                    jaccPermissionsBuilder.install(policyContext);
                }
                MethodScheduleBuilder methodScheduleBuilder = new MethodScheduleBuilder(classLoader, ejbJar);
                TransactionPolicyFactory transactionPolicyFactory = this.createTransactionPolicyFactory(ejbJar, classLoader);
                for (DeploymentInfo deploymentInfo : deployments.values()) {
                    CoreDeploymentInfo coreDeploymentInfo = (CoreDeploymentInfo)deploymentInfo;
                    methodScheduleBuilder.build(coreDeploymentInfo);
                    coreDeploymentInfo.setTransactionPolicyFactory(transactionPolicyFactory);
                }
                MethodTransactionBuilder methodTransactionBuilder = new MethodTransactionBuilder();
                methodTransactionBuilder.build(deployments, ejbJar.methodTransactions);
                MethodConcurrencyBuilder methodConcurrencyBuilder = new MethodConcurrencyBuilder();
                methodConcurrencyBuilder.build(deployments, ejbJar.methodConcurrency);
                for (DeploymentInfo deploymentInfo : deployments.values()) {
                    this.containerSystem.addDeployment(deploymentInfo);
                }
                this.jndiBuilder.build(ejbJar, deployments);
                for (DeploymentInfo deploymentInfo : deployments.values()) {
                    CoreDeploymentInfo coreDeploymentInfo = (CoreDeploymentInfo)deploymentInfo;
                    if (coreDeploymentInfo.getComponentType() == BeanType.STATEFUL) continue;
                    Method ejbTimeout = coreDeploymentInfo.getEjbTimeout();
                    if (ejbTimeout != null) {
                        if (coreDeploymentInfo.getTransactionType(ejbTimeout) == TransactionType.RequiresNew) {
                            coreDeploymentInfo.setMethodTransactionAttribute(ejbTimeout, "Required");
                        }
                        EjbTimerServiceImpl timerService = new EjbTimerServiceImpl(coreDeploymentInfo);
                        coreDeploymentInfo.setEjbTimerService(timerService);
                        continue;
                    }
                    coreDeploymentInfo.setEjbTimerService(new NullEjbTimerServiceImpl());
                }
                for (ApplicationExceptionInfo exceptionInfo : ejbJar.applicationException) {
                    try {
                        Class<?> exceptionClass = classLoader.loadClass(exceptionInfo.exceptionClass);
                        for (DeploymentInfo deploymentInfo : deployments.values()) {
                            CoreDeploymentInfo coreDeploymentInfo = (CoreDeploymentInfo)deploymentInfo;
                            coreDeploymentInfo.addApplicationException(exceptionClass, exceptionInfo.rollback);
                        }
                    }
                    catch (ClassNotFoundException e) {
                        logger.error("createApplication.invalidClass", e, exceptionInfo.exceptionClass, e.getMessage());
                    }
                }
                allDeployments.addAll(deployments.values());
            }
            allDeployments = Assembler.sort(allDeployments);
            if (start) {
                for (DeploymentInfo deployment : allDeployments) {
                    try {
                        Container container = deployment.getContainer();
                        container.deploy(deployment);
                        logger.info("createApplication.createdEjb", deployment.getDeploymentID(), deployment.getEjbName(), container.getContainerID());
                    }
                    catch (Throwable t) {
                        throw new OpenEJBException("Error deploying '" + deployment.getEjbName() + "'.  Exception: " + t.getClass() + ": " + t.getMessage(), t);
                    }
                }
            }
            for (ClientInfo clientInfo : appInfo.clients) {
                InjectionBuilder injectionBuilder = new InjectionBuilder(classLoader);
                List<Injection> injections = injectionBuilder.buildInjections(clientInfo.jndiEnc);
                JndiEncBuilder jndiEncBuilder = new JndiEncBuilder(clientInfo.jndiEnc, injections, "Bean", clientInfo.moduleId, classLoader);
                jndiEncBuilder.setClient(true);
                jndiEncBuilder.setUseCrossClassLoaderRef(false);
                Context context = (Context)jndiEncBuilder.build().lookup("comp/env");
                this.containerSystem.getJNDIContext().bind("openejb/client/" + clientInfo.moduleId + "/comp/env", (Object)context);
                if (clientInfo.codebase != null) {
                    this.containerSystem.getJNDIContext().bind("openejb/client/" + clientInfo.moduleId + "/comp/path", (Object)clientInfo.codebase);
                }
                if (clientInfo.mainClass != null) {
                    this.containerSystem.getJNDIContext().bind("openejb/client/" + clientInfo.moduleId + "/comp/mainClass", (Object)clientInfo.mainClass);
                }
                if (clientInfo.callbackHandler != null) {
                    this.containerSystem.getJNDIContext().bind("openejb/client/" + clientInfo.moduleId + "/comp/callbackHandler", (Object)clientInfo.callbackHandler);
                }
                this.containerSystem.getJNDIContext().bind("openejb/client/" + clientInfo.moduleId + "/comp/injections", injections);
                for (String clientClassName : clientInfo.remoteClients) {
                    this.containerSystem.getJNDIContext().bind("openejb/client/" + clientClassName, (Object)clientInfo.moduleId);
                }
                for (String clientClassName : clientInfo.localClients) {
                    this.containerSystem.getJNDIContext().bind("openejb/client/" + clientClassName, (Object)clientInfo.moduleId);
                    logger.getChildLogger("client").info("createApplication.createLocalClient", clientClassName, clientInfo.moduleId);
                }
            }
            SystemInstance systemInstance = SystemInstance.get();
            WebAppBuilder webAppBuilder = systemInstance.getComponent(WebAppBuilder.class);
            if (webAppBuilder != null) {
                webAppBuilder.deployWebApps(appInfo, classLoader);
            }
            if (start) {
                EjbResolver globalEjbResolver = systemInstance.getComponent(EjbResolver.class);
                globalEjbResolver.addAll(appInfo.ejbJars);
            }
            logger.info("createApplication.success", appInfo.jarPath);
            this.deployedApplications.put(appInfo.jarPath, appInfo);
            this.fireAfterApplicationCreated(appInfo);
            return allDeployments;
        }
        catch (Throwable t) {
            try {
                this.destroyApplication(appInfo);
            }
            catch (Exception e1) {
                logger.debug("createApplication.undeployFailed", e1, appInfo.jarPath);
            }
            throw new OpenEJBException(this.messages.format("createApplication.failed", appInfo.jarPath), t);
        }
    }

    private TransactionPolicyFactory createTransactionPolicyFactory(EjbJarInfo ejbJar, ClassLoader classLoader) {
        TransactionPolicyFactory factory = null;
        Object value = ejbJar.properties.get(TransactionPolicyFactory.class.getName());
        if (value instanceof TransactionPolicyFactory) {
            factory = (TransactionPolicyFactory)value;
        } else if (value instanceof String) {
            try {
                String[] parts = ((String)value).split(":", 2);
                ResourceFinder finder = new ResourceFinder("META-INF", classLoader);
                Map plugins = finder.mapAvailableImplementations(TransactionPolicyFactory.class);
                Class<TransactionPolicyFactory> clazz = ((Class)plugins.get(parts[0])).asSubclass(TransactionPolicyFactory.class);
                if (clazz != null) {
                    factory = parts.length == 1 ? clazz.getConstructor(String.class).newInstance(parts[1]) : clazz.newInstance();
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        if (factory == null) {
            factory = new JtaTransactionPolicyFactory(this.transactionManager);
        }
        return factory;
    }

    private static List<DeploymentInfo> sort(List<DeploymentInfo> deployments) {
        deployments = References.sort(deployments, new References.Visitor<DeploymentInfo>(){

            @Override
            public String getName(DeploymentInfo t) {
                return (String)t.getDeploymentID();
            }

            @Override
            public Set<String> getReferences(DeploymentInfo t) {
                return t.getDependsOn();
            }
        });
        Collections.sort(deployments, new Comparator<DeploymentInfo>(){

            @Override
            public int compare(DeploymentInfo a, DeploymentInfo b) {
                int aa = a.getComponentType() == BeanType.SINGLETON ? 1 : 0;
                int bb = b.getComponentType() == BeanType.SINGLETON ? 1 : 0;
                return aa - bb;
            }
        });
        Collections.sort(deployments, new Comparator<DeploymentInfo>(){

            @Override
            public int compare(DeploymentInfo a, DeploymentInfo b) {
                int aa = a.getComponentType() == BeanType.MESSAGE_DRIVEN ? 1 : 0;
                int bb = b.getComponentType() == BeanType.MESSAGE_DRIVEN ? 1 : 0;
                return aa - bb;
            }
        });
        return deployments;
    }

    @Override
    public void destroy() {
        logger.debug("Undeploying Applications");
        Assembler assembler = this;
        for (AppInfo appInfo : assembler.getDeployedApplications()) {
            try {
                assembler.destroyApplication(appInfo.jarPath);
            }
            catch (UndeployException e) {
                logger.error("Undeployment failed: " + appInfo.jarPath, e);
            }
            catch (NoSuchApplicationException e) {}
        }
        NamingEnumeration<Binding> namingEnumeration = null;
        try {
            namingEnumeration = this.containerSystem.getJNDIContext().listBindings("openejb/Resource");
        }
        catch (NamingException ignored) {
            // empty catch block
        }
        while (namingEnumeration != null && namingEnumeration.hasMoreElements()) {
            Binding binding = (Binding)namingEnumeration.nextElement();
            Object object = binding.getObject();
            if (!(object instanceof ResourceAdapter)) continue;
            ResourceAdapter resourceAdapter = (ResourceAdapter)object;
            try {
                logger.info("Stopping ResourceAdapter: " + binding.getName());
                resourceAdapter.stop();
            }
            catch (Exception e) {
                logger.fatal("ResourceAdapter Shutdown Failed: " + binding.getName(), e);
            }
        }
        SystemInstance.get().removeComponent(OpenEjbConfiguration.class);
        SystemInstance.get().removeComponent(JtaEntityManagerRegistry.class);
        SystemInstance.get().removeComponent(TransactionSynchronizationRegistry.class);
        SystemInstance.get().removeComponent(EjbResolver.class);
        SystemInstance.reset();
    }

    public void destroyApplication(String filePath) throws UndeployException, NoSuchApplicationException {
        AppInfo appInfo = this.deployedApplications.remove(filePath);
        if (appInfo == null) {
            throw new NoSuchApplicationException(filePath);
        }
        this.destroyApplication(appInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyApplication(AppInfo appInfo) throws UndeployException {
        logger.info("destroyApplication.start", appInfo.jarPath);
        this.fireBeforeApplicationDestroyed(appInfo);
        EjbResolver globalResolver = new EjbResolver(null, EjbResolver.Scope.GLOBAL, new EjbJarInfo[0]);
        for (AppInfo info : this.deployedApplications.values()) {
            globalResolver.addAll(info.ejbJars);
        }
        SystemInstance.get().setComponent(EjbResolver.class, globalResolver);
        Context globalContext = this.containerSystem.getJNDIContext();
        UndeployException undeployException = new UndeployException(this.messages.format("destroyApplication.failed", appInfo.jarPath));
        WebAppBuilder webAppBuilder = SystemInstance.get().getComponent(WebAppBuilder.class);
        if (webAppBuilder != null) {
            try {
                webAppBuilder.undeployWebApps(appInfo);
            }
            catch (Exception e) {
                undeployException.getCauses().add(new Exception("App: " + appInfo.jarPath + ": " + e.getMessage(), e));
            }
        }
        List<DeploymentInfo> deployments = new ArrayList<DeploymentInfo>();
        for (EjbJarInfo ejbJarInfo : appInfo.ejbJars) {
            for (EnterpriseBeanInfo beanInfo : ejbJarInfo.enterpriseBeans) {
                String deploymentId = beanInfo.ejbDeploymentId;
                CoreDeploymentInfo deployment = (CoreDeploymentInfo)this.containerSystem.getDeploymentInfo(deploymentId);
                if (deployment == null) {
                    undeployException.getCauses().add(new Exception("deployment not found: " + deploymentId));
                    continue;
                }
                deployments.add(deployment);
            }
        }
        deployments = Assembler.sort(deployments);
        Collections.reverse(deployments);
        for (DeploymentInfo deployment : deployments) {
            String deploymentID = deployment.getDeploymentID() + "";
            try {
                Container container = deployment.getContainer();
                container.undeploy(deployment);
                deployment.setContainer(null);
            }
            catch (Throwable t) {
                undeployException.getCauses().add(new Exception("bean: " + deploymentID + ": " + t.getMessage(), t));
            }
            finally {
                ((CoreDeploymentInfo)deployment).setDestroyed(true);
            }
        }
        ArrayList<String> clientIds = new ArrayList<String>();
        for (ClientInfo clientInfo : appInfo.clients) {
            clientIds.add(clientInfo.moduleId);
            for (String className : clientInfo.localClients) {
                clientIds.add(className);
            }
            for (String className : clientInfo.remoteClients) {
                clientIds.add(className);
            }
        }
        for (DeploymentInfo deployment : deployments) {
            JndiBuilder.Bindings bindings;
            String deploymentID = deployment.getDeploymentID() + "";
            try {
                this.containerSystem.removeDeploymentInfo(deployment);
            }
            catch (Throwable t) {
                undeployException.getCauses().add(new Exception(deploymentID, t));
            }
            if ((bindings = deployment.get(JndiBuilder.Bindings.class)) == null) continue;
            for (String name : bindings.getBindings()) {
                try {
                    globalContext.unbind(name);
                }
                catch (Throwable t) {
                    undeployException.getCauses().add(new Exception("bean: " + deploymentID + ": " + t.getMessage(), t));
                }
            }
        }
        for (PersistenceUnitInfo unitInfo : appInfo.persistenceUnits) {
            try {
                Object object = globalContext.lookup(PERSISTENCE_UNIT_NAMING_CONTEXT + unitInfo.id);
                globalContext.unbind(PERSISTENCE_UNIT_NAMING_CONTEXT + unitInfo.id);
                ((EntityManagerFactory)object).close();
                this.persistenceClassLoaderHandler.destroy(unitInfo.id);
            }
            catch (Throwable t) {
                undeployException.getCauses().add(new Exception("persistence-unit: " + unitInfo.id + ": " + t.getMessage(), t));
            }
        }
        try {
            if (globalContext instanceof IvmContext) {
                IvmContext ivmContext = (IvmContext)globalContext;
                ivmContext.prune("openejb/Deployment");
                ivmContext.prune("openejb/local");
                ivmContext.prune("openejb/remote");
            }
        }
        catch (NamingException e) {
            undeployException.getCauses().add(new Exception("Unable to prune openejb/Deployments and openejb/local namespaces, this could cause future deployments to fail.", e));
        }
        deployments.clear();
        for (String clientId : clientIds) {
            try {
                globalContext.unbind("/openejb/client/" + clientId);
            }
            catch (Throwable t) {
                undeployException.getCauses().add(new Exception("client: " + clientId + ": " + t.getMessage(), t));
            }
        }
        ClassLoaderUtil.destroyClassLoader(appInfo.jarPath);
        if (undeployException.getCauses().size() > 0) {
            throw undeployException;
        }
        logger.debug("destroyApplication.success", appInfo.jarPath);
    }

    public ClassLoader createAppClassLoader(AppInfo appInfo) throws OpenEJBException, IOException {
        ArrayList<URL> jars = new ArrayList<URL>();
        for (EjbJarInfo ejbJarInfo : appInfo.ejbJars) {
            jars.add(this.toUrl(ejbJarInfo.jarPath));
        }
        for (ClientInfo clientInfo : appInfo.clients) {
            jars.add(this.toUrl(clientInfo.codebase));
        }
        for (ConnectorInfo connectorInfo : appInfo.connectors) {
            for (String jarPath : connectorInfo.libs) {
                jars.add(this.toUrl(jarPath));
            }
        }
        for (String string : appInfo.libs) {
            jars.add(this.toUrl(string));
        }
        URLClassLoader classLoader = ClassLoaderUtil.createClassLoader(appInfo.jarPath, jars.toArray(new URL[jars.size()]), OpenEJB.class.getClassLoader());
        return classLoader;
    }

    public void createExternalContext(JndiContextInfo contextInfo) throws OpenEJBException {
        InitialContext result;
        logger.getChildLogger("service").info("createService", contextInfo.service, contextInfo.id, contextInfo.className);
        try {
            InitialContext ic;
            result = ic = new InitialContext(contextInfo.properties);
        }
        catch (NamingException ne) {
            throw new OpenEJBException("The remote JNDI EJB references for remote-jndi-contexts = " + contextInfo.id + "+ could not be resolved.", ne);
        }
        InitialContext cntx = result;
        try {
            this.containerSystem.getJNDIContext().bind("openejb/remote_jndi_contexts/" + contextInfo.id, (Object)cntx);
        }
        catch (NamingException e) {
            throw new OpenEJBException("Cannot bind " + contextInfo.service + " with id " + contextInfo.id, e);
        }
        this.config.facilities.remoteJndiContexts.add(contextInfo);
        logger.getChildLogger("service").debug("createService.success", contextInfo.service, contextInfo.id, contextInfo.className);
    }

    public void createContainer(ContainerInfo serviceInfo) throws OpenEJBException {
        ObjectRecipe serviceRecipe = this.createRecipe(serviceInfo);
        serviceRecipe.setProperty("id", (Object)serviceInfo.id);
        serviceRecipe.setProperty("transactionManager", this.props.get(TransactionManager.class.getName()));
        serviceRecipe.setProperty("securityService", this.props.get(SecurityService.class.getName()));
        serviceRecipe.setProperty("properties", (Object)new UnsetPropertiesRecipe());
        this.replaceResourceAdapterProperty(serviceRecipe);
        Object service = serviceRecipe.create();
        this.logUnusedProperties(serviceRecipe, (ServiceInfo)serviceInfo);
        Class interfce = (Class)serviceInterfaces.get(serviceInfo.service);
        Assembler.checkImplementation(interfce, service.getClass(), serviceInfo.service, serviceInfo.id);
        this.bindService(serviceInfo, service);
        this.setSystemInstanceComponent(interfce, service);
        this.props.put(interfce.getName(), service);
        this.props.put(serviceInfo.service, service);
        this.props.put(serviceInfo.id, service);
        this.containerSystem.addContainer(serviceInfo.id, (Container)service);
        this.config.containerSystem.containers.add(serviceInfo);
        logger.getChildLogger("service").debug("createService.success", serviceInfo.service, serviceInfo.id, serviceInfo.className);
    }

    private void bindService(ServiceInfo serviceInfo, Object service) throws OpenEJBException {
        try {
            this.containerSystem.getJNDIContext().bind(JAVA_OPENEJB_NAMING_CONTEXT + serviceInfo.service + "/" + serviceInfo.id, service);
        }
        catch (NamingException e) {
            throw new OpenEJBException(this.messages.format("assembler.cannotBindServiceWithId", serviceInfo.service, serviceInfo.id), e);
        }
    }

    public void removeContainer(String containerId) {
        this.containerSystem.removeContainer(containerId);
        Iterator<ContainerInfo> iterator = this.config.containerSystem.containers.iterator();
        while (iterator.hasNext()) {
            ContainerInfo containerInfo = iterator.next();
            if (!containerInfo.id.equals(containerId)) continue;
            iterator.remove();
            try {
                this.containerSystem.getJNDIContext().unbind(JAVA_OPENEJB_NAMING_CONTEXT + containerInfo.service + "/" + containerInfo.id);
            }
            catch (Exception e) {
                logger.error("removeContainer.unbindFailed", containerId);
            }
        }
    }

    public void createProxyFactory(ProxyFactoryInfo serviceInfo) throws OpenEJBException {
        ObjectRecipe serviceRecipe = this.createRecipe(serviceInfo);
        Object service = serviceRecipe.create();
        this.logUnusedProperties(serviceRecipe, (ServiceInfo)serviceInfo);
        Class interfce = (Class)serviceInterfaces.get(serviceInfo.service);
        Assembler.checkImplementation(interfce, service.getClass(), serviceInfo.service, serviceInfo.id);
        ProxyManager.registerFactory(serviceInfo.id, (ProxyFactory)service);
        ProxyManager.setDefaultFactory(serviceInfo.id);
        this.bindService(serviceInfo, service);
        this.setSystemInstanceComponent(interfce, service);
        Assembler.getContext().put(interfce.getName(), service);
        this.props.put(interfce.getName(), service);
        this.props.put(serviceInfo.service, service);
        this.props.put(serviceInfo.id, service);
        this.config.facilities.intraVmServer = serviceInfo;
        logger.getChildLogger("service").debug("createService.success", serviceInfo.service, serviceInfo.id, serviceInfo.className);
    }

    private void replaceResourceAdapterProperty(ObjectRecipe serviceRecipe) throws OpenEJBException {
        Object resourceAdapterId = serviceRecipe.getProperty("ResourceAdapter");
        if (resourceAdapterId instanceof String) {
            String id = (String)resourceAdapterId;
            id = id.trim();
            Object resourceAdapter = null;
            try {
                resourceAdapter = this.containerSystem.getJNDIContext().lookup("openejb/Resource/" + id);
            }
            catch (NamingException e) {
                // empty catch block
            }
            if (resourceAdapter == null) {
                throw new OpenEJBException("No existing resource adapter defined with id '" + id + "'.");
            }
            if (!(resourceAdapter instanceof ResourceAdapter)) {
                throw new OpenEJBException(this.messages.format("assembler.resourceAdapterNotResourceAdapter", id, resourceAdapter.getClass()));
            }
            serviceRecipe.setProperty("ResourceAdapter", resourceAdapter);
        }
    }

    public void createResource(ResourceInfo serviceInfo) throws OpenEJBException {
        ObjectRecipe serviceRecipe = this.createRecipe(serviceInfo);
        serviceRecipe.setProperty("transactionManager", (Object)this.transactionManager);
        serviceRecipe.setProperty("properties", (Object)new UnsetPropertiesRecipe());
        this.replaceResourceAdapterProperty(serviceRecipe);
        Object service = serviceRecipe.create();
        if (service instanceof ResourceAdapter) {
            SimpleWorkManager workManager;
            ResourceAdapter resourceAdapter = (ResourceAdapter)service;
            int threadPoolSize = this.getIntProperty(serviceInfo.properties, "threadPoolSize", 30);
            ExecutorService threadPool = threadPoolSize <= 0 ? Executors.newCachedThreadPool(new ResourceAdapterThreadFactory(serviceInfo.id)) : Executors.newFixedThreadPool(threadPoolSize, new ResourceAdapterThreadFactory(serviceInfo.id));
            if (this.transactionManager instanceof GeronimoTransactionManager) {
                GeronimoTransactionManager geronimoTransactionManager = (GeronimoTransactionManager)this.transactionManager;
                workManager = new GeronimoWorkManager((Executor)threadPool, (Executor)threadPool, (Executor)threadPool, (XAWork)geronimoTransactionManager);
            } else {
                workManager = new SimpleWorkManager(threadPool);
            }
            SimpleBootstrapContext bootstrapContext = this.transactionManager instanceof XATerminator ? new SimpleBootstrapContext(workManager, (XATerminator)this.transactionManager) : new SimpleBootstrapContext(workManager);
            try {
                logger.debug("createResource.startingResourceAdapter", serviceInfo.id, service.getClass().getName());
                resourceAdapter.start((BootstrapContext)bootstrapContext);
            }
            catch (ResourceAdapterInternalException e) {
                throw new OpenEJBException(e);
            }
            Map unset = serviceRecipe.getUnsetProperties();
            unset.remove("threadPoolSize");
            this.logUnusedProperties(unset, (ServiceInfo)serviceInfo);
        } else if (service instanceof ManagedConnectionFactory) {
            ManagedConnectionFactory managedConnectionFactory = (ManagedConnectionFactory)service;
            ObjectRecipe connectionManagerRecipe = new ObjectRecipe(GeronimoConnectionManagerFactory.class, "create");
            connectionManagerRecipe.allow(Option.CASE_INSENSITIVE_PROPERTIES);
            connectionManagerRecipe.allow(Option.IGNORE_MISSING_PROPERTIES);
            connectionManagerRecipe.setAllProperties((Map)serviceInfo.properties);
            connectionManagerRecipe.setProperty("name", (Object)serviceInfo.id);
            connectionManagerRecipe.setProperty("transactionManager", (Object)this.transactionManager);
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            if (classLoader == null) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            connectionManagerRecipe.setProperty("classLoader", (Object)classLoader);
            logger.getChildLogger("service").info("createResource.createConnectionManager", serviceInfo.id, service.getClass().getName());
            ConnectionManager connectionManager = (ConnectionManager)connectionManagerRecipe.create();
            if (connectionManager == null) {
                throw new RuntimeException(this.messages.format("assembler.invalidConnectionManager", serviceInfo.id));
            }
            Map unsetA = serviceRecipe.getUnsetProperties();
            Map unsetB = connectionManagerRecipe.getUnsetProperties();
            HashMap<String, Object> unset = new HashMap<String, Object>();
            for (Map.Entry entry : unsetA.entrySet()) {
                if (!unsetB.containsKey(entry.getKey())) continue;
                unset.put((String)entry.getKey(), entry.getValue());
            }
            this.logUnusedProperties(unset, (ServiceInfo)serviceInfo);
            service = new ConnectorReference(connectionManager, managedConnectionFactory);
        } else {
            this.logUnusedProperties(serviceRecipe, (ServiceInfo)serviceInfo);
        }
        try {
            this.containerSystem.getJNDIContext().bind("openejb/Resource/" + serviceInfo.id, service);
        }
        catch (NamingException e) {
            throw new OpenEJBException("Cannot bind resource adapter with id " + serviceInfo.id, e);
        }
        this.config.facilities.resources.add(serviceInfo);
        logger.getChildLogger("service").debug("createService.success", serviceInfo.service, serviceInfo.id, serviceInfo.className);
    }

    private int getIntProperty(Properties properties, String propertyName, int defaultValue) {
        String propertyValue = properties.getProperty(propertyName);
        if (propertyValue == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(propertyValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(propertyName + " is not an integer " + propertyValue, e);
        }
    }

    public void createConnectionManager(ConnectionManagerInfo serviceInfo) throws OpenEJBException {
        ObjectRecipe serviceRecipe = this.createRecipe(serviceInfo);
        Object object = this.props.get("TransactionManager");
        serviceRecipe.setProperty("transactionManager", object);
        Object service = serviceRecipe.create();
        this.logUnusedProperties(serviceRecipe, (ServiceInfo)serviceInfo);
        Class interfce = (Class)serviceInterfaces.get(serviceInfo.service);
        Assembler.checkImplementation(interfce, service.getClass(), serviceInfo.service, serviceInfo.id);
        this.bindService(serviceInfo, service);
        this.setSystemInstanceComponent(interfce, service);
        Assembler.getContext().put(interfce.getName(), service);
        this.props.put(interfce.getName(), service);
        this.props.put(serviceInfo.service, service);
        this.props.put(serviceInfo.id, service);
        this.config.facilities.connectionManagers.add(serviceInfo);
        logger.getChildLogger("service").debug("createService.success", serviceInfo.service, serviceInfo.id, serviceInfo.className);
    }

    public void createSecurityService(SecurityServiceInfo serviceInfo) throws OpenEJBException {
        ObjectRecipe serviceRecipe = this.createRecipe(serviceInfo);
        Object service = serviceRecipe.create();
        this.logUnusedProperties(serviceRecipe, (ServiceInfo)serviceInfo);
        Class interfce = (Class)serviceInterfaces.get(serviceInfo.service);
        Assembler.checkImplementation(interfce, service.getClass(), serviceInfo.service, serviceInfo.id);
        try {
            this.containerSystem.getJNDIContext().bind(JAVA_OPENEJB_NAMING_CONTEXT + serviceInfo.service, service);
        }
        catch (NamingException e) {
            throw new OpenEJBException("Cannot bind " + serviceInfo.service + " with id " + serviceInfo.id, e);
        }
        this.setSystemInstanceComponent(interfce, service);
        Assembler.getContext().put(interfce.getName(), service);
        this.props.put(interfce.getName(), service);
        this.props.put(serviceInfo.service, service);
        this.props.put(serviceInfo.id, service);
        this.securityService = (SecurityService)service;
        this.config.facilities.securityService = serviceInfo;
        logger.getChildLogger("service").debug("createService.success", serviceInfo.service, serviceInfo.id, serviceInfo.className);
    }

    public void createTransactionManager(TransactionServiceInfo serviceInfo) throws OpenEJBException {
        ObjectRecipe serviceRecipe = this.createRecipe(serviceInfo);
        Object service = serviceRecipe.create();
        this.logUnusedProperties(serviceRecipe, (ServiceInfo)serviceInfo);
        Class interfce = (Class)serviceInterfaces.get(serviceInfo.service);
        Assembler.checkImplementation(interfce, service.getClass(), serviceInfo.service, serviceInfo.id);
        try {
            this.containerSystem.getJNDIContext().bind(JAVA_OPENEJB_NAMING_CONTEXT + serviceInfo.service, service);
            this.containerSystem.getJNDIContext().bind("comp/UserTransaction", (Object)new CoreUserTransaction((TransactionManager)service));
            this.containerSystem.getJNDIContext().bind("comp/TransactionManager", service);
        }
        catch (NamingException e) {
            throw new OpenEJBException("Cannot bind " + serviceInfo.service + " with id " + serviceInfo.id, e);
        }
        this.setSystemInstanceComponent(interfce, service);
        Assembler.getContext().put(interfce.getName(), service);
        this.props.put(interfce.getName(), service);
        this.props.put(serviceInfo.service, service);
        this.props.put(serviceInfo.id, service);
        this.transactionManager = (TransactionManager)service;
        this.config.facilities.transactionService = serviceInfo;
        Object synchronizationRegistry = this.transactionManager instanceof TransactionSynchronizationRegistry ? (TransactionSynchronizationRegistry)this.transactionManager : new SimpleTransactionSynchronizationRegistry(this.transactionManager);
        Assembler.getContext().put(TransactionSynchronizationRegistry.class.getName(), synchronizationRegistry);
        SystemInstance.get().setComponent(TransactionSynchronizationRegistry.class, synchronizationRegistry);
        try {
            this.containerSystem.getJNDIContext().bind("comp/TransactionSynchronizationRegistry", (Object)new TransactionSynchronizationRegistryWrapper());
        }
        catch (NamingException e) {
            throw new OpenEJBException("Cannot bind java:comp/TransactionSynchronizationRegistry", e);
        }
        JtaEntityManagerRegistry jtaEntityManagerRegistry = new JtaEntityManagerRegistry((TransactionSynchronizationRegistry)synchronizationRegistry);
        Assembler.getContext().put(JtaEntityManagerRegistry.class.getName(), jtaEntityManagerRegistry);
        SystemInstance.get().setComponent(JtaEntityManagerRegistry.class, jtaEntityManagerRegistry);
        logger.getChildLogger("service").debug("createService.success", serviceInfo.service, serviceInfo.id, serviceInfo.className);
    }

    private void logUnusedProperties(ObjectRecipe serviceRecipe, ServiceInfo info) {
        Map unsetProperties = serviceRecipe.getUnsetProperties();
        this.logUnusedProperties(unsetProperties, info);
    }

    private void logUnusedProperties(Map<String, Object> unsetProperties, ServiceInfo info) {
        for (String property : unsetProperties.keySet()) {
            if (property.equalsIgnoreCase("properties")) {
                return;
            }
            if (property.equalsIgnoreCase("transactionManager")) {
                return;
            }
            if (info.types.contains("javax.mail.Session")) {
                return;
            }
            logger.getChildLogger("service").warning("unusedProperty", property, info.id);
        }
    }

    private ObjectRecipe createRecipe(ServiceInfo info) {
        Logger serviceLogger = logger.getChildLogger("service");
        serviceLogger.info("createService", info.service, info.id, info.className);
        String[] constructorArgs = info.constructorArgs.toArray(new String[info.constructorArgs.size()]);
        ObjectRecipe serviceRecipe = new ObjectRecipe(info.className, info.factoryMethod, constructorArgs, null);
        serviceRecipe.allow(Option.CASE_INSENSITIVE_PROPERTIES);
        serviceRecipe.allow(Option.IGNORE_MISSING_PROPERTIES);
        serviceRecipe.setAllProperties((Map)info.properties);
        if (serviceLogger.isDebugEnabled()) {
            for (Map.Entry entry : serviceRecipe.getProperties().entrySet()) {
                serviceLogger.debug("createService.props", entry.getKey(), entry.getValue());
            }
        }
        return serviceRecipe;
    }

    private void setSystemInstanceComponent(Class interfce, Object service) {
        SystemInstance.get().setComponent(interfce, service);
    }

    private URL toUrl(String jarPath) throws OpenEJBException {
        try {
            return new File(jarPath).toURL();
        }
        catch (MalformedURLException e) {
            throw new OpenEJBException(this.messages.format("cl0001", jarPath, e.getMessage()), e);
        }
    }

    static {
        AsmParameterNameLoader.install();
        logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP, Assembler.class);
        context = new ThreadLocal();
    }

    private static class ResourceAdapterThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final String namePrefix;
        private final AtomicInteger threadNumber = new AtomicInteger(1);

        ResourceAdapterThreadFactory(String resourceAdapterName) {
            SecurityManager securityManager = System.getSecurityManager();
            this.group = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = resourceAdapterName + "-worker-";
        }

        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(this.group, runnable, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (!thread.isDaemon()) {
                thread.setDaemon(true);
            }
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            return thread;
        }
    }

    private static class PersistenceClassLoaderHandlerImpl
    implements PersistenceClassLoaderHandler {
        private final Map<String, List<ClassFileTransformer>> transformers = new TreeMap<String, List<ClassFileTransformer>>();

        private PersistenceClassLoaderHandlerImpl() {
        }

        public void addTransformer(String unitId, ClassLoader classLoader, ClassFileTransformer classFileTransformer) {
            Instrumentation instrumentation = Agent.getInstrumentation();
            if (instrumentation != null) {
                instrumentation.addTransformer(classFileTransformer);
                if (unitId != null) {
                    List<ClassFileTransformer> transformers = this.transformers.get(unitId);
                    if (transformers == null) {
                        transformers = new ArrayList<ClassFileTransformer>(1);
                        this.transformers.put(unitId, transformers);
                    }
                    transformers.add(classFileTransformer);
                }
            } else {
                logger.error("assembler.noAgent");
            }
        }

        public void destroy(String unitId) {
            List<ClassFileTransformer> transformers = this.transformers.remove(unitId);
            if (transformers != null) {
                Instrumentation instrumentation = Agent.getInstrumentation();
                if (instrumentation != null) {
                    for (ClassFileTransformer transformer : transformers) {
                        instrumentation.removeTransformer(transformer);
                    }
                } else {
                    logger.error("assembler.noAgent");
                }
            }
        }

        public ClassLoader getNewTempClassLoader(ClassLoader classLoader) {
            return ClassLoaderUtil.createTempClassLoader(classLoader);
        }
    }
}

